/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions.operators;

import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.ICollector;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IVarDescriptionUser;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.AbstractExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.operators.IOperator;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Strings;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IStatement;
import gama.gaml.types.IType;

public class PrimitiveOperator
implements IExpression,
IOperator {
    final Arguments parameters;
    final IExpression target;
    final StatementDescription action;
    final String targetSpecies;

    public PrimitiveOperator(IDescription iDescription, StatementDescription statementDescription, IExpression iExpression, Arguments arguments, boolean bl) {
        this.target = iExpression;
        this.targetSpecies = bl ? iExpression.getGamlType().getSpecies().getName() : (iExpression == null ? iDescription.getSpeciesContext().getName() : null);
        this.action = statementDescription;
        this.parameters = arguments;
    }

    public PrimitiveOperator(StatementDescription statementDescription, IExpression iExpression, Arguments arguments, String string) {
        this.target = iExpression;
        this.targetSpecies = string;
        this.action = statementDescription;
        this.parameters = arguments;
    }

    @Override
    public String getName() {
        return this.action.getName();
    }

    @Override
    public Object value(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent;
        if (iScope == null) {
            return null;
        }
        IAgent iAgent2 = iAgent = this.target == null ? iScope.getAgent() : Cast.asAgent(iScope, this.target.value(iScope));
        if (iAgent == null) {
            GAMA.reportError(iScope, GamaRuntimeException.error("No agent is available to execute operator " + this.getName(), iScope), false);
            return null;
        }
        ISpecies iSpecies = this.targetSpecies != null ? iScope.getModel().getSpecies(this.targetSpecies) : iAgent.getSpecies();
        IStatement.WithArgs withArgs = iSpecies.getAction(this.getName());
        if (withArgs != null) {
            boolean bl = iScope.getRoot() instanceof IExperimentAgent && iAgent instanceof SimulationAgent;
            return iScope.execute(withArgs, iAgent, bl, this.getRuntimeArgs(iScope)).getValue();
        }
        GAMA.reportError(iScope, GamaRuntimeException.warning("The operator " + this.getName() + " is not available in the context of " + String.valueOf(iScope.getAgent()), iScope), false);
        return null;
    }

    public Arguments getRuntimeArgs(IScope iScope) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.resolveAgainst(iScope);
    }

    @Override
    public boolean isConst() {
        return false;
    }

    @Override
    public String getTitle() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("action ").append(this.getName()).append(" defined in species ").append(this.target.getGamlType().getSpeciesName()).append(" returns ").append(this.getGamlType().getName());
        return stringBuilder.toString();
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        return this.action.getDocumentation();
    }

    @Override
    public String getDefiningPlugin() {
        return this.action.getDefiningPlugin();
    }

    @Override
    public String serializeToGaml(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.target != null) {
            AbstractExpression.parenthesize(stringBuilder, this.target);
            stringBuilder.append(".");
        }
        stringBuilder.append(this.literalValue()).append("(");
        this.argsToGaml(stringBuilder, bl);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected String argsToGaml(StringBuilder stringBuilder, boolean bl) {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return "";
        }
        this.parameters.forEachFacet((string, iExpressionDescription) -> {
            if (Strings.isGamaNumber(string).booleanValue()) {
                stringBuilder.append(iExpressionDescription.serializeToGaml(false));
            } else {
                stringBuilder.append((String)string).append(":").append(iExpressionDescription.serializeToGaml(bl));
            }
            stringBuilder.append(", ");
            return true;
        });
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        return stringBuilder.toString();
    }

    @Override
    public void collectUsedVarsOf(SpeciesDescription speciesDescription, ICollector<IVarDescriptionUser> iCollector, ICollector<VariableDescription> iCollector2) {
        if (iCollector.contains(this)) {
            return;
        }
        iCollector.add(this);
        if (this.parameters != null) {
            this.parameters.forEachFacet((string, iExpressionDescription) -> {
                IExpression iExpression = iExpressionDescription.getExpression();
                if (iExpression != null) {
                    iExpression.collectUsedVarsOf(speciesDescription, iCollector, iCollector2);
                }
                return true;
            });
        }
        this.action.collectUsedVarsOf(speciesDescription, iCollector, iCollector2);
    }

    @Override
    public void setName(String string) {
    }

    @Override
    public IType<?> getGamlType() {
        return this.action.getGamlType();
    }

    @Override
    public void dispose() {
        if (this.parameters != null) {
            this.parameters.dispose();
        }
    }

    @Override
    public String literalValue() {
        return this.action.getName();
    }

    @Override
    public IExpression resolveAgainst(IScope iScope) {
        return new PrimitiveOperator(this.action, this.target == null ? null : this.target.resolveAgainst(iScope), this.parameters == null ? null : this.parameters.resolveAgainst(iScope), this.targetSpecies);
    }

    @Override
    public boolean shouldBeParenthesized() {
        return true;
    }

    @Override
    public void visitSuboperators(IOperator.IOperatorVisitor iOperatorVisitor) {
        if (this.parameters != null) {
            this.parameters.forEachFacet((string, iExpressionDescription) -> {
                IExpression iExpression = iExpressionDescription.getExpression();
                if (iExpression instanceof IOperator) {
                    iOperatorVisitor.visit((IOperator)iExpression);
                }
                return true;
            });
        }
    }

    @Override
    public IExpression arg(int n) {
        if (n < 0 || n > this.parameters.size()) {
            return null;
        }
        return this.parameters.getExpr(n);
    }

    @Override
    public OperatorProto getPrototype() {
        return null;
    }
}

