/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.ISaveDelegate;
import gama.core.common.interfaces.ITyped;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.util.FileUtils;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.BufferingController;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IModifiableContainer;
import gama.core.util.file.GamaFile;
import gama.core.util.file.IGamaFile;
import gama.dev.DEBUG;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.expressions.AbstractExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.data.MapExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.save.SaveOptions;
import gama.gaml.types.GamaFileType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="format", type={4}, optional=true, doc={@GamlAnnotations.doc(value="a string representing the format of the output file (e.g. \"shp\", \"asc\", \"geotiff\", \"png\", \"text\", \"csv\"). If the file extension is non ambiguous in facet 'to:', this format does not need to be specified. However, in many cases, it can be useful to do it (for instance, when saving a string to a .pgw file, it is always better to clearly indicate that the expected format is 'text'). ")}), @GamlAnnotations.facet(name="data", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the data that will be saved to the file or the file itself to save when data is used in its simplest form")}), @GamlAnnotations.facet(name="rewrite", type={3}, optional=true, doc={@GamlAnnotations.doc(value="a boolean expression specifying whether to erase the file if it exists or append data at the end of it. Only applicable to \"text\" or \"csv\" files. Default is true")}), @GamlAnnotations.facet(name="header", type={3}, optional=true, doc={@GamlAnnotations.doc(value="an expression that evaluates to a boolean, specifying whether the save will write a header if the file does not exist")}), @GamlAnnotations.facet(name="to", type={4}, optional=true, doc={@GamlAnnotations.doc(value="an expression that evaluates to an string, the path to the file, or directly to a file")}), @GamlAnnotations.facet(name="crs", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the name of the projection, e.g. crs:\"EPSG:4326\" or its EPSG id, e.g. crs:4326. Here a list of the CRS codes (and EPSG id): http://spatialreference.org")}), @GamlAnnotations.facet(name="attributes", type={10, 5}, remote_context=true, optional=true, doc={@GamlAnnotations.doc(value="Allows to specify the attributes of a shape file or GeoJson file where agents are saved. Can be expressed as a list of string or as a literal map. When expressed as a list, each value should represent the name of an attribute of the shape or agent. The keys of the map are the names of the attributes that will be present in the file, the values are whatever expressions neeeded to define their value. ")}), @GamlAnnotations.facet(name="buffering", type={4}, optional=true, doc={@GamlAnnotations.doc(value="Allows to specify a buffering strategy to write the file. Accepted values are `per_cycle` and `per_simulation`, `no_buffering`. In the case of `per_cycle` or `per_simulation`, all the write operations in the simulation which used these values would be executed all at once at the end of the cycle or simulation while keeping the initial order. In case of 'per_agent' all operations will be released when the agent is killed (or the simulation ends). Those strategies can be used to optimise a simulation's execution time on models that extensively write in files. The `no_buffering` (which is the system's default) will directly write into the file.")})}, omissible="data")
@GamlAnnotations.doc(value="Allows to save data in a file.", usages={@GamlAnnotations.usage(value="Its simple syntax is:", examples={@GamlAnnotations.example(value="save data to: output_file format: a_file_format;", isExecutable=false)}), @GamlAnnotations.usage(value="To save data in a text file:", examples={@GamlAnnotations.example(value="save (string(cycle) + \"->\"  + name + \":\" + location) to: \"save_data.txt\" format: \"text\";")}), @GamlAnnotations.usage(value="To save the values of some attributes of the current agent in csv file:", examples={@GamlAnnotations.example(value="save [name, location, host] to: \"save_data.csv\" format: \"csv\";")}), @GamlAnnotations.usage(value="To save the values of all attributes of all the agents of a species into a csv (with optional attributes):", examples={@GamlAnnotations.example(value="save species_of(self) to: \"save_csvfile.csv\" format: \"csv\" header: false;")}), @GamlAnnotations.usage(value="To save the geometries of all the agents of a species into a shapefile (with optional attributes):", examples={@GamlAnnotations.example(value="save species_of(self) to: \"save_shapefile.shp\" format: \"shp\" attributes: ['nameAgent'::name, 'locationAgent'::location] crs: \"EPSG:4326\";")}), @GamlAnnotations.usage(value="To save the grid_value attributes of all the cells of a grid into an ESRI ASCII Raster file:", examples={@GamlAnnotations.example(value="save grid to: \"save_grid.asc\" format: \"asc\";")}), @GamlAnnotations.usage(value="To save the grid_value attributes of all the cells of a grid into geotiff:", examples={@GamlAnnotations.example(value="save grid to: \"save_grid.tif\" format: \"geotiff\";")}), @GamlAnnotations.usage(value="To save the grid_value attributes of all the cells of a grid into png (with a worldfile):", examples={@GamlAnnotations.example(value="save grid to: \"save_grid.png\" format: \"image\";")}), @GamlAnnotations.usage(value="The save statement can be use in an init block, a reflex, an action or in a user command. Do not use it in experiments.")})
@validator(value=SaveValidator.class)
public class SaveStatement
extends AbstractStatementSequence {
    public static final Set<String> NON_SAVEABLE_ATTRIBUTE_NAMES = Set.of("peers", "location", "host", "agents", "members", "shape");
    private static final String EPSG_LABEL = "EPSG:";
    private static final Map<String, Map<IType, ISaveDelegate>> DELEGATES = new HashMap<String, Map<IType, ISaveDelegate>>();
    private static final SetMultimap<String, String> SYNONYMS = TreeMultimap.create();
    private final IExpression attributesFacet;
    private final IExpression item;
    private final IExpression file;
    private final IExpression format;
    private final IExpression rewriteExpr;
    private final IExpression bufferingStrategy;

    public static void addDelegate(ISaveDelegate iSaveDelegate) {
        Set<String> set = iSaveDelegate.getFileTypes();
        iSaveDelegate.getSynonyms().forEach((string, string2) -> {
            SYNONYMS.put(string, string2);
            SYNONYMS.put(string2, string);
        });
        IType iType = iSaveDelegate.getDataType();
        for (String string3 : set) {
            Map<IType, ISaveDelegate> map = DELEGATES.get(string3);
            if (map == null) {
                map = new HashMap<IType, ISaveDelegate>();
                DELEGATES.put(string3, map);
            }
            if (map.containsKey(iType)) {
                DEBUG.LOG((Object)("WARNING: Extensions to SaveStatement already registered for file type " + string3 + " and data type " + String.valueOf(iType)));
            }
            map.put(iType, iSaveDelegate);
        }
    }

    public SaveStatement(IDescription iDescription) {
        super(iDescription);
        this.item = iDescription.getFacetExpr("data");
        this.file = this.getFacet("to");
        this.format = this.getFacet("format");
        this.rewriteExpr = this.getFacet("rewrite");
        this.attributesFacet = this.getFacet("attributes");
        this.bufferingStrategy = this.getFacet("buffering");
    }

    private boolean shouldOverwrite(IScope iScope) {
        if (this.rewriteExpr == null) {
            return true;
        }
        return Cast.asBool(iScope, this.rewriteExpr.value(iScope));
    }

    protected Object saveFile(IScope iScope) {
        if (!Types.FILE.isAssignableFrom(this.item.getGamlType())) {
            return null;
        }
        IGamaFile iGamaFile = (IGamaFile)this.item.value(iScope);
        if (iGamaFile != null) {
            iGamaFile.save(iScope, this.description.getFacets());
        }
        return iGamaFile;
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Object object;
        if (this.item == null) {
            return null;
        }
        if (this.file == null) {
            return this.saveFile(iScope);
        }
        String string = Cast.asString(iScope, this.file.value(iScope));
        String string2 = FileUtils.constructAbsoluteFilePath(iScope, string, false);
        if (string2 == null || "".equals(string2)) {
            return null;
        }
        File file2 = new File(string2);
        String string3 = this.getLiteral("format");
        if (string3 == null) {
            object = this.item.value(iScope);
            if (object instanceof IModifiableContainer) {
                IModifiableContainer iModifiableContainer = (IModifiableContainer)object;
                try {
                    iScope.setData("key_temporary_output", true);
                    IGamaFile iGamaFile = GamaFileType.createFile(iScope, string, false, iModifiableContainer);
                    iGamaFile.save(iScope, this.description.getFacets());
                    IGamaFile iGamaFile2 = iGamaFile;
                    return iGamaFile2;
                }
                catch (GamaFile.FlushBufferException flushBufferException) {
                    DEBUG.OUT((Object)flushBufferException.getMessage());
                }
                finally {
                    iScope.setData("key_temporary_output", null);
                }
            }
            string3 = com.google.common.io.Files.getFileExtension((String)string);
        }
        if (string3 != null && !DELEGATES.containsKey(string3) && this.format != null && this.format.getGamlType() == Types.STRING && !DELEGATES.containsKey(string3 = Cast.asString(iScope, this.format.value(iScope)))) {
            string3 = null;
        }
        object = BufferingController.stringToBufferingStrategies(iScope, (String)GamaPreferences.get("pref_save_buffering_strategy").value(iScope));
        if (this.bufferingStrategy != null) {
            object = BufferingController.stringToBufferingStrategies(iScope, (String)this.bufferingStrategy.value(iScope));
        }
        try {
            ISaveDelegate iSaveDelegate;
            IType<?> iType;
            Files.createDirectories(file2.toPath().getParent(), new FileAttribute[0]);
            boolean bl = file2.exists() || GAMA.getBufferingController().isFileWaitingToBeWritten(file2);
            boolean bl2 = this.shouldOverwrite(iScope);
            IExpression iExpression = this.getFacet("header");
            boolean bl3 = !bl && (iExpression == null || Cast.asBool(iScope, iExpression.value(iScope)) != false);
            String string4 = (string3 != null ? string3 : "text").trim().toLowerCase();
            Object object2 = null;
            IExpression iExpression2 = this.getFacet("crs");
            if (iExpression2 != null) {
                iType = iExpression2.getGamlType();
                if (iType.id() == 1 || iType.id() == 2) {
                    object2 = EPSG_LABEL + String.valueOf(Cast.asInt(iScope, iExpression2.value(iScope)));
                } else if (iType.id() == 4) {
                    object2 = (String)iExpression2.value(iScope);
                }
            }
            if ((iSaveDelegate = this.findDelegate(iType = this.item.getGamlType(), string4)) != null) {
                SaveOptions saveOptions = new SaveOptions((String)object2, bl3, string4, this.attributesFacet, (BufferingController.BufferingStrategies)((Object)object), bl2);
                iSaveDelegate.save(iScope, this.item, file2, saveOptions);
                return Cast.asString(iScope, this.file.value(iScope));
            }
            throw GamaRuntimeException.error("Format not recognized: " + string4, iScope);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            throw gamaRuntimeException;
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.create(iOException, iScope);
        }
    }

    private ISaveDelegate findDelegate(IType iType, String string) {
        Map<IType, ISaveDelegate> map = DELEGATES.get(string);
        if (map == null) {
            return null;
        }
        int n = Integer.MAX_VALUE;
        ISaveDelegate iSaveDelegate = null;
        for (Map.Entry<IType, ISaveDelegate> entry : map.entrySet()) {
            int n2;
            if (!entry.getValue().handlesDataType(iType) || (n2 = iType.distanceTo(entry.getKey())) >= n) continue;
            n = n2;
            iSaveDelegate = entry.getValue();
        }
        return iSaveDelegate;
    }

    public static class SaveValidator
    implements IDescriptionValidator<StatementDescription> {
        @Override
        public void validate(StatementDescription statementDescription) {
            SpeciesDescription speciesDescription;
            ITyped iTyped;
            StatementDescription statementDescription2 = statementDescription;
            IExpression iExpression = statementDescription2.getFacetExpr("attributes");
            IExpressionDescription iExpressionDescription = statementDescription2.getFacet("format");
            IExpression iExpression2 = statementDescription2.getFacetExpr("buffering");
            if (iExpressionDescription != null) {
                statementDescription2.setFacetExprDescription("format", iExpressionDescription);
            }
            IExpression iExpression3 = iExpressionDescription == null ? null : iExpressionDescription.getExpression();
            IExpression iExpression4 = statementDescription2.getFacetExpr("data");
            if (iExpression4 == null) {
                return;
            }
            IType<?> iType = iExpression4.getGamlType();
            IExpression iExpression5 = statementDescription2.getFacetExpr("to");
            boolean bl = Types.FILE.isAssignableFrom(iType);
            String string = null;
            if (iExpression5 != null && iExpression5.isConst()) {
                string = com.google.common.io.Files.getFileExtension((String)iExpression5.literalValue());
            }
            if (bl && iExpression5 != null) {
                statementDescription2.warning("The destination will not be taking into account when saving an already existing file", "gaml.unmatched.operands.issue");
            }
            if (bl && iExpression3 != null) {
                statementDescription2.warning("The file format will not be taken into account when saving an already existing file ", "gaml.conflicting.facets", "format", new String[0]);
            }
            if (!bl && iExpression5 == null) {
                statementDescription2.error("No file specified", "gaml.missing.facet.issue");
                return;
            }
            if (!bl && iExpression3 == null && iExpression5 != null && string != null && !DELEGATES.containsKey(string)) {
                if (iType != Types.STRING && iType != Types.INT && iType != Types.FLOAT) {
                    statementDescription2.error("Unknown file extension. Accepted formats are: " + String.valueOf(DELEGATES.keySet().stream().sorted().toList()), "gaml.unknonw.argument.issue", "to", new String[0]);
                    return;
                }
                statementDescription2.warning("Unknown file format, will default to 'text'. Accepted formats are: " + String.valueOf(DELEGATES.keySet().stream().sorted().toList()), "gaml.unknonw.argument.issue", "to", new String[0]);
            }
            if (!bl && iExpression3 == null && iExpression5 != null) {
                statementDescription2.info("'save' will use the extension of the file to determine its format. If you are unsure about this, please specify the format of the file using the 'format:' facet", "gaml.unknonw.argument.issue");
            }
            if (!bl && iExpression3 != null && iExpression5 != null) {
                String string2 = iExpression3.literalValue();
                if (!DELEGATES.containsKey(string2) && iExpression3.getGamlType() != Types.STRING) {
                    statementDescription2.error("Unknown file format. Accepted formats are: " + String.valueOf(DELEGATES.keySet().stream().sorted().toList()), "gaml.unknonw.argument.issue", "format", new String[0]);
                    return;
                }
                if (string != null && !string2.equals(string) && !this.areSynonyms(string, string2)) {
                    statementDescription2.info("The extension of the file and the format differ. Make sure they are compatible", "gaml.conflicting.facets");
                }
            }
            if (iExpression2 != null && !BufferingController.BUFFERING_STRATEGIES.contains(iExpression2.literalValue())) {
                statementDescription2.error("The value for buffering must be 'no_buffering', 'per_cycle', 'per_agent'' or 'per_simulation'.", "gaml.wrong.type.issue");
            }
            if (iExpression == null) {
                return;
            }
            boolean bl2 = iExpression instanceof MapExpression;
            if (!bl2 && !iExpression.getGamlType().isTranslatableInto(Types.LIST.of(Types.STRING))) {
                statementDescription2.error("attributes must be expressed as a map<string, unknown> or as a list<string>", "gaml.wrong.type.issue", "attributes", new String[0]);
                return;
            }
            if (bl2 && ((AbstractExpression)(iTyped = (MapExpression)iExpression)).getGamlType().getKeyType() != Types.STRING) {
                statementDescription2.error("The type of the keys of the attributes map must be string. These will be used for naming the attributes in the file", "gaml.wrong.type.issue", "attributes", new String[0]);
                return;
            }
            if (string != null && iExpression3 == null && !"shp".equals(string) && !"json".equals(string) && !"geojson".equals(string) || iExpression3 != null && !"shp".equals(iExpression3.literalValue()) && !"geojson".equals(iExpression3.literalValue()) && !"json".equals(iExpression3.literalValue())) {
                statementDescription2.warning("Attributes can only be defined for shape, geojson or json files", "gaml.wrong.type.issue", "attributes", new String[0]);
            }
            if ((speciesDescription = (iTyped = iType.getContentType()).getSpecies()) == null && bl2) {
                statementDescription2.error("Attributes of geometries can only be specified with a list of attribute names", "gaml.unknown.facet.issue", "attributes", new String[0]);
            }
        }

        private boolean areSynonyms(String string, String string2) {
            return SYNONYMS.containsKey((Object)string) ? SYNONYMS.get((Object)string).contains(string2) : false;
        }
    }
}

