/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.geometry;

import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GamaCoordinateSequence;
import gama.core.common.geometry.GamaGeometryFactory;
import gama.core.common.geometry.Rotation3D;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonArray;
import gama.gaml.interfaces.IJsonable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;

public interface ICoordinates
extends CoordinateSequence,
Iterable<GamaPoint>,
IJsonable {
    public static final ICoordinates EMPTY = new GamaCoordinateSequence(3, new Coordinate[0]);

    default public GamaPoint getCenter() {
        GamaPoint gamaPoint = new GamaPoint();
        this.addCenterTo(gamaPoint);
        return gamaPoint;
    }

    default public void getCenter(GamaPoint gamaPoint) {
        gamaPoint.setLocation(0.0, 0.0, 0.0);
        this.addCenterTo(gamaPoint);
    }

    @Deprecated
    default public CoordinateSequence clone() {
        return this.copy();
    }

    public void addCenterTo(GamaPoint var1);

    public GamaPoint getCoordinate(int var1);

    default public GamaPoint at(int n) {
        if (n > this.size() || n < 0) {
            return null;
        }
        return this.getCoordinate(n);
    }

    public ICoordinates yNegated();

    public GamaPoint[] toCoordinateArray();

    public void visit(IndexedVisitor var1, int var2, boolean var3);

    public void visitClockwise(VertexVisitor var1);

    public void visitYNegatedCounterClockwise(VertexVisitor var1);

    public void visit(PairVisitor var1);

    default public GamaPoint getNormal(boolean bl) {
        GamaPoint gamaPoint = new GamaPoint();
        this.getNormal(bl, 1.0, gamaPoint);
        return gamaPoint;
    }

    public void getNormal(boolean var1, double var2, GamaPoint var4);

    public Envelope3D getEnvelopeInto(Envelope3D var1);

    default public Envelope3D getEnvelope() {
        return this.getEnvelopeInto(Envelope3D.create());
    }

    public double averageZ();

    public ICoordinates setTo(GamaPoint ... var1);

    default public ICoordinates setTo(double ... dArray) {
        return this.setTo(0, dArray);
    }

    public ICoordinates setTo(int var1, double ... var2);

    public void replaceWith(int var1, double var2, double var4, double var6);

    public GamaPoint directionBetweenLastPointAndOrigin();

    public void applyRotation(Rotation3D var1);

    public boolean isHorizontal();

    public double getLength();

    public void setAllZ(double var1);

    public boolean isCoveredBy(Envelope3D var1);

    public static ICoordinates ofLength(int n) {
        return GamaGeometryFactory.COORDINATES_FACTORY.create(n, 3);
    }

    public boolean isClockwise();

    public void completeRing();

    public void translateBy(double var1, double var3, double var5);

    public void ensureClockwiseness();

    @Override
    default public JsonArray serializeToJson(Json json) {
        JsonArray jsonArray = json.array();
        GamaPoint gamaPoint = new GamaPoint();
        int n = 0;
        while (n < this.size()) {
            this.getCoordinate(n, gamaPoint);
            jsonArray.add(json.array(gamaPoint.x, gamaPoint.y, gamaPoint.z));
            ++n;
        }
        return jsonArray;
    }

    @FunctionalInterface
    public static interface IndexedVisitor {
        public void process(int var1, double var2, double var4, double var6);
    }

    @FunctionalInterface
    public static interface PairVisitor {
        public void process(GamaPoint var1, GamaPoint var2);
    }

    public static interface VertexVisitor {
        public void process(double ... var1);
    }
}

