/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.server;

import gama.core.common.interfaces.IStatusDisplayer;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.server.GamaServerMessager;
import gama.core.runtime.server.MessageType;

public final class GamaServerStatusDisplayer
extends GamaServerMessager
implements IStatusDisplayer {
    @Override
    public boolean canSendMessage(IExperimentAgent iExperimentAgent) {
        if (iExperimentAgent == null) {
            return false;
        }
        IScope iScope = iExperimentAgent.getScope();
        return iScope != null && iScope.getServerConfiguration().status();
    }

    public void informStatus(IScope iScope, String string) {
        this.canSendMessage(iScope.getExperiment());
        this.sendMessage(iScope.getExperiment(), "{\"message\": \"" + string + "\"}", MessageType.SimulationStatusInform);
    }

    public void errorStatus(IScope iScope, Exception exception) {
        if (!this.canSendMessage(iScope.getExperiment())) {
            return;
        }
        this.sendMessage(iScope.getExperiment(), "{\"message\": \"" + exception.getMessage() + "\"}", MessageType.SimulationStatusError);
    }

    @Override
    public void updateExperimentStatus() {
        if (!this.canSendMessage(GAMA.getExperimentAgent())) {
            return;
        }
        this.sendMessage(GAMA.getExperimentAgent(), this.json.object("message", null, "icon", "overlays/status.clock").toString(), MessageType.SimulationStatusInform);
    }

    public void informStatus(IScope iScope, String string, String string2) {
        if (!this.canSendMessage(iScope.getExperiment())) {
            return;
        }
        this.sendMessage(iScope.getExperiment(), this.json.object("message", string, "icon", string2).toString(), MessageType.SimulationStatusInform);
    }
}

