/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.GamaGeometryFactory;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.GamaGisGeometry;
import gama.core.metamodel.topology.projection.ProjectionFactory;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.GamaFileMetaData;
import gama.core.util.file.GamaGisFile;
import gama.core.util.file.IFileMetaDataProvider;
import gama.core.util.file.ProgressCounter;
import gama.dev.DEBUG;
import gama.gaml.operators.Strings;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Query;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

@GamlAnnotations.file(name="shape", extensions={"shp", "SHP"}, buffer_type=5, buffer_content=13, buffer_index=1, concept={"shapefile", "file"}, doc={@GamlAnnotations.doc(value="Represents a shape file as defined by the ESRI standard. See https://en.wikipedia.org/wiki/Shapefile for more information.")})
public class GamaShapeFile
extends GamaGisFile {
    static {
        DEBUG.ON();
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a shapefile (.shp) file", examples={@GamlAnnotations.example(value="file f <- shape_file(\"file.shp\");", isExecutable=false)})
    public GamaShapeFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string, (Integer)null);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a shapefile (.shp) file and specifying the coordinates system code, as an int (epsg code)", examples={@GamlAnnotations.example(value="file f <- shape_file(\"file.shp\", \"32648\");", isExecutable=false)})
    public GamaShapeFile(IScope iScope, String string, Integer n) throws GamaRuntimeException {
        super(iScope, string, n);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a shapefile (.shp) file and specifying the coordinates system code (epg,...,), as a string", examples={@GamlAnnotations.example(value="file f <- shape_file(\"file.shp\", \"EPSG:32648\");", isExecutable=false)})
    public GamaShapeFile(IScope iScope, String string, String string2) throws GamaRuntimeException {
        super(iScope, string, string2);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a shapefile (.shp) file and take a potential z value (not taken in account by default)", examples={@GamlAnnotations.example(value="file f <- shape_file(\"file.shp\", true);", isExecutable=false)})
    public GamaShapeFile(IScope iScope, String string, boolean bl) throws GamaRuntimeException {
        super(iScope, string, (Integer)null, bl);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a shapefile (.shp) file and specifying the coordinates system code, as an int (epsg code) and take a potential z value (not taken in account by default)", examples={@GamlAnnotations.example(value="file f <- shape_file(\"file.shp\", \"32648\", true);", isExecutable=false)})
    public GamaShapeFile(IScope iScope, String string, Integer n, boolean bl) throws GamaRuntimeException {
        super(iScope, string, n, bl);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a shapefile (.shp) file and specifying the coordinates system code (epg,...,), as a string and take a potential z value (not taken in account by default)", examples={@GamlAnnotations.example(value="file f <- shape_file(\"file.shp\", \"EPSG:32648\",true);", isExecutable=false)})
    public GamaShapeFile(IScope iScope, String string, String string2, boolean bl) throws GamaRuntimeException {
        super(iScope, string, string2, bl);
    }

    @Override
    public IList<String> getAttributes(IScope iScope) {
        ShapeInfo shapeInfo;
        IFileMetaDataProvider iFileMetaDataProvider = iScope.getGui().getMetaDataProvider();
        if (iFileMetaDataProvider != null) {
            shapeInfo = (ShapeInfo)iFileMetaDataProvider.getMetaData(this.getFile(iScope), false, true);
        } else {
            try {
                shapeInfo = new ShapeInfo(iScope, this.getFile(iScope).toURI().toURL(), 0L);
            }
            catch (MalformedURLException malformedURLException) {
                return GamaListFactory.EMPTY_LIST;
            }
        }
        return GamaListFactory.wrap((IType)Types.STRING, shapeInfo.attributes.keySet());
    }

    static FileDataStore getDataStore(URL uRL) {
        FileDataStore fileDataStore;
        try {
            fileDataStore = FileDataStoreFinder.getDataStore((URL)uRL);
        }
        catch (IOException iOException) {
            return null;
        }
        if (fileDataStore instanceof ShapefileDataStore) {
            ShapefileDataStore shapefileDataStore = (ShapefileDataStore)fileDataStore;
            shapefileDataStore.setGeometryFactory((GeometryFactory)GeometryUtils.GEOMETRY_FACTORY);
            shapefileDataStore.setMemoryMapped(GamaPreferences.External.SHAPEFILES_IN_MEMORY.getValue().booleanValue());
            shapefileDataStore.setBufferCachingEnabled(GamaPreferences.External.SHAPEFILES_IN_MEMORY.getValue().booleanValue());
            shapefileDataStore.setCharset(Charset.forName("UTF8"));
        }
        return fileDataStore;
    }

    @Override
    protected final void readShapes(IScope iScope) {
        ProgressCounter progressCounter = new ProgressCounter(iScope, "Reading " + this.getName(iScope));
        SimpleFeatureCollection simpleFeatureCollection = this.getFeatureCollection(iScope);
        this.computeEnvelope(iScope);
        int[] nArray = new int[1];
        try {
            simpleFeatureCollection.accepts(feature -> {
                Geometry geometry = (Geometry)feature.getDefaultGeometryProperty().getValue();
                if (geometry != null && !geometry.isEmpty()) {
                    GamaGisGeometry gamaGisGeometry;
                    if (!this.with3D && geometry.getNumPoints() > 2) {
                        try {
                            if (!geometry.isValid()) {
                                geometry = GeometryUtils.cleanGeometry(geometry);
                            }
                        }
                        catch (Exception exception) {
                            geometry = GeometryUtils.cleanGeometry(geometry);
                        }
                    }
                    geometry = this.gis.transform(geometry);
                    if (!this.with3D) {
                        geometry.apply(ZERO_Z);
                        geometry.geometryChanged();
                    }
                    if ((gamaGisGeometry = new GamaGisGeometry(geometry = this.multiPolygonManagement(geometry), feature)).getInnerGeometry() != null) {
                        ((IList)this.getBuffer()).add(gamaGisGeometry);
                    }
                } else if (geometry == null) {
                    GAMA.reportError(iScope, GamaRuntimeException.warning("geometry #" + nArray[0] + " from " + this.getName(iScope) + " could not be added as it is nil (identifier: " + String.valueOf(feature.getIdentifier()) + ")", iScope), false);
                }
                nArray[0] = nArray[0] + 1;
            }, (ProgressListener)progressCounter);
        }
        catch (Exception exception) {
            try {
                ((IList)this.getBuffer()).clear();
                nArray[0] = 0;
                ShpFiles shpFiles = new ShpFiles(this.getFile(iScope).toURI().toURL());
                Throwable throwable = null;
                Object var7_9 = null;
                try (ShapefileReader shapefileReader = new ShapefileReader(shpFiles, false, false, (GeometryFactory)GeometryUtils.GEOMETRY_FACTORY);){
                    shapefileReader.setFlatGeometry(true);
                    while (shapefileReader.hasNext()) {
                        ShapefileReader.Record record = shapefileReader.nextRecord();
                        Geometry geometry = (Geometry)record.shape();
                        geometry = GeometryUtils.cleanGeometry((Geometry)record.shape());
                        if (geometry != null && !geometry.isEmpty()) {
                            if (!this.with3D && geometry.getNumPoints() > 2) {
                                try {
                                    if (!geometry.isValid()) {
                                        geometry = GeometryUtils.cleanGeometry(geometry);
                                    }
                                }
                                catch (Exception exception2) {
                                    geometry = GeometryUtils.cleanGeometry(geometry);
                                }
                            }
                            geometry = this.gis.transform(geometry);
                            if (!this.with3D) {
                                geometry.apply(ZERO_Z);
                                geometry.geometryChanged();
                            }
                            geometry = this.multiPolygonManagement(geometry);
                            int n = 0;
                            while (n < geometry.getNumGeometries()) {
                                GamaGisGeometry gamaGisGeometry = new GamaGisGeometry(geometry.getGeometryN(n), null);
                                if (gamaGisGeometry.getInnerGeometry() != null) {
                                    ((IList)this.getBuffer()).add(gamaGisGeometry);
                                }
                                ++n;
                            }
                        } else if (geometry == null) {
                            GAMA.reportError(iScope, GamaRuntimeException.warning("geometry #" + nArray[0] + " from " + this.getName(iScope) + " could not be added as it is nil", iScope), false);
                        }
                        nArray[0] = nArray[0] + 1;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                throw GamaRuntimeException.create(iOException, iScope);
            }
        }
    }

    @Override
    protected SimpleFeatureCollection getFeatureCollection(IScope iScope) {
        try {
            SimpleFeatureSource simpleFeatureSource = GamaShapeFile.getDataStore(this.getFile(iScope).toURI().toURL()).getFeatureSource();
            Query query = new Query();
            query.getHints().put((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)GamaGeometryFactory.COORDINATES_FACTORY);
            query.getHints().put((Object)Hints.JTS_GEOMETRY_FACTORY, (Object)GeometryUtils.GEOMETRY_FACTORY);
            SimpleFeatureCollection simpleFeatureCollection = simpleFeatureSource.getFeatures(query);
            if (simpleFeatureSource.getDataStore() != null) {
                simpleFeatureSource.getDataStore().dispose();
            }
            return simpleFeatureCollection;
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.create(iOException, iScope);
        }
    }

    @Override
    public int length(IScope iScope) {
        return super.length(iScope);
    }

    public static class ShapeInfo
    extends GamaFileMetaData {
        final int itemNumber;
        final CoordinateReferenceSystem crs;
        final double width;
        final double height;
        final Map<String, String> attributes = new LinkedHashMap<String, String>();

        public ShapeInfo(IScope iScope, URL uRL, long l) {
            super(l);
            FileDataStore fileDataStore = null;
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope();
            CoordinateReferenceSystem coordinateReferenceSystem = null;
            int n = 0;
            try {
                try {
                    fileDataStore = GamaShapeFile.getDataStore(uRL);
                    SimpleFeatureSource simpleFeatureSource = fileDataStore.getFeatureSource();
                    SimpleFeatureCollection simpleFeatureCollection = simpleFeatureSource.getFeatures();
                    try {
                        coordinateReferenceSystem = simpleFeatureSource.getInfo().getCRS();
                    }
                    catch (Exception exception) {
                        DEBUG.ERR((Object)("Ignored exception in ShapeInfo getCRS:" + exception.getMessage()));
                    }
                    referencedEnvelope = simpleFeatureSource.getBounds();
                    if (coordinateReferenceSystem == null && (coordinateReferenceSystem = ProjectionFactory.manageGoogleCRS(uRL)) != null) {
                        referencedEnvelope = new ReferencedEnvelope((Envelope)referencedEnvelope, coordinateReferenceSystem);
                    }
                    if (coordinateReferenceSystem != null) {
                        try {
                            referencedEnvelope = referencedEnvelope.transform(new ProjectionFactory().getTargetCRS(iScope), true);
                        }
                        catch (Exception exception) {
                            fileDataStore.dispose();
                            throw exception;
                        }
                    }
                    try {
                        n = simpleFeatureCollection.size();
                    }
                    catch (Exception exception) {
                        fileDataStore.dispose();
                        DEBUG.ERR((Object)("Error in loading shapefile: " + exception.getMessage()));
                    }
                    List list = fileDataStore.getSchema().getAttributeDescriptors();
                    for (AttributeDescriptor attributeDescriptor : list) {
                        String string = attributeDescriptor.getType() instanceof GeometryType ? "geometry" : Types.get(attributeDescriptor.getType().getBinding()).toString();
                        this.attributes.put(attributeDescriptor.getName().getLocalPart(), string);
                    }
                }
                catch (Exception exception) {
                    DEBUG.ERR((Object)("Error in reading metadata of " + String.valueOf(uRL)));
                    exception.printStackTrace();
                    this.width = referencedEnvelope.getWidth();
                    this.height = referencedEnvelope.getHeight();
                    this.itemNumber = n;
                    this.crs = coordinateReferenceSystem;
                    if (fileDataStore != null) {
                        fileDataStore.dispose();
                    }
                }
            }
            finally {
                this.width = referencedEnvelope.getWidth();
                this.height = referencedEnvelope.getHeight();
                this.itemNumber = n;
                this.crs = coordinateReferenceSystem;
                if (fileDataStore != null) {
                    fileDataStore.dispose();
                }
            }
        }

        public CoordinateReferenceSystem getCRS() {
            return this.crs;
        }

        public ShapeInfo(String string) {
            super(string);
            CoordinateReferenceSystem coordinateReferenceSystem;
            String[] stringArray = this.split(string);
            this.itemNumber = Integer.parseInt(stringArray[1]);
            String string2 = stringArray[2];
            if ("null".equals(string2) || string2.startsWith("Unknown")) {
                coordinateReferenceSystem = null;
            } else {
                try {
                    coordinateReferenceSystem = CRS.parseWKT((String)string2);
                }
                catch (Exception exception) {
                    coordinateReferenceSystem = null;
                }
            }
            this.crs = coordinateReferenceSystem;
            this.width = Double.parseDouble(stringArray[3]);
            this.height = Double.parseDouble(stringArray[4]);
            if (stringArray.length > 5) {
                String[] stringArray2 = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)stringArray[5], (String)"@%@");
                String[] stringArray3 = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)stringArray[6], (String)"@%@");
                int n = 0;
                while (n < stringArray2.length) {
                    this.attributes.put(stringArray2[n], stringArray3[n]);
                    ++n;
                }
            }
        }

        @Override
        public String getSuffix() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendSuffix(stringBuilder);
            return stringBuilder.toString();
        }

        @Override
        public void appendSuffix(StringBuilder stringBuilder) {
            stringBuilder.append(this.itemNumber).append(" object");
            if (this.itemNumber > 1) {
                stringBuilder.append("s");
            }
            stringBuilder.append(" | ");
            stringBuilder.append(this.crs == null ? "Unknown CRS" : this.crs.getName().getCode());
            stringBuilder.append(" | ");
            stringBuilder.append(Math.round(this.width)).append("m x ");
            stringBuilder.append(Math.round(this.height)).append("m");
        }

        @Override
        public String getDocumentation() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Shapefile").append(Strings.LN);
            stringBuilder.append(this.itemNumber).append(" objects").append(Strings.LN);
            stringBuilder.append("Dimensions: ").append(Math.round(this.width) + "m x " + Math.round(this.height) + "m").append(Strings.LN);
            stringBuilder.append("Coordinate Reference System: ").append(this.crs == null ? "Unknown CRS" : this.crs.getName().getCode()).append(Strings.LN);
            if (!this.attributes.isEmpty()) {
                stringBuilder.append("Attributes: ").append(Strings.LN);
                this.attributes.forEach((string, string2) -> {
                    StringBuilder stringBuilder2 = stringBuilder.append("<li>").append((String)string).append(" (" + string2 + ")").append("</li>");
                });
            }
            return stringBuilder.toString();
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public String toPropertyString() {
            String string;
            Object object = this.crs == null ? "Unknown projection" : this.crs.toWKT();
            try {
                CRS.parseWKT((String)object);
            }
            catch (Exception exception) {
                string = CRS.toSRS((CoordinateReferenceSystem)this.crs);
                if (string == null && this.crs != null) {
                    string = this.crs.getName().getCode();
                }
                object = "Unknown projection " + string;
            }
            string = String.join((CharSequence)"@%@", this.attributes.keySet());
            String string2 = String.join((CharSequence)"@%@", this.attributes.values());
            CharSequence[] charSequenceArray = new String[]{super.toPropertyString(), String.valueOf(this.itemNumber), object, String.valueOf(this.width), String.valueOf(this.height), string, string2};
            return String.join((CharSequence)"_!_", charSequenceArray);
        }
    }
}

