/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.graph;

import com.google.common.collect.ImmutableList;
import gama.core.metamodel.topology.graph.AStar;
import gama.core.metamodel.topology.graph.FloydWarshallShortestPathsGAMA;
import gama.core.metamodel.topology.graph.NBAStarPathfinder;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.graph.GamaGraph;
import gama.core.util.graph.IGraph;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.GamaMatrix;
import gama.core.util.path.IPath;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.KShortestPathAlgorithm;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.BellmanFordShortestPath;
import org.jgrapht.alg.shortestpath.BhandariKDisjointShortestPaths;
import org.jgrapht.alg.shortestpath.BidirectionalDijkstraShortestPath;
import org.jgrapht.alg.shortestpath.ContractionHierarchyBidirectionalDijkstra;
import org.jgrapht.alg.shortestpath.DeltaSteppingShortestPath;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.alg.shortestpath.TransitNodeRoutingShortestPath;
import org.jgrapht.alg.shortestpath.YenKShortestPath;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultUndirectedGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.util.SupplierUtil;

public class PathComputer<V, E> {
    private final GamaGraph<V, E> graph;
    protected boolean saveComputedShortestPaths = true;
    protected int version = 1;
    protected Map<Pair<V, V>, IList<IList<E>>> shortestPathComputed = new ConcurrentHashMap<Pair<V, V>, IList<IList<E>>>();
    protected GamaIntMatrix shortestPathMatrix = null;
    public static final ImmutableList<KShortestPathAlgorithmEnum> ONLY_FOR_DIRECTED_GRAPH = ImmutableList.of((Object)((Object)KShortestPathAlgorithmEnum.Bhandari));
    protected ShortestPathAlgorithmEnum pathFindingAlgo = ShortestPathAlgorithmEnum.BidirectionalDijkstra;
    protected KShortestPathAlgorithmEnum kPathFindingAlgo = KShortestPathAlgorithmEnum.Yen;
    private FloydWarshallShortestPathsGAMA<V, E> optimizer;
    protected ContractionHierarchyBidirectionalDijkstra<V, E> contractionHierarchyBD = null;
    protected TransitNodeRoutingShortestPath<V, E> transitNodeRouting = null;
    protected AbstractBaseGraph<String, Object> linkedJGraph;
    protected Map<Object, Object> fromLinkedGtoEdges;

    PathComputer(GamaGraph<V, E> gamaGraph) {
        this.graph = gamaGraph;
    }

    public Map<Pair<V, V>, IList<IList<E>>> getShortestPathComputed() {
        return this.shortestPathComputed;
    }

    public IList<E> getShortestPath(V v, V v2) {
        Pair pair = new Pair(v, v2);
        IList<IList<E>> iList = this.shortestPathComputed.get(pair);
        if (iList == null || iList.isEmpty()) {
            return null;
        }
        return (IList)iList.get(0);
    }

    public GamaIntMatrix saveShortestPaths(IScope iScope) {
        int n;
        IMap iMap = GamaMapFactory.create(this.graph.getGamlType().getKeyType(), Types.INT);
        IList iList = this.graph.getVertices();
        int n2 = 0;
        while (n2 < this.graph.vertexMap.size()) {
            iMap.put(iList.get(n2), n2);
            ++n2;
        }
        GamaIntMatrix gamaIntMatrix = new GamaIntMatrix(iList.size(), iList.size());
        int n3 = 0;
        while (n3 < iList.size()) {
            n = 0;
            while (n < iList.size()) {
                gamaIntMatrix.set(iScope, n, n3, n3);
                ++n;
            }
            ++n3;
        }
        if (this.optimizer != null) {
            n3 = 0;
            while (n3 < iList.size()) {
                Object e = iList.get(n3);
                int n4 = 0;
                while (n4 < iList.size()) {
                    Object e2 = iList.get(n4);
                    GraphPath<V, E> graphPath = this.optimizer.getShortestPath(e, e2);
                    if (graphPath != null && graphPath.getEdgeList() != null && !graphPath.getEdgeList().isEmpty()) {
                        gamaIntMatrix.set(iScope, n4, n3, this.nextVertice(iScope, graphPath.getEdgeList().get(0), e, iMap, this.graph.directed));
                    }
                    ++n4;
                }
                ++n3;
            }
        } else if (ShortestPathAlgorithmEnum.FloydWarshall.equals((Object)this.pathFindingAlgo)) {
            this.optimizer = new FloydWarshallShortestPathsGAMA<V, E>(this.graph);
            this.optimizer.lazyCalculateMatrix();
            n3 = 0;
            while (n3 < this.graph.vertexMap.size()) {
                n = 0;
                while (n < this.graph.vertexMap.size()) {
                    if (n3 != n) {
                        gamaIntMatrix.set(iScope, n, n3, this.optimizer.succRecur(n3, n));
                    }
                    ++n;
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < this.graph.vertexMap.size()) {
                Object e = iList.get(n3);
                int n5 = 0;
                while (n5 < this.graph.vertexMap.size()) {
                    Object e3;
                    IList<E> iList2;
                    if (n3 != n5 && gamaIntMatrix.get(iScope, n5, n3) == n3 && (iList2 = this.computeBestRouteBetween(iScope, e, e3 = iList.get(n5))) != null) {
                        Object object = e;
                        int n6 = n3;
                        for (Object e4 : iList2) {
                            if (n6 != n3 && gamaIntMatrix.get(iScope, n5, n6) != n6) break;
                            Object object2 = this.graph.getEdgeTarget(e4);
                            if (!this.graph.directed && object2 == object) {
                                object2 = this.graph.getEdgeSource(e4);
                            }
                            Integer n7 = (Integer)iMap.get(iScope, object2);
                            gamaIntMatrix.set(iScope, n5, n6, n7);
                            n6 = n7;
                            object = object2;
                        }
                    }
                    ++n5;
                }
                ++n3;
            }
        }
        return gamaIntMatrix;
    }

    private Integer nextVertice(IScope iScope, E e, V v, IMap<V, Integer> iMap, boolean bl) {
        if (bl) {
            return iMap.get(iScope, (V)this.graph.getEdgeTarget(e));
        }
        Object object = this.graph.getEdgeTarget(e);
        if (object != v) {
            return iMap.get(iScope, (V)object);
        }
        return iMap.get(iScope, (V)this.graph.getEdgeSource(e));
    }

    public IList savePaths(int[] nArray, IList iList, int n, Object object, int n2, int n3) {
        IList iList2 = GamaListFactory.create(this.graph.getGamlType().getContentType());
        int n4 = 0;
        while (n4 < n) {
            IList iList3 = GamaListFactory.create(this.graph.getGamlType().getContentType());
            Object e = iList.get(n4);
            if (object != e) {
                Object e2 = e;
                int n5 = nArray[n4];
                if (n4 != n5 && n5 != -1) {
                    Collection<Object> collection;
                    Object object2;
                    int n6;
                    do {
                        object2 = iList.get(n5);
                        collection = this.graph.getAllEdges(object2, e2);
                        Object e3 = null;
                        for (Object e4 : collection) {
                            if (e3 != null && !(this.graph.getEdgeWeight(e4) < this.graph.getEdgeWeight(e3))) continue;
                            e3 = e4;
                        }
                        if (e3 == null) break;
                        iList3.add(0, e3);
                        n6 = n5;
                        n5 = nArray[n5];
                        e2 = object2;
                    } while (n6 != n2);
                    object2 = new Pair(object, e);
                    if (!this.shortestPathComputed.containsKey(object2)) {
                        collection = GamaListFactory.create(Types.LIST.of(this.graph.getGamlType().getContentType()));
                        collection.add(iList3);
                        this.shortestPathComputed.put((Pair<Collection<Object>, Collection<Object>>)object2, (IList<IList<E>>)collection);
                    }
                    if (n4 == n3) {
                        iList2 = iList3;
                    }
                }
            }
            ++n4;
        }
        return iList2;
    }

    public IList<E> getShortestPathFromMatrix(V v, V v2) {
        int n;
        Integer n2;
        IList iList = this.graph.getVertices();
        IList iList2 = GamaListFactory.create(this.graph.getGamlType().getContentType());
        Object object = v;
        int n3 = iList.indexOf(object);
        int n4 = n3;
        if (n4 == (n2 = this.shortestPathMatrix.get(this.graph.graphScope, n = iList.indexOf(v2), n4))) {
            return iList2;
        }
        do {
            if (n2 == -1) {
                return GamaListFactory.create(this.graph.getGamlType().getContentType());
            }
            Object e = iList.get(n2);
            Set set = this.graph.getAllEdges(object, e);
            Object e2 = null;
            for (Object e3 : set) {
                if (e2 != null && !(this.graph.getEdgeWeight(e3) < this.graph.getEdgeWeight(e2))) continue;
                e2 = e3;
            }
            if (e2 == null) {
                return GamaListFactory.create(this.graph.getGamlType().getContentType());
            }
            iList2.add(e2);
            n4 = n2;
            n2 = this.shortestPathMatrix.get(this.graph.graphScope, n, n2);
            object = e;
        } while (n4 != n);
        return iList2;
    }

    public boolean isSaveComputedShortestPaths() {
        return this.saveComputedShortestPaths;
    }

    public void setSaveComputedShortestPaths(boolean bl) {
        this.saveComputedShortestPaths = bl;
    }

    public FloydWarshallShortestPathsGAMA<V, E> getFloydWarshallShortestPaths() {
        return this.optimizer;
    }

    public void setFloydWarshallShortestPaths(FloydWarshallShortestPathsGAMA<V, E> floydWarshallShortestPathsGAMA) {
        this.optimizer = floydWarshallShortestPathsGAMA;
    }

    public void loadShortestPaths(IScope iScope, GamaMatrix gamaMatrix) {
        this.shortestPathMatrix = GamaIntMatrix.from(iScope, gamaMatrix);
    }

    public IPath<V, E, IGraph<V, E>> computeShortestPathBetween(IScope iScope, V v, V v2) {
        return this.graph.pathFromEdges(iScope, v, v2, this.computeBestRouteBetween(iScope, v, v2));
    }

    public IList<E> getShortestPath(IScope iScope, ShortestPathAlgorithm<V, E> shortestPathAlgorithm, V v, V v2) {
        GraphPath graphPath = shortestPathAlgorithm.getPath(v, v2);
        if (graphPath == null) {
            return GamaListFactory.create(this.graph.getGamlType().getKeyType());
        }
        List list = graphPath.getEdgeList();
        if (list == null) {
            return GamaListFactory.create(this.graph.getGamlType().getKeyType());
        }
        return GamaListFactory.create(iScope, this.graph.getGamlType().getContentType(), list);
    }

    public IList<E> computeBestRouteBetween(IScope iScope, V v, V v2) {
        if (v.equals(v2)) {
            return GamaListFactory.create(this.graph.getGamlType().getContentType());
        }
        if (this.shortestPathMatrix != null) {
            IList<E> iList = this.getShortestPathFromMatrix(v, v2);
            if (this.saveComputedShortestPaths) {
                this.saveShortestPaths(iList, v, v2);
            }
            return iList;
        }
        if (this.pathFindingAlgo == ShortestPathAlgorithmEnum.FloydWarshall) {
            GraphPath<V, E> graphPath;
            if (this.optimizer == null) {
                this.optimizer = new FloydWarshallShortestPathsGAMA<V, E>(this.graph);
            }
            if ((graphPath = this.optimizer.getShortestPath(v, v2)) == null) {
                return GamaListFactory.create(this.graph.getGamlType().getContentType());
            }
            return GamaListFactory.create(iScope, this.graph.getGamlType().getContentType(), graphPath.getEdgeList());
        }
        IList<IList<E>> iList = null;
        if (this.saveComputedShortestPaths) {
            iList = this.shortestPathComputed.get(new Pair(v, v2));
        }
        IList<Object> iList2 = null;
        if (iList == null || iList.isEmpty() || ((IList)iList.get(0)).isEmpty()) {
            if (this.pathFindingAlgo == ShortestPathAlgorithmEnum.NBAStar) {
                NBAStarPathfinder<V, E> nBAStarPathfinder = new NBAStarPathfinder<V, E>(this.graph, false);
                iList2 = nBAStarPathfinder.search(v, v2);
            } else if (this.pathFindingAlgo == ShortestPathAlgorithmEnum.NBAStarApprox) {
                NBAStarPathfinder<V, E> nBAStarPathfinder = new NBAStarPathfinder<V, E>(this.graph, true);
                iList2 = nBAStarPathfinder.search(v, v2);
            } else if (this.pathFindingAlgo == ShortestPathAlgorithmEnum.AStar) {
                AStar<V, E> aStar = new AStar<V, E>(this.graph, v, v2);
                iList2 = aStar.compute();
            } else if (this.pathFindingAlgo == ShortestPathAlgorithmEnum.Dijkstra) {
                iList2 = this.getShortestPath(iScope, (ShortestPathAlgorithm<V, E>)new DijkstraShortestPath(this.graph), v, v2);
            } else if (this.pathFindingAlgo == ShortestPathAlgorithmEnum.BellmannFord) {
                iList2 = this.getShortestPath(iScope, (ShortestPathAlgorithm<V, E>)new BellmanFordShortestPath(this.graph), v, v2);
            } else if (this.pathFindingAlgo == ShortestPathAlgorithmEnum.DeltaStepping) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(GamaExecutorService.THREADS_NUMBER.getValue());
                iList2 = this.getShortestPath(iScope, (ShortestPathAlgorithm<V, E>)new DeltaSteppingShortestPath(this.graph, threadPoolExecutor), v, v2);
            } else if (this.pathFindingAlgo == ShortestPathAlgorithmEnum.TransitNodeRouting) {
                if (this.transitNodeRouting == null) {
                    ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(GamaExecutorService.THREADS_NUMBER.getValue());
                    this.transitNodeRouting = new TransitNodeRoutingShortestPath(this.graph, threadPoolExecutor);
                }
                iList2 = this.getShortestPath(iScope, (ShortestPathAlgorithm<V, E>)this.transitNodeRouting, v, v2);
            } else if (this.pathFindingAlgo == ShortestPathAlgorithmEnum.CHBidirectionalDijkstra) {
                if (this.contractionHierarchyBD == null) {
                    ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(GamaExecutorService.THREADS_NUMBER.getValue());
                    this.contractionHierarchyBD = new ContractionHierarchyBidirectionalDijkstra(this.graph, threadPoolExecutor);
                }
                iList2 = this.getShortestPath(iScope, (ShortestPathAlgorithm<V, E>)this.contractionHierarchyBD, v, v2);
            } else if (this.pathFindingAlgo == ShortestPathAlgorithmEnum.BidirectionalDijkstra) {
                iList2 = this.getShortestPath(iScope, (ShortestPathAlgorithm<V, E>)new BidirectionalDijkstraShortestPath(this.graph), v, v2);
            }
            if (this.saveComputedShortestPaths) {
                this.saveShortestPaths(iList2, v, v2);
            }
        } else {
            iList2 = GamaListFactory.create(iScope, this.graph.getGamlType().getContentType(), (IList)iList.get(0));
        }
        return iList2;
    }

    private void saveShortestPaths(List<E> list, V v, V v2) {
        Object object = v;
        IList iList = GamaListFactory.create(Types.LIST.of(this.graph.getGamlType().getContentType()));
        iList.add(GamaListFactory.createWithoutCasting(this.graph.getGamlType().getContentType(), list));
        this.shortestPathComputed.put(new Pair(v, v2), iList);
        IList<E> iList2 = GamaListFactory.create(this.graph.graphScope, this.graph.getGamlType().getContentType(), list);
        int n = 0;
        while (n < list.size()) {
            Pair pair;
            Object e = iList2.remove(0);
            if (iList2.isEmpty()) break;
            Object object2 = this.graph.getEdgeTarget(e);
            if (!this.graph.directed && object2.equals(object)) {
                object2 = this.graph.getEdgeSource(e);
            }
            if (!this.shortestPathComputed.containsKey(pair = new Pair(object2, v2))) {
                IList iList3 = GamaListFactory.create(this.graph.getGamlType().getContentType());
                iList3.add(GamaListFactory.createWithoutCasting(this.graph.getGamlType().getContentType(), iList2));
                this.shortestPathComputed.put(pair, iList3);
            }
            object = object2;
            ++n;
        }
    }

    public IList<IPath<V, E, IGraph<V, E>>> computeKShortestPathsBetween(IScope iScope, V v, V v2, int n) {
        if (!this.graph.directed && ONLY_FOR_DIRECTED_GRAPH.contains((Object)this.kPathFindingAlgo)) {
            throw GamaRuntimeException.error(this.kPathFindingAlgo.name() + " cannot be used for undirected graphs - use the Yen algorithm for that", iScope);
        }
        IList<IList<E>> iList = this.computeKBestRoutesBetween(iScope, v, v2, n);
        IList<IPath<V, IPath<V, E, IGraph<V, E>>, IGraph<V, IPath<V, E, IGraph<V, E>>>>> iList2 = GamaListFactory.create(Types.PATH);
        for (IList iList3 : iList) {
            if (iList3 == null) continue;
            iList2.add(this.graph.pathFromEdges(iScope, v, v2, iList3));
        }
        return iList2;
    }

    public IList<IList<E>> geKtShortestPath(IScope iScope, KShortestPathAlgorithm kShortestPathAlgorithm, V v, V v2, int n, boolean bl) {
        List list = kShortestPathAlgorithm.getPaths(bl ? v.toString() : v, bl ? v2.toString() : v2, n);
        if (list == null) {
            return GamaListFactory.create(this.graph.getGamlType().getContentType());
        }
        IList iList = GamaListFactory.create(Types.LIST.of(this.graph.getGamlType().getContentType()));
        IList iList2 = GamaListFactory.create(Types.LIST.of(this.graph.getGamlType().getContentType()));
        for (GraphPath graphPath : list) {
            IList iList3 = GamaListFactory.create();
            if (bl) {
                for (Object e : graphPath.getEdgeList()) {
                    iList3.add(this.fromLinkedGtoEdges.get(e));
                }
            } else {
                iList3.addAll(graphPath.getEdgeList());
            }
            iList2.add(iList3);
            if (!this.saveComputedShortestPaths) continue;
            iList.add(iList3);
        }
        if (this.saveComputedShortestPaths) {
            this.shortestPathComputed.put(new Pair(v, v2), iList);
        }
        return iList2;
    }

    public IList<IList<E>> computeKBestRoutesBetween(IScope iScope, V v, V v2, int n) {
        Pair pair = new Pair(v, v2);
        IList<IList<E>> iList = this.shortestPathComputed.get(pair);
        if (iList != null && iList.size() >= n) {
            IList iList2 = GamaListFactory.create(Types.LIST.of(this.graph.getGamlType().getContentType()));
            for (IList iList3 : iList) {
                iList2.add(GamaListFactory.create(iScope, this.graph.getGamlType().getContentType(), iList3));
            }
            return iList2;
        }
        IList<IList<E>> iList4 = GamaListFactory.create(Types.LIST.of(this.graph.getGamlType().getContentType()));
        if (this.kPathFindingAlgo == KShortestPathAlgorithmEnum.Yen) {
            iList4 = this.geKtShortestPath(iScope, (KShortestPathAlgorithm)new YenKShortestPath(this.graph), v, v2, n, false);
        } else if (this.kPathFindingAlgo == KShortestPathAlgorithmEnum.Bhandari) {
            this.generateGraph();
            iList4 = this.geKtShortestPath(iScope, (KShortestPathAlgorithm)new BhandariKDisjointShortestPaths(this.linkedJGraph), v, v2, n, true);
        }
        return iList4;
    }

    void generateGraph() {
        if (this.linkedJGraph != null) {
            return;
        }
        this.fromLinkedGtoEdges = GamaMapFactory.create();
        this.linkedJGraph = this.graph.directed ? new DefaultDirectedGraph(SupplierUtil.createStringSupplier(), SupplierUtil.createDefaultWeightedEdgeSupplier(), true) : new DefaultUndirectedGraph(SupplierUtil.createStringSupplier(), SupplierUtil.createDefaultWeightedEdgeSupplier(), true);
        for (Object e : this.graph.getVertices()) {
            this.linkedJGraph.addVertex((Object)e.toString());
        }
        for (Object e : this.graph.getEdges()) {
            String string;
            String string2 = this.graph.getEdgeSource(e).toString();
            if (string2.equals(string = this.graph.getEdgeTarget(e).toString())) continue;
            DefaultWeightedEdge defaultWeightedEdge = (DefaultWeightedEdge)this.linkedJGraph.addEdge((Object)string2, (Object)string);
            this.linkedJGraph.setEdgeWeight((Object)string2, (Object)string, this.graph.getWeightOf(e).doubleValue());
            this.fromLinkedGtoEdges.put(defaultWeightedEdge, e);
        }
    }

    public void setShortestPathAlgorithm(String string) {
        this.pathFindingAlgo = ShortestPathAlgorithmEnum.valueOf(string);
    }

    public void setKShortestPathAlgorithm(String string) {
        this.kPathFindingAlgo = KShortestPathAlgorithmEnum.valueOf(string);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
        this.shortestPathComputed.clear();
    }

    public void incVersion() {
        ++this.version;
        this.shortestPathComputed.clear();
        this.contractionHierarchyBD = null;
        this.transitNodeRouting = null;
        this.linkedJGraph = null;
        this.fromLinkedGtoEdges = null;
    }

    public void reInitPathFinder() {
        this.optimizer = null;
    }

    public static enum KShortestPathAlgorithmEnum {
        Yen,
        Bhandari;

    }

    public static enum ShortestPathAlgorithmEnum {
        FloydWarshall,
        BellmannFord,
        Dijkstra,
        AStar,
        NBAStar,
        NBAStarApprox,
        DeltaStepping,
        CHBidirectionalDijkstra,
        BidirectionalDijkstra,
        TransitNodeRouting;

    }
}

