/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.preferences;

import gama.core.common.preferences.Pref;
import gama.core.common.util.StringUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.core.util.GamaDate;
import gama.core.util.file.GamaFile;
import gama.core.util.file.GenericFile;
import gama.dev.FLAGS;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaDateType;
import gama.gaml.types.GamaFontType;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public abstract class GamaPreferenceStore<T> {
    private static volatile GamaPreferenceStore STORE;
    private static final String NODE_NAME = "gama";
    private static final String DEFAULT_FONT = "Default";
    T store;
    private final List<String> keys;

    public static GamaPreferenceStore getStore() {
        if (STORE == null) {
            STORE = FLAGS.USE_GLOBAL_PREFERENCE_STORE ? new JRE(Preferences.userRoot().node(NODE_NAME)) : new Configuration(ConfigurationScope.INSTANCE.getNode(NODE_NAME));
        }
        return STORE;
    }

    GamaPreferenceStore(T t) {
        this.store = t;
        this.keys = this.computeKeys();
        this.flush();
    }

    public List<String> getKeys() {
        return this.keys;
    }

    protected abstract List<String> computeKeys();

    public abstract void put(String var1, String var2);

    public abstract void putInt(String var1, int var2);

    public abstract void putDouble(String var1, Double var2);

    public abstract void putBoolean(String var1, Boolean var2);

    public final <T> T get(String string, Function<String, T> function, T t) {
        String string2 = System.getProperty(string);
        return string2 == null ? t : function.apply(string2);
    }

    public final String get(String string, String string2) {
        return this.get(string, Function.identity(), this.getStringPreference(string, string2));
    }

    protected abstract String getStringPreference(String var1, String var2);

    public final Integer getInt(String string, Integer n) {
        return this.get(string, Integer::valueOf, this.getIntPreference(string, n));
    }

    protected abstract Integer getIntPreference(String var1, Integer var2);

    public final Double getDouble(String string, Double d) {
        return this.get(string, Double::valueOf, this.getDoublePreference(string, d));
    }

    protected abstract Double getDoublePreference(String var1, Double var2);

    public final Boolean getBoolean(String string, Boolean bl) {
        return this.get(string, Boolean::valueOf, this.getBooleanPreference(string, bl));
    }

    protected abstract Boolean getBooleanPreference(String var1, Boolean var2);

    public abstract void flush();

    public abstract void clear();

    public abstract void saveToProperties(String var1);

    public abstract void loadFromProperties(String var1);

    public void write(Pref pref) {
        String string = pref.key;
        Object t = pref.value;
        switch (pref.type) {
            case 1: {
                this.putInt(string, (Integer)t);
                break;
            }
            case 2: {
                this.putDouble(string, (Double)t);
                break;
            }
            case 3: {
                this.putBoolean(string, (Boolean)t);
                break;
            }
            case 4: {
                this.put(string, StringUtils.toJavaString((String)t));
                break;
            }
            case 12: {
                this.put(string, t == null ? "" : ((GamaFile)t).getPath(null));
                break;
            }
            case 6: {
                this.putInt(string, t == null ? 0 : ((GamaColor)t).getRGB());
                break;
            }
            case 7: {
                this.put(string, t == null ? "{0,0}" : ((GamaPoint)t).stringValue(null));
                break;
            }
            case 19: {
                this.put(string, t == null ? DEFAULT_FONT : t.toString());
                break;
            }
            case 23: {
                this.put(string, t == null ? StringUtils.toJavaString(GamaDateType.EPOCH.toISOString()) : StringUtils.toJavaString(((GamaDate)t).toISOString()));
                break;
            }
            default: {
                this.put(string, (String)t);
            }
        }
        this.flush();
    }

    public void register(Pref<?> pref) {
        IScope iScope = null;
        String string = pref.key;
        if (string == null) {
            return;
        }
        Object t = pref.value;
        if (this.getKeys().contains(string)) {
            switch (pref.type) {
                case 7: {
                    pref.init(() -> Cast.asPoint(iScope, this.get(string, Cast.asString(iScope, t)), false));
                    break;
                }
                case 1: {
                    pref.init(() -> this.getInt(string, Cast.asInt(iScope, t)));
                    break;
                }
                case 2: {
                    pref.init(() -> this.getDouble(string, Cast.asFloat(iScope, t)));
                    break;
                }
                case 3: {
                    pref.init(() -> this.getBoolean(string, Cast.asBool(iScope, t)));
                    break;
                }
                case 4: {
                    pref.init(() -> this.get(string, StringUtils.toJavaString(Cast.asString(iScope, t))));
                    break;
                }
                case 12: {
                    pref.init(() -> new GenericFile(this.get(string, (String)t), false));
                    break;
                }
                case 6: {
                    pref.init(() -> GamaColor.get(this.getInt(string, Cast.asInt(iScope, t))));
                    break;
                }
                case 19: {
                    pref.init(() -> {
                        String string2 = this.get(string, Cast.asString(iScope, t));
                        if (DEFAULT_FONT.equals(string2)) {
                            return null;
                        }
                        return GamaFontType.staticCast(iScope, string2, false);
                    });
                    break;
                }
                case 23: {
                    pref.init(() -> GamaDate.fromISOString(StringUtils.toJavaString(this.get(string, Cast.asString(iScope, t)))));
                    break;
                }
                default: {
                    pref.init(() -> this.get(string, Cast.asString(iScope, t)));
                }
            }
        }
        this.flush();
    }

    static class Configuration
    extends GamaPreferenceStore<IEclipsePreferences> {
        Configuration(IEclipsePreferences iEclipsePreferences) {
            super(iEclipsePreferences);
        }

        @Override
        protected List<String> computeKeys() {
            try {
                return Arrays.asList(((IEclipsePreferences)this.store).keys());
            }
            catch (org.osgi.service.prefs.BackingStoreException backingStoreException) {
                return Collections.EMPTY_LIST;
            }
        }

        @Override
        public void put(String string, String string2) {
            ((IEclipsePreferences)this.store).put(string, string2);
            this.flush();
        }

        @Override
        public void putInt(String string, int n) {
            ((IEclipsePreferences)this.store).putInt(string, n);
            this.flush();
        }

        @Override
        public void putDouble(String string, Double d) {
            ((IEclipsePreferences)this.store).putDouble(string, d.doubleValue());
            this.flush();
        }

        @Override
        public void putBoolean(String string, Boolean bl) {
            ((IEclipsePreferences)this.store).putBoolean(string, bl.booleanValue());
            this.flush();
        }

        @Override
        public String getStringPreference(String string, String string2) {
            return ((IEclipsePreferences)this.store).get(string, string2);
        }

        @Override
        public Integer getIntPreference(String string, Integer n) {
            return ((IEclipsePreferences)this.store).getInt(string, n.intValue());
        }

        @Override
        public Double getDoublePreference(String string, Double d) {
            return ((IEclipsePreferences)this.store).getDouble(string, d.doubleValue());
        }

        @Override
        public Boolean getBooleanPreference(String string, Boolean bl) {
            return ((IEclipsePreferences)this.store).getBoolean(string, bl.booleanValue());
        }

        @Override
        public void flush() {
            try {
                ((IEclipsePreferences)this.store).flush();
            }
            catch (org.osgi.service.prefs.BackingStoreException backingStoreException) {}
        }

        @Override
        public void clear() {
            try {
                ((IEclipsePreferences)this.store).removeNode();
            }
            catch (org.osgi.service.prefs.BackingStoreException backingStoreException) {}
        }

        @Override
        public void loadFromProperties(String string) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream fileInputStream = new FileInputStream(string);){
                    PreferencesService.getDefault().importPreferences((InputStream)fileInputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException throwable) {
                throwable.printStackTrace();
            }
        }

        @Override
        public void saveToProperties(String string) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
                    Properties properties = new Properties();
                    String[] stringArray = ((IEclipsePreferences)this.store).keys();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string2 = stringArray[n2];
                        properties.setProperty(string2, ((IEclipsePreferences)this.store).get(string2, null));
                        ++n2;
                    }
                    properties.store(fileOutputStream, "GAMA Preferences " + String.valueOf(LocalDateTime.now()));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | org.osgi.service.prefs.BackingStoreException throwable) {
                throwable.printStackTrace();
            }
        }
    }

    static class JRE
    extends GamaPreferenceStore<Preferences> {
        JRE(Preferences preferences) {
            super(preferences);
        }

        @Override
        protected List<String> computeKeys() {
            try {
                return Arrays.asList(((Preferences)this.store).keys());
            }
            catch (BackingStoreException backingStoreException) {
                return Collections.EMPTY_LIST;
            }
        }

        @Override
        public void put(String string, String string2) {
            ((Preferences)this.store).put(string, string2);
            this.flush();
        }

        @Override
        public void putInt(String string, int n) {
            ((Preferences)this.store).putInt(string, n);
            this.flush();
        }

        @Override
        public void putDouble(String string, Double d) {
            ((Preferences)this.store).putDouble(string, d);
            this.flush();
        }

        @Override
        public void putBoolean(String string, Boolean bl) {
            ((Preferences)this.store).putBoolean(string, bl);
            this.flush();
        }

        @Override
        public String getStringPreference(String string, String string2) {
            return ((Preferences)this.store).get(string, string2);
        }

        @Override
        public Integer getIntPreference(String string, Integer n) {
            return ((Preferences)this.store).getInt(string, n);
        }

        @Override
        public Double getDoublePreference(String string, Double d) {
            return ((Preferences)this.store).getDouble(string, d);
        }

        @Override
        public Boolean getBooleanPreference(String string, Boolean bl) {
            return ((Preferences)this.store).getBoolean(string, bl);
        }

        @Override
        public void flush() {
            try {
                ((Preferences)this.store).flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }

        @Override
        public void clear() {
            try {
                ((Preferences)this.store).removeNode();
            }
            catch (BackingStoreException backingStoreException) {}
        }

        @Override
        public void loadFromProperties(String string) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream fileInputStream = new FileInputStream(string);){
                    Preferences.importPreferences(fileInputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | InvalidPreferencesFormatException exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void saveToProperties(String string) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
                    Properties properties = new Properties();
                    String[] stringArray = ((Preferences)this.store).keys();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string2 = stringArray[n2];
                        properties.setProperty(string2, ((Preferences)this.store).get(string2, null));
                        ++n2;
                    }
                    properties.store(fileOutputStream, "GAMA Preferences " + String.valueOf(LocalDateTime.now()));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | BackingStoreException exception) {
                exception.printStackTrace();
            }
        }
    }
}

