/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.layers.AgentLayerStatement;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.AspectStatement;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import java.util.ArrayList;
import java.util.List;

@GamlAnnotations.inside(symbols={"display", "species_layer"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="position", type={7}, optional=true, doc={@GamlAnnotations.doc(value="position of the upper-left corner of the layer. Note that if coordinates are in [0,1[, the position is relative to the size of the environment (e.g. {0.5,0.5} refers to the middle of the display) whereas it is absolute when coordinates are greater than 1 for x and y. The z-ordinate can only be defined between 0 and 1. The position can only be a 3D point {0.5, 0.5, 0.5}, the last coordinate specifying the elevation of the layer. In case of negative value OpenGl will position the layer out of the environment.")}), @GamlAnnotations.facet(name="rotate", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Defines the angle of rotation of this layer, in degrees, around the z-axis.")}), @GamlAnnotations.facet(name="selectable", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Indicates whether the agents present on this layer are selectable by the user. Default is true")}), @GamlAnnotations.facet(name="size", type={7}, optional=true, doc={@GamlAnnotations.doc(value="extent of the layer in the screen from its position. Coordinates in [0,1[ are treated as percentages of the total surface, while coordinates > 1 are treated as absolute sizes in model units (i.e. considering the model occupies the entire view). Like in 'position', an elevation can be provided with the z coordinate, allowing to scale the layer in the 3 directions ")}), @GamlAnnotations.facet(name="transparency", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the transparency level of the layer (between 0 -- opaque -- and 1 -- fully transparent)")}), @GamlAnnotations.facet(name="trace", type={3, 1}, optional=true, doc={@GamlAnnotations.doc(value="Allows to aggregate the visualization of agents at each timestep on the display. Default is false. If set to an int value, only the last n-th steps will be visualized. If set to true, no limit of timesteps is applied. ")}), @GamlAnnotations.facet(name="fading", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Used in conjunction with 'trace:', allows to apply a fading effect to the previous traces. Default is false")}), @GamlAnnotations.facet(name="visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Defines whether this layer is visible or not")}), @GamlAnnotations.facet(name="species", type={14}, optional=false, doc={@GamlAnnotations.doc(value="the species to be displayed")}), @GamlAnnotations.facet(name="aspect", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="the name of the aspect that should be used to display the species")}), @GamlAnnotations.facet(name="refresh", type={3}, optional=true, doc={@GamlAnnotations.doc(value="(openGL only) specify whether the display of the species is refreshed. (true by default, usefull in case of agents that do not move)")})}, omissible="species")
@GamlAnnotations.doc(value="The `species_layer` statement is used using the `species keyword`. It allows modeler to display all the agent of a given species in the current display. In particular, modeler can choose the aspect used to display them.", usages={@GamlAnnotations.usage(value="The general syntax is:", examples={@GamlAnnotations.example(value="display my_display {", isExecutable=false), @GamlAnnotations.example(value="   species species_name [additional options];", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="Species can be superposed on the same plan (be careful with the order, the last one will be above all the others):", examples={@GamlAnnotations.example(value="display my_display {", isExecutable=false), @GamlAnnotations.example(value="   species agent1 aspect: base;", isExecutable=false), @GamlAnnotations.example(value="   species agent2 aspect: base;", isExecutable=false), @GamlAnnotations.example(value="   species agent3 aspect: base;", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="Each species layer can be placed at a different z value using the opengl display. position:{0,0,0} means the layer will be placed on the ground and position:{0,0,1} means it will be placed at an height equal to the maximum size of the environment.", examples={@GamlAnnotations.example(value="display my_display type: opengl{", isExecutable=false), @GamlAnnotations.example(value="   species agent1 aspect: base ;", isExecutable=false), @GamlAnnotations.example(value="   species agent2 aspect: base position:{0,0,0.5};", isExecutable=false), @GamlAnnotations.example(value="   species agent3 aspect: base position:{0,0,1};", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"display", "agents", "chart", "event", "graphics", "display_grid", "image", "overlay"})
@serializer(value=SpeciesLayerSerializer.class)
@validator(value=SpeciesLayerValidator.class)
public class SpeciesLayerStatement
extends AgentLayerStatement {
    private IExecutable aspect;
    protected ISpecies hostSpecies;
    protected ISpecies species;
    protected List<SpeciesLayerStatement> microSpeciesLayers;

    public SpeciesLayerStatement(IDescription iDescription) throws GamaRuntimeException {
        super(iDescription);
        this.setName(this.getFacet("species").literalValue());
    }

    @Override
    public boolean _init(IScope iScope) throws GamaRuntimeException {
        if (this.hostSpecies == null && iScope.getSimulation() != null) {
            this.hostSpecies = iScope.getSimulation().getSpecies();
        }
        this.species = Cast.asSpecies(iScope, this.getFacet("species").value(iScope));
        if (this.species == null && this.hostSpecies != null) {
            this.species = this.hostSpecies.getMicroSpecies(this.getName());
        }
        if (this.species == null) {
            throw GamaRuntimeException.error("not a suitable species to display: " + this.getName(), iScope);
        }
        if (super._init(iScope) && this.microSpeciesLayers != null) {
            for (SpeciesLayerStatement speciesLayerStatement : this.microSpeciesLayers) {
                speciesLayerStatement.hostSpecies = this.species;
                if (iScope.init(speciesLayerStatement).passed()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean _step(IScope iScope) throws GamaRuntimeException {
        return true;
    }

    @Override
    public ILayerStatement.LayerType getType(LayeredDisplayOutput layeredDisplayOutput) {
        return ILayerStatement.LayerType.SPECIES;
    }

    public List<String> getAspects() {
        return this.species.getAspectNames();
    }

    @Override
    public void setAspect(String string) {
        super.setAspect(string);
        this.aspect = this.species.getAspect(this.constantAspectName);
    }

    @Override
    public void computeAspectName(IScope iScope) throws GamaRuntimeException {
        if (this.aspect != null) {
            return;
        }
        super.computeAspectName(iScope);
        this.aspect = this.species.getAspect(this.constantAspectName);
    }

    @Override
    public IExecutable getAspect() {
        return this.aspect;
    }

    public ISpecies getSpecies() {
        return this.species;
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        ArrayList<IStatement> arrayList = new ArrayList<IStatement>();
        for (ISymbol iDisposable : iterable) {
            if (iDisposable instanceof SpeciesLayerStatement) {
                if (this.microSpeciesLayers == null) {
                    this.microSpeciesLayers = new ArrayList<SpeciesLayerStatement>();
                }
                this.microSpeciesLayers.add((SpeciesLayerStatement)iDisposable);
                continue;
            }
            arrayList.add((IStatement)iDisposable);
        }
        if (!arrayList.isEmpty()) {
            this.constantAspectName = "inline";
            IDescription iDescription = DescriptionFactory.create("aspect", this.getDescription(), "name", "inline");
            this.aspect = new AspectStatement(iDescription);
            ((AspectStatement)this.aspect).setChildren(arrayList);
        }
    }

    public List<SpeciesLayerStatement> getMicroSpeciesLayers() {
        return this.microSpeciesLayers;
    }

    public String toString() {
        return "SpeciesDisplayLayer species: " + this.getName();
    }

    public static class SpeciesLayerSerializer
    extends SymbolSerializer<StatementDescription> {
        @Override
        protected void serializeKeyword(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            stringBuilder.append("species ");
        }
    }

    public static class SpeciesLayerValidator
    implements IDescriptionValidator<StatementDescription> {
        @Override
        public void validate(StatementDescription statementDescription) {
            SpeciesDescription speciesDescription = null;
            speciesDescription = statementDescription.getGamlType().getDenotedSpecies();
            if (speciesDescription == null) {
                return;
            }
            IExpressionDescription iExpressionDescription = statementDescription.getFacet("aspect");
            if (iExpressionDescription != null) {
                String string = statementDescription.getLitteral("aspect");
                if (speciesDescription.getAspect(string) != null) {
                    iExpressionDescription.compileAsLabel();
                } else {
                    statementDescription.error(string + " is not the name of an aspect of " + speciesDescription.getName(), "gaml.general.issue", iExpressionDescription.getTarget(), new String[0]);
                }
            }
        }
    }
}

