/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import one.util.streamex.StreamEx;

public class GamaList<E>
extends ArrayList<E>
implements IList<E> {
    private IContainerType type;

    @Override
    public IContainerType<?> getGamlType() {
        return this.type;
    }

    @Override
    public StreamEx<E> stream(IScope iScope) {
        return StreamEx.of((Collection)this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IList)) {
            return false;
        }
        return GamaListFactory.equals(this, (IList)object);
    }

    protected GamaList() {
        this(0, Types.NO_TYPE);
    }

    protected GamaList(int n, IType iType) {
        super(n);
        this.type = Types.LIST.of(iType);
    }

    @Override
    public IList<E> listValue(IScope iScope, IType iType, boolean bl) {
        IType<?> iType2 = this.getGamlType().getContentType();
        if (!GamaType.requiresCasting(iType, iType2)) {
            if (bl) {
                return this.cloneWithContentType(iType);
            }
            if (!iType.equals(iType2)) {
                return GamaListFactory.wrap(iType, this);
            }
            return this;
        }
        GamaList gamaList = this.cloneWithContentType(iType);
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            gamaList.setValueAtIndex(iScope, (Object)n2, this.get(n2));
            ++n2;
        }
        return gamaList;
    }

    @Override
    public void removeAllOccurrencesOfValue(IScope iScope, Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!Objects.equals(iterator.next(), object)) continue;
            iterator.remove();
        }
    }

    private GamaList cloneWithContentType(IType iType) {
        GamaList gamaList = (GamaList)super.clone();
        gamaList.type = Types.LIST.of(iType);
        return gamaList;
    }

    @Override
    public IList<E> copy(IScope iScope) {
        return this.cloneWithContentType(this.type.getContentType());
    }

    @Override
    public E getFromIndicesList(IScope iScope, IList iList) throws GamaRuntimeException {
        if (iList == null || iList.isEmpty()) {
            return null;
        }
        return this.get(iScope, Cast.asInt(iScope, iList.get(0)));
    }
}

