/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.GamaGisFile;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.FileReader;
import java.util.LinkedHashMap;
import java.util.List;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geojson.feature.FeatureJSON;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryType;

@GamlAnnotations.file(name="geojson", extensions={"json", "geojson", "geo.json"}, buffer_type=5, buffer_content=13, buffer_index=1, concept={"gis", "file"}, doc={@GamlAnnotations.doc(value="Represents geospatial files written using the GeoJSON format. The internal representation is a list of geometries")})
public class GamaGeoJsonFile
extends GamaGisFile {
    @GamlAnnotations.doc(value="This file constructor allows to read a geojson file (https://geojson.org/)", examples={@GamlAnnotations.example(value="file f <- geojson_file(\"file.json\");", isExecutable=false)})
    public GamaGeoJsonFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string, (Integer)null);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a geojson file and specifying the coordinates system code, as an int", examples={@GamlAnnotations.example(value="file f <- geojson_file(\"file.json\", 32648);", isExecutable=false)})
    public GamaGeoJsonFile(IScope iScope, String string, Integer n) {
        super(iScope, string, n);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a geojson file and specifying the coordinates system code (epg,...,), as a string", examples={@GamlAnnotations.example(value="file f <- geojson_file(\"file.json\", \"EPSG:32648\");", isExecutable=false)})
    public GamaGeoJsonFile(IScope iScope, String string, String string2) {
        super(iScope, string, string2);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a geojson file and take a potential z value (not taken in account by default)", examples={@GamlAnnotations.example(value="file f <- geojson_file(\"file.json\", true);", isExecutable=false)})
    public GamaGeoJsonFile(IScope iScope, String string, boolean bl) {
        super(iScope, string, (Integer)null, bl);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a geojson file, specifying the coordinates system code, as an int and take a potential z value (not taken in account by default)", examples={@GamlAnnotations.example(value="file f <- geojson_file(\"file.json\",32648, true);", isExecutable=false)})
    public GamaGeoJsonFile(IScope iScope, String string, Integer n, boolean bl) {
        super(iScope, string, n, bl);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a geojson file, specifying the coordinates system code (epg,...,), as a string and take a potential z value (not taken in account by default", examples={@GamlAnnotations.example(value="file f <- geojson_file(\"file.json\", \"EPSG:32648\",true);", isExecutable=false)})
    public GamaGeoJsonFile(IScope iScope, String string, String string2, boolean bl) {
        super(iScope, string, string2, bl);
    }

    @Override
    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        this.setBuffer(GamaListFactory.create(Types.GEOMETRY));
        this.readShapes(iScope);
    }

    @Override
    public IList<String> getAttributes(IScope iScope) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        SimpleFeatureCollection simpleFeatureCollection = this.getFeatureCollection(iScope);
        List list = ((SimpleFeatureType)simpleFeatureCollection.getSchema()).getAttributeDescriptors();
        for (AttributeDescriptor attributeDescriptor : list) {
            String string = attributeDescriptor.getType() instanceof GeometryType ? "geometry" : Types.get(attributeDescriptor.getType().getBinding()).toString();
            linkedHashMap.put(attributeDescriptor.getName().getLocalPart(), string);
        }
        return GamaListFactory.wrap((IType)Types.STRING, linkedHashMap.keySet());
    }

    @Override
    protected SimpleFeatureCollection getFeatureCollection(IScope iScope) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileReader fileReader = new FileReader(this.getFile(iScope));){
                FeatureJSON featureJSON = new FeatureJSON();
                return (SimpleFeatureCollection)featureJSON.readFeatureCollection((Object)fileReader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            GAMA.reportError(iScope, GamaRuntimeException.create(exception, iScope), true);
            return null;
        }
    }
}

