/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.csv;

import gama.core.util.file.csv.AbstractCSVManipulator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class CsvWriter
extends AbstractCSVManipulator {
    private Writer outputStream = null;

    public CsvWriter(String string, char c) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter fileName can not be null.");
        }
        this.fileName = string;
        this.delimiter = c;
    }

    public CsvWriter(String string) {
        this(string, CsvWriter.getDefaultDelimiter());
    }

    public CsvWriter(Writer writer, char c) {
        if (writer == null) {
            throw new IllegalArgumentException("Parameter outputStream can not be null.");
        }
        this.outputStream = writer;
        this.delimiter = c;
    }

    public CsvWriter(Writer writer) {
        this(writer, CsvWriter.getDefaultDelimiter());
    }

    public void write(String string, boolean bl) throws IOException {
        String string2 = string;
        this.checkInit();
        if (string2 == null) {
            string2 = "";
        }
        if (!this.firstColumn) {
            this.outputStream.write(this.delimiter);
        }
        if (bl && string2.length() > 0) {
            string2 = string2.replace(this.delimiter, ((Character)REPLACEMENTS.get(Character.valueOf(this.delimiter))).charValue());
        }
        this.outputStream.write(string2);
        this.firstColumn = false;
    }

    public void writeRecord(String[] stringArray, boolean bl) throws IOException {
        if (stringArray != null && stringArray.length > 0) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                this.write(string, bl);
                ++n2;
            }
            this.endRecord();
        }
    }

    public void writeRecord(String[] stringArray) throws IOException {
        this.writeRecord(stringArray, false);
    }

    @Override
    public void endRecord() throws IOException {
        this.checkInit();
        this.outputStream.write(System.lineSeparator());
        this.firstColumn = true;
    }

    private void checkInit() throws IOException {
        if (this.outputStream == null && this.fileName != null) {
            this.outputStream = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(new File(this.fileName).toPath(), new OpenOption[0]), Charset.forName("UTF-8")));
        }
    }

    @Override
    public void close() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (Exception exception) {}
        this.outputStream = null;
    }

    public static String replace(String string, String string2, String string3) {
        int n = string2.length();
        int n2 = string.indexOf(string2);
        if (n2 == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (n2 != -1) {
            stringBuilder.append(string.substring(n3, n2));
            stringBuilder.append(string3);
            n3 = n2 + n;
            n2 = string.indexOf(string2, n3);
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }
}

