/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.json;

import gama.core.metamodel.agent.AgentReference;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.SerialisedAgent;
import gama.core.runtime.IScope;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonAbstractObject;
import gama.core.util.file.json.JsonGamlAgent;
import gama.core.util.file.json.JsonObject;
import gama.core.util.file.json.JsonObjectMember;
import gama.core.util.file.json.JsonValue;

public class JsonGamaContentsObject
extends JsonAbstractObject {
    public JsonGamaContentsObject(JsonValue jsonValue, JsonObject jsonObject, Json json) {
        super(json);
        this.add("gama_contents", jsonValue).add("gama_references", jsonObject);
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public Object toGamlValue(IScope iScope) {
        JsonObject jsonObject = this.get("gama_references").asObject();
        this.recreateAgents(iScope, jsonObject);
        JsonValue jsonValue = this.get("gama_contents");
        return jsonValue.toGamlValue(iScope);
    }

    private void recreateAgents(IScope iScope, JsonObject jsonObject) {
        for (JsonObjectMember jsonObjectMember : jsonObject) {
            IAgent iAgent = AgentReference.of(jsonObjectMember.getName()).getReferencedAgent(iScope);
            JsonGamlAgent jsonGamlAgent = (JsonGamlAgent)jsonObjectMember.getValue();
            SerialisedAgent serialisedAgent = jsonGamlAgent.toGamlValue(iScope);
            serialisedAgent.restoreAs(iScope, iAgent);
        }
    }
}

