/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.matrix;

import com.google.common.primitives.Doubles;
import gama.core.common.interfaces.IImageProvider;
import gama.core.common.util.RandomUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.matrix.GamaField;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.GamaMatrix;
import gama.core.util.matrix.GamaObjectMatrix;
import gama.core.util.matrix.IMatrix;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaMatrixType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.ArrayUtils;
import org.locationtech.jts.index.quadtree.IntervalSize;

public class GamaFloatMatrix
extends GamaMatrix<Double>
implements IImageProvider {
    protected double[] matrix;

    public static GamaFloatMatrix from(IScope iScope, IMatrix iMatrix) {
        if (iMatrix instanceof GamaField) {
            return new GamaFloatMatrix(iMatrix.getCols(iScope), iMatrix.getRows(iScope), ((GamaField)iMatrix).matrix);
        }
        if (iMatrix instanceof GamaFloatMatrix) {
            return (GamaFloatMatrix)iMatrix;
        }
        if (iMatrix instanceof GamaObjectMatrix) {
            return new GamaFloatMatrix(iScope, iMatrix.getCols(iScope), iMatrix.getRows(iScope), ((GamaObjectMatrix)iMatrix).getMatrix());
        }
        if (iMatrix instanceof GamaIntMatrix) {
            return new GamaFloatMatrix(iMatrix.getCols(iScope), iMatrix.getRows(iScope), ((GamaIntMatrix)iMatrix).matrix);
        }
        return null;
    }

    public static GamaFloatMatrix from(IScope iScope, int n, int n2, IMatrix iMatrix) {
        if (iMatrix instanceof GamaFloatMatrix) {
            return new GamaFloatMatrix(n, n2, ((GamaFloatMatrix)iMatrix).getMatrix());
        }
        if (iMatrix instanceof GamaObjectMatrix) {
            return new GamaFloatMatrix(iScope, n, n2, ((GamaObjectMatrix)iMatrix).getMatrix());
        }
        if (iMatrix instanceof GamaIntMatrix) {
            return new GamaFloatMatrix(n, n2, ((GamaIntMatrix)iMatrix).matrix);
        }
        return null;
    }

    public GamaFloatMatrix(double[] dArray) {
        super(1, dArray.length, Types.FLOAT);
        this.setMatrix(dArray);
    }

    public GamaFloatMatrix(GamaPoint gamaPoint) {
        this((int)gamaPoint.x, (int)gamaPoint.y);
    }

    public GamaFloatMatrix(int n, int n2) {
        super(n, n2, Types.FLOAT);
        this.setMatrix(new double[n * n2]);
    }

    public GamaFloatMatrix(int n, int n2, double[] dArray) {
        this(n, n2);
        System.arraycopy(dArray, 0, this.getMatrix(), 0, Math.min(dArray.length, n2 * n));
    }

    public GamaFloatMatrix(int n, int n2, int[] nArray) {
        this(n, n2);
        int n3 = 0;
        int n4 = Math.min(nArray.length, n2 * n);
        while (n3 < n4) {
            this.matrix[n3] = nArray[n3];
            ++n3;
        }
    }

    public GamaFloatMatrix(IScope iScope, int n, int n2, Object[] objectArray) {
        this(n, n2);
        int n3 = 0;
        int n4 = Math.min(objectArray.length, n2 * n);
        while (n3 < n4) {
            this.matrix[n3] = Cast.asFloat(iScope, objectArray[n3]);
            ++n3;
        }
    }

    public GamaFloatMatrix(IScope iScope, List list, GamaPoint gamaPoint) throws GamaRuntimeException {
        super(iScope, list, gamaPoint, Types.FLOAT);
        this.setMatrix(new double[this.numRows * this.numCols]);
        if (gamaPoint != null) {
            int n = 0;
            int n2 = Math.min(this.getMatrix().length, list.size());
            while (n < n2) {
                this.getMatrix()[n] = Cast.asFloat(iScope, list.get(n));
                ++n;
            }
        } else if (GamaMatrix.isFlat(list)) {
            int n = 0;
            int n3 = list.size();
            while (n < n3) {
                this.getMatrix()[n] = Cast.asFloat(iScope, list.get(n));
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.numRows) {
                int n4 = 0;
                while (n4 < this.numCols) {
                    this.set(iScope, n4, n, Cast.asFloat(iScope, ((List)list.get(n4)).get(n)));
                    ++n4;
                }
                ++n;
            }
        }
    }

    public GamaFloatMatrix(IScope iScope, Object[] objectArray) {
        this(1, objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            this.getMatrix()[n] = Cast.asFloat(iScope, objectArray[n]);
            ++n;
        }
    }

    @Override
    protected IList _listValue(IScope iScope, IType iType, boolean bl) {
        return bl ? GamaListFactory.create(iScope, iType, this.matrix) : GamaListFactory.createWithoutCasting(iType, this.matrix);
    }

    @Override
    protected void _clear() {
        Arrays.fill(this.getMatrix(), 0.0);
    }

    @Override
    public boolean _contains(IScope iScope, Object object) {
        if (object instanceof Double) {
            Double d = (Double)object;
            int n = 0;
            while (n < this.getMatrix().length) {
                if (IntervalSize.isZeroWidth((double)this.getMatrix()[n], (double)d)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    @Override
    public Double _first(IScope iScope) {
        if (this.getMatrix().length == 0) {
            return 0.0;
        }
        return this.getMatrix()[0];
    }

    @Override
    public Double _last(IScope iScope) {
        if (this.getMatrix().length == 0) {
            return 0.0;
        }
        return this.getMatrix()[this.getMatrix().length - 1];
    }

    @Override
    public Integer _length(IScope iScope) {
        return this.getMatrix().length;
    }

    public GamaFloatMatrix _opAppendVertically(IScope iScope, GamaFloatMatrix gamaFloatMatrix) {
        double[] dArray = ArrayUtils.addAll((double[])this.getMatrix(), (double[])gamaFloatMatrix.getMatrix());
        return new GamaFloatMatrix(this.numCols, this.numRows + gamaFloatMatrix.getRows(iScope), dArray);
    }

    public IMatrix _opAppendHorizontally(IScope iScope, GamaFloatMatrix gamaFloatMatrix) {
        GamaFloatMatrix gamaFloatMatrix2 = this._reverse(iScope);
        GamaFloatMatrix gamaFloatMatrix3 = gamaFloatMatrix._reverse(iScope);
        GamaFloatMatrix gamaFloatMatrix4 = gamaFloatMatrix2._opAppendVertically(iScope, gamaFloatMatrix3);
        return gamaFloatMatrix4._reverse(iScope);
    }

    @Override
    public boolean _isEmpty(IScope iScope) {
        int n = 0;
        while (n < this.getMatrix().length) {
            if (this.getMatrix()[n] != 0.0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    protected IMatrix _matrixValue(IScope iScope, GamaPoint gamaPoint, IType iType, boolean bl) {
        return GamaMatrixType.from(iScope, this, iType, gamaPoint, bl);
    }

    public GamaFloatMatrix _reverse(IScope iScope) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(this.numRows, this.numCols);
        int n = 0;
        while (n < this.numCols) {
            int n2 = 0;
            while (n2 < this.numRows) {
                double d = this.get(iScope, n, n2);
                gamaFloatMatrix.set(iScope, n2, n, d);
                ++n2;
            }
            ++n;
        }
        return gamaFloatMatrix;
    }

    @Override
    public GamaFloatMatrix copy(IScope iScope, GamaPoint gamaPoint, boolean bl) {
        if (gamaPoint == null) {
            if (bl) {
                return new GamaFloatMatrix(this.numCols, this.numRows, Arrays.copyOf(this.getMatrix(), this.matrix.length));
            }
            return this;
        }
        return new GamaFloatMatrix((int)gamaPoint.getX(), (int)gamaPoint.getY(), Arrays.copyOf(this.getMatrix(), this.matrix.length));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GamaFloatMatrix)) {
            return false;
        }
        GamaFloatMatrix gamaFloatMatrix = (GamaFloatMatrix)object;
        return Arrays.equals(this.getMatrix(), gamaFloatMatrix.getMatrix());
    }

    @Override
    public void _putAll(IScope iScope, Object object) throws GamaRuntimeException {
        Arrays.fill(this.getMatrix(), Types.FLOAT.cast(iScope, object, null, false));
    }

    @Override
    public Double get(IScope iScope, int n, int n2) {
        if (n >= this.numCols || n < 0 || n2 >= this.numRows || n2 < 0) {
            return 0.0;
        }
        return this.getMatrix()[n2 * this.numCols + n];
    }

    @Override
    public void set(IScope iScope, int n, int n2, Object object) throws GamaRuntimeException {
        if (n < this.numCols && n >= 0 && n2 < this.numRows && n2 >= 0) {
            double d;
            this.getMatrix()[n2 * this.numCols + n] = d = Cast.asFloat(iScope, object).doubleValue();
        }
    }

    private boolean remove(double d) {
        int n = 0;
        while (n < this.getMatrix().length) {
            if (IntervalSize.isZeroWidth((double)this.getMatrix()[n], (double)d)) {
                this.getMatrix()[n] = 0.0;
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean _removeFirst(IScope iScope, Double d) throws GamaRuntimeException {
        return this.remove(d);
    }

    @Override
    public Double remove(IScope iScope, int n, int n2) {
        if (n >= this.numCols || n < 0 || n2 >= this.numRows || n2 < 0) {
            return 0.0;
        }
        double d = this.getMatrix()[n2 * this.numCols + n];
        this.getMatrix()[n2 * this.numCols + n] = 0.0;
        return d;
    }

    private boolean removeAll(double d) {
        boolean bl = false;
        int n = 0;
        while (n < this.getMatrix().length) {
            if (IntervalSize.isZeroWidth((double)this.getMatrix()[n], (double)d)) {
                this.getMatrix()[n] = 0.0;
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    @Override
    public boolean _removeAll(IScope iScope, IContainer<?, Double> iContainer) {
        for (Double d : iContainer.iterable(iScope)) {
            this.removeAll(d);
        }
        return true;
    }

    @Override
    public void shuffleWith(RandomUtils randomUtils) {
        randomUtils.shuffleInPlace(this.getMatrix());
    }

    @Override
    public Iterable<Double> iterable(IScope iScope) {
        return Doubles.asList((double[])this.getMatrix());
    }

    public double[] getMatrix() {
        return this.matrix;
    }

    void setMatrix(double[] dArray) {
        this.matrix = dArray;
    }

    @Override
    public GamaFloatMatrix plus(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = GamaFloatMatrix.from(iScope, iMatrix);
        if (gamaFloatMatrix != null && this.numCols == gamaFloatMatrix.numCols && this.numRows == gamaFloatMatrix.numRows) {
            GamaFloatMatrix gamaFloatMatrix2 = new GamaFloatMatrix(this.numCols, this.numRows);
            int n = 0;
            while (n < this.matrix.length) {
                gamaFloatMatrix2.matrix[n] = this.matrix[n] + gamaFloatMatrix.matrix[n];
                ++n;
            }
            return gamaFloatMatrix2;
        }
        throw GamaRuntimeException.error(" The dimensions of the matrices do not correspond", iScope);
    }

    @Override
    public GamaFloatMatrix times(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = GamaFloatMatrix.from(iScope, iMatrix);
        if (gamaFloatMatrix != null && this.numCols == gamaFloatMatrix.numCols && this.numRows == gamaFloatMatrix.numRows) {
            GamaFloatMatrix gamaFloatMatrix2 = new GamaFloatMatrix(this.numCols, this.numRows);
            int n = 0;
            while (n < this.matrix.length) {
                gamaFloatMatrix2.matrix[n] = this.matrix[n] * gamaFloatMatrix.matrix[n];
                ++n;
            }
            return gamaFloatMatrix2;
        }
        throw GamaRuntimeException.error(" The dimensions of the matrices do not correspond", iScope);
    }

    @Override
    public GamaFloatMatrix minus(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = GamaFloatMatrix.from(iScope, iMatrix);
        if (gamaFloatMatrix != null && this.numCols == gamaFloatMatrix.numCols && this.numRows == gamaFloatMatrix.numRows) {
            GamaFloatMatrix gamaFloatMatrix2 = new GamaFloatMatrix(this.numCols, this.numRows);
            int n = 0;
            while (n < this.matrix.length) {
                gamaFloatMatrix2.matrix[n] = this.matrix[n] - gamaFloatMatrix.matrix[n];
                ++n;
            }
            return gamaFloatMatrix2;
        }
        throw GamaRuntimeException.error(" The dimensions of the matrices do not correspond", iScope);
    }

    @Override
    public GamaFloatMatrix times(Double d) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(this.numCols, this.numRows);
        int n = 0;
        while (n < this.matrix.length) {
            gamaFloatMatrix.matrix[n] = this.matrix[n] * d;
            ++n;
        }
        return gamaFloatMatrix;
    }

    @Override
    public GamaFloatMatrix times(Integer n) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(this.numCols, this.numRows);
        int n2 = 0;
        while (n2 < this.matrix.length) {
            gamaFloatMatrix.matrix[n2] = this.matrix[n2] * (double)n.intValue();
            ++n2;
        }
        return gamaFloatMatrix;
    }

    @Override
    public GamaFloatMatrix divides(Double d) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(this.numCols, this.numRows);
        int n = 0;
        while (n < this.matrix.length) {
            gamaFloatMatrix.matrix[n] = this.matrix[n] / d;
            ++n;
        }
        return gamaFloatMatrix;
    }

    @Override
    public GamaFloatMatrix divides(Integer n) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(this.numCols, this.numRows);
        int n2 = 0;
        while (n2 < this.matrix.length) {
            gamaFloatMatrix.matrix[n2] = this.matrix[n2] / (double)n.intValue();
            ++n2;
        }
        return gamaFloatMatrix;
    }

    @Override
    public GamaFloatMatrix divides(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = GamaFloatMatrix.from(iScope, iMatrix);
        if (gamaFloatMatrix != null && this.numCols == gamaFloatMatrix.numCols && this.numRows == gamaFloatMatrix.numRows) {
            GamaFloatMatrix gamaFloatMatrix2 = new GamaFloatMatrix(this.numCols, this.numRows);
            int n = 0;
            while (n < this.matrix.length) {
                gamaFloatMatrix2.matrix[n] = this.matrix[n] / gamaFloatMatrix.matrix[n];
                ++n;
            }
            return gamaFloatMatrix2;
        }
        throw GamaRuntimeException.error(" The dimensions of the matrices do not correspond", iScope);
    }

    @Override
    public GamaFloatMatrix plus(Double d) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(this.numCols, this.numRows);
        int n = 0;
        while (n < this.matrix.length) {
            gamaFloatMatrix.matrix[n] = this.matrix[n] + d;
            ++n;
        }
        return gamaFloatMatrix;
    }

    @Override
    public GamaFloatMatrix plus(Integer n) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(this.numCols, this.numRows);
        int n2 = 0;
        while (n2 < this.matrix.length) {
            gamaFloatMatrix.matrix[n2] = this.matrix[n2] + (double)n.intValue();
            ++n2;
        }
        return gamaFloatMatrix;
    }

    @Override
    public GamaFloatMatrix minus(Double d) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(this.numCols, this.numRows);
        int n = 0;
        while (n < this.matrix.length) {
            gamaFloatMatrix.matrix[n] = this.matrix[n] - d;
            ++n;
        }
        return gamaFloatMatrix;
    }

    @Override
    public GamaFloatMatrix minus(Integer n) throws GamaRuntimeException {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(this.numCols, this.numRows);
        int n2 = 0;
        while (n2 < this.matrix.length) {
            gamaFloatMatrix.matrix[n2] = this.matrix[n2] - (double)n.intValue();
            ++n2;
        }
        return gamaFloatMatrix;
    }

    @Override
    public Double getNthElement(Integer n) {
        if (n == null || n > this.getMatrix().length) {
            return 0.0;
        }
        return this.getMatrix()[n];
    }

    @Override
    protected void setNthElement(IScope iScope, int n, Object object) {
        this.getMatrix()[n] = Cast.asFloat(iScope, object);
    }

    @Override
    public IContainerType getGamlType() {
        return Types.MATRIX.of(Types.FLOAT);
    }

    @Override
    public StreamEx<Double> stream(IScope iScope) {
        return DoubleStreamEx.of((double[])this.matrix).boxed();
    }

    @Override
    public double[] getFieldData(IScope iScope) {
        return this.matrix;
    }

    public static BufferedImage constructBufferedImageFromMatrix(IScope iScope, IMatrix<Integer> iMatrix) {
        if (!(iMatrix instanceof GamaIntMatrix)) {
            return null;
        }
        GamaIntMatrix gamaIntMatrix = (GamaIntMatrix)iMatrix;
        return gamaIntMatrix.getImage(iScope);
    }

    @Override
    public String getId() {
        return "matrix" + this.hashCode();
    }

    @Override
    public BufferedImage getImage(IScope iScope, boolean bl) {
        int n = this.getCols(iScope);
        int n2 = this.getRows(iScope);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                bufferedImage.setRGB(n3, n4, this.get(iScope, n3, n4).intValue());
                ++n4;
            }
            ++n3;
        }
        return bufferedImage;
    }
}

