/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GamaNode<T> {
    static Integer DEFAULT_WEIGHT = null;
    private T data;
    private Integer weight;
    private List<GamaNode<T>> children;
    private GamaNode<T> parent;

    public GamaNode(T t) {
        this(t, DEFAULT_WEIGHT);
    }

    public GamaNode(T t, Integer n) {
        this.weight = n;
        this.setData(t);
    }

    public GamaNode<T> getParent() {
        return this.parent;
    }

    public List<GamaNode<T>> getChildren() {
        if (this.children == null) {
            return Collections.EMPTY_LIST;
        }
        return this.children;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public GamaNode<T> addChild(GamaNode<T> gamaNode) {
        gamaNode.parent = this;
        if (this.children == null) {
            this.children = new ArrayList<GamaNode<T>>();
        }
        this.children.add(gamaNode);
        return gamaNode;
    }

    public GamaNode<T> addChild(T t) {
        return this.addChild(t, DEFAULT_WEIGHT);
    }

    public GamaNode<T> addChild(T t, Integer n) {
        GamaNode<T> gamaNode = new GamaNode<T>(t, n);
        return this.addChild((T)gamaNode);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T t) {
        this.data = t;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, 0);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GamaNode gamaNode = (GamaNode)object;
        return !(this.data == null ? gamaNode.data != null : !this.data.equals(gamaNode.data));
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void toString(StringBuilder stringBuilder, int n) {
        stringBuilder.append(this.getData());
        if (this.children != null) {
            stringBuilder.append("([");
            for (GamaNode<T> gamaNode : this.children) {
                gamaNode.toString(stringBuilder, n + 1);
                stringBuilder.append(',');
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append("])");
        }
        if (this.weight != null) {
            stringBuilder.append("::").append(this.getWeight());
        }
    }

    public void dispose() {
        this.parent = null;
        if (this.children != null) {
            for (GamaNode<T> gamaNode : this.children) {
                gamaNode.dispose();
            }
            this.children.clear();
        }
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer n) {
        this.weight = n;
    }

    public void attachTo(GamaNode<T> gamaNode) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        gamaNode.addChild(this);
    }

    private void removeChild(GamaNode<T> gamaNode) {
        this.children.remove(gamaNode);
    }
}

