/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.core.common.util.StringUtils;
import gama.core.util.BiConsumerWithPruning;
import gama.dev.DEBUG;
import gama.gaml.descriptions.BasicExpressionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.LabelExpressionDescription;
import gama.gaml.descriptions.StringBasedExpressionDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.interfaces.IGamlable;
import gama.gaml.types.IType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class Facets
extends HashMap<String, IExpressionDescription>
implements IGamlable {
    static Function<IExpressionDescription, IExpressionDescription> cleanCopy;
    public static final Facets NULL;

    static {
        DEBUG.OFF();
        cleanCopy = IExpressionDescription::cleanCopy;
        NULL = new Facets();
    }

    public boolean exists() {
        return !this.isEmpty();
    }

    public Facets() {
        this(5);
    }

    protected Facets(int n) {
        super(n, 0.8f);
    }

    public Facets(String ... stringArray) {
        this(stringArray == null ? 0 : stringArray.length % 2);
        if (stringArray != null) {
            int n = stringArray.length % 2 != 0 ? 1 : 0;
            while (n < stringArray.length) {
                this.put(stringArray[n], StringBasedExpressionDescription.create(stringArray[n + 1]));
                n += 2;
            }
        }
    }

    public Facets(Facets facets2) {
        super(facets2 == null ? Collections.EMPTY_MAP : facets2);
    }

    public void complementWith(Facets facets2) {
        facets2.forEach(this::putIfAbsent);
    }

    public IExpressionDescription getDescr(String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            IExpressionDescription iExpressionDescription = (IExpressionDescription)this.get(string);
            if (iExpressionDescription != null) {
                return iExpressionDescription;
            }
            ++n2;
        }
        return null;
    }

    public String getLabel(String string) {
        IExpressionDescription iExpressionDescription = (IExpressionDescription)this.get(string);
        if (iExpressionDescription == null) {
            return null;
        }
        return StringUtils.toJavaString(iExpressionDescription.toString());
    }

    public IExpression getExpr(String string) {
        return this.getExpr(string, (IExpression)null);
    }

    public IExpression getExpr(String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            IExpression iExpression = this.getExpr(string);
            if (iExpression != null) {
                return iExpression;
            }
            ++n2;
        }
        return null;
    }

    public IExpression getExpr(String string, IExpression iExpression) {
        IExpressionDescription iExpressionDescription = (IExpressionDescription)this.get(string);
        if (iExpressionDescription == null) {
            return iExpression;
        }
        return iExpressionDescription.getExpression();
    }

    public void putAsLabel(String string, String string2) {
        this.put(string, LabelExpressionDescription.create(string2));
    }

    public void putExpression(String string, IExpression iExpression) {
        IExpressionDescription iExpressionDescription = (IExpressionDescription)this.get(string);
        if (iExpressionDescription != null) {
            iExpressionDescription.setExpression(iExpression);
        } else {
            this.put(string, new BasicExpressionDescription(iExpression));
        }
    }

    @Override
    public IExpressionDescription put(String string, IExpressionDescription iExpressionDescription) {
        IExpressionDescription iExpressionDescription2 = (IExpressionDescription)this.get(string);
        if (iExpressionDescription2 != null) {
            return this.replace(string, iExpressionDescription);
        }
        return super.put(string, iExpressionDescription);
    }

    public boolean equals(String string, String string2) {
        IExpressionDescription iExpressionDescription = (IExpressionDescription)this.get(string);
        return iExpressionDescription == null ? string2 == null : iExpressionDescription.equalsString(string2);
    }

    public Facets cleanCopy() {
        Facets facets2 = new Facets(this.size());
        this.forEach((string, iExpressionDescription) -> {
            IExpressionDescription iExpressionDescription2 = facets2.put((String)string, iExpressionDescription.cleanCopy());
        });
        return facets2;
    }

    public void dispose() {
        this.forEach((string, iExpressionDescription) -> {
            if (iExpressionDescription != null) {
                iExpressionDescription.dispose();
            }
        });
    }

    public boolean forEachFacet(BiConsumerWithPruning<String, IExpressionDescription> biConsumerWithPruning) {
        for (Map.Entry entry : this.entrySet()) {
            if (biConsumerWithPruning.process((String)entry.getKey(), (IExpressionDescription)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean forEachFacetIn(Set<String> set, BiConsumerWithPruning<String, IExpressionDescription> biConsumerWithPruning) {
        if (set == null) {
            return this.forEachFacet(biConsumerWithPruning);
        }
        for (Map.Entry entry : this.entrySet()) {
            String string = (String)entry.getKey();
            if (!set.contains(string) || biConsumerWithPruning.process(string, (IExpressionDescription)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public String getFirstExistingAmong(String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (this.containsKey(string)) {
                return string;
            }
            ++n2;
        }
        return null;
    }

    public IType<?> getTypeDenotedBy(String string, IDescription iDescription, IType<?> iType) {
        IExpressionDescription iExpressionDescription = (IExpressionDescription)this.get(string);
        if (iExpressionDescription == null) {
            return iType;
        }
        return iExpressionDescription.getDenotedType(iDescription);
    }
}

