/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.RemoteSequence;
import gama.gaml.types.Types;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="source", type={11, 14, 16, -201}, of=11, optional=false, doc={@GamlAnnotations.doc(value="can be an agent, a list of agents, a agent's population to be migrated")}), @GamlAnnotations.facet(name="target", type={14}, optional=false, doc={@GamlAnnotations.doc(value="target species/population that source agent(s) migrate to.")}), @GamlAnnotations.facet(name="returns", type={-204}, optional=true, doc={@GamlAnnotations.doc(value="the list of returned agents in a new local variable")})}, omissible="source")
@validator(value=MigrateValidator.class)
@GamlAnnotations.doc(value="This command permits agents to migrate from one population/species to another population/species and stay in the same host after the migration. Species of source agents and target species respect the following constraints: (i) they are \"peer\" species (sharing the same direct macro-species), (ii) they have sub-species vs. parent-species relationship.", usages={@GamlAnnotations.usage(value="It can be used in a 3-levels model, in case where individual agents can be captured into group meso agents and groups into clouds macro agents. migrate is used to allows agents captured by groups to migrate into clouds. See the model 'Balls, Groups and Clouds.gaml' in the library.", examples={@GamlAnnotations.example(value="migrate ball_in_group target: ball_in_cloud;", isExecutable=false)})}, see={"capture", "release"})
public class MigrateStatement
extends AbstractStatementSequence {
    private final String source = this.getLiteral("source");
    private final String target = this.getLiteral("target");
    private final String returnString = this.getLiteral("returns");
    private RemoteSequence sequence = null;

    public MigrateStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.sequence = new RemoteSequence(this.description);
        this.sequence.setName("commands of " + this.getName());
        this.sequence.setChildren(iterable);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        IMacroAgent iMacroAgent = (IMacroAgent)iScope.getAgent();
        IList iList = GamaListFactory.create(Types.AGENT);
        ISpecies iSpecies = iMacroAgent.getSpecies().getMicroSpecies(this.target);
        ISpecies iSpecies2 = iMacroAgent.getSpecies().getMicroSpecies(this.source);
        iList.addAll(iMacroAgent.migrateMicroAgents(iScope, iSpecies2, iSpecies));
        if (this.returnString != null) {
            iScope.setVarValue(this.returnString, iList);
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.sequence != null) {
            this.sequence.dispose();
        }
        this.sequence = null;
        super.dispose();
    }

    public static class MigrateValidator
    implements IDescriptionValidator<StatementDescription> {
        @Override
        public void validate(StatementDescription statementDescription) {
            SpeciesDescription speciesDescription;
            SpeciesDescription speciesDescription2;
            String string = statementDescription.getLitteral("target");
            if (string != null && (speciesDescription2 = (speciesDescription = statementDescription.getSpeciesContext()).getMicroSpecies(string)) == null) {
                statementDescription.error(speciesDescription.getName() + " species doesn't contain " + string + " as micro-species", "gaml.unknown.species.issue", "target", string);
            }
        }
    }
}

