/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaPair;
import gama.core.util.IMap;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@GamlAnnotations.type(name="point", id=7, wraps={GamaPoint.class}, kind=101, concept={"type", "point"}, doc={@GamlAnnotations.doc(value="Represent locations in either 2 or 3 dimensions")})
public class GamaPointType
extends GamaType<GamaPoint> {
    @Override
    @GamlAnnotations.doc(value="Transforms the parameter into a point. If it is already a point, returns it. If it is a geometry, returns its location. If it is a list, interprets its elements as float values and use up to the first 3 ones to return a point. If it is a map, tries to find 'x', 'y' and 'z' keys in it. If it is a number, returns a point with the x, y and equal to this value")
    public GamaPoint cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return GamaPointType.staticCast(iScope, object, bl);
    }

    public static GamaPoint staticCast(IScope iScope, Object object, boolean bl) {
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GamaPoint.class, IShape.class, List.class, GamaColor.class, Map.class, String.class, GamaPair.class}, (Object)object2, n)) {
            case -1 -> null;
            case 0 -> {
                GamaPoint var5_5 = (GamaPoint)object2;
                if (bl) {
                    yield new GamaPoint(var5_5);
                }
                yield var5_5;
            }
            case 1 -> {
                IShape var6_6 = (IShape)object2;
                yield var6_6.getLocation();
            }
            case 2 -> {
                List var7_7 = (List)object2;
                yield GamaPointType.castFromList(iScope, var7_7, bl);
            }
            case 3 -> {
                GamaColor var8_8 = (GamaColor)object2;
                yield new GamaPoint(var8_8.getRed(), var8_8.getGreen(), var8_8.getBlue());
            }
            case 4 -> {
                Map var9_9 = (Map)object2;
                yield GamaPointType.castFromMap(iScope, var9_9);
            }
            case 5 -> {
                String var10_10 = (String)object2;
                yield GamaPointType.castFromString(iScope, var10_10);
            }
            case 6 -> {
                GamaPair var11_11 = (GamaPair)object2;
                yield new GamaPoint(Cast.asFloat(iScope, var11_11.first()), Cast.asFloat(iScope, var11_11.last()));
            }
            default -> {
                Double var12_12 = Cast.asFloat(iScope, object);
                yield new GamaPoint(var12_12, var12_12, var12_12);
            }
        };
    }

    private static GamaPoint castFromMap(IScope iScope, Map map) {
        double d = Cast.asFloat(iScope, map.get("x"));
        double d2 = Cast.asFloat(iScope, map.get("y"));
        double d3 = Cast.asFloat(iScope, map.get("z"));
        return new GamaPoint(d, d2, d3);
    }

    private static GamaPoint castFromString(IScope iScope, String string) {
        String string2 = string.trim();
        if (string2.startsWith("{") && string2.endsWith("}")) {
            string2 = string2.replace("{", "").replace("}", "").trim();
            return GamaPointType.staticCast(iScope, Arrays.asList(string2.split(",")), false);
        }
        throw GamaRuntimeException.error("Cannot cast " + string + " into a point", iScope);
    }

    private static GamaPoint castFromList(IScope iScope, List list, boolean bl) {
        if (list.size() > 2) {
            return new GamaPoint(Cast.asFloat(iScope, list.get(0)), Cast.asFloat(iScope, list.get(1)), Cast.asFloat(iScope, list.get(2)));
        }
        if (list.size() > 1) {
            return new GamaPoint(Cast.asFloat(iScope, list.get(0)), Cast.asFloat(iScope, list.get(1)));
        }
        if (list.size() > 0) {
            return GamaPointType.staticCast(iScope, list.get(0), bl);
        }
        return new GamaPoint(0.0, 0.0, 0.0);
    }

    @Override
    public GamaPoint getDefault() {
        return null;
    }

    @Override
    public IType getContentType() {
        return Types.get(2);
    }

    @Override
    public IType getKeyType() {
        return Types.get(1);
    }

    @Override
    public boolean canCastToConst() {
        return true;
    }

    @Override
    public boolean isDrawable() {
        return true;
    }

    @Override
    public boolean isCompoundType() {
        return true;
    }

    @Override
    public GamaPoint deserializeFromJson(IScope iScope, IMap<String, Object> iMap) {
        return new GamaPoint(Cast.asFloat(iScope, iMap.get("x")), Cast.asFloat(iScope, iMap.get("y")), Cast.asFloat(iScope, iMap.get("z")));
    }
}

