/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.grid;

import gama.core.common.geometry.Envelope3D;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.population.IPopulationSet;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.AbstractTopology;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.filter.Different;
import gama.core.metamodel.topology.filter.DifferentList;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.metamodel.topology.grid.GamaSpatialMatrix;
import gama.core.metamodel.topology.grid.IGrid;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.GamaGridFile;
import gama.core.util.path.GamaSpatialPath;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class GridTopology
extends AbstractTopology {
    public GridTopology(IScope iScope, IGrid iGrid) {
        super(iScope, iGrid.getEnvironmentFrame(), null);
        this.places = iGrid;
    }

    @Override
    public void updateAgent(Envelope3D envelope3D, IAgent iAgent) {
    }

    @Override
    public void initialize(IScope iScope, IPopulation<? extends IAgent> iPopulation) throws GamaRuntimeException {
        this.getPlaces().setCellSpecies(iPopulation);
        super.initialize(iScope, iPopulation);
    }

    @Override
    protected boolean canCreateAgents() {
        return true;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    public GridTopology(IScope iScope, IShape iShape, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string) throws GamaRuntimeException {
        super(iScope, iShape, null);
        this.places = bl3 ? new GamaSpatialMatrix(iScope, iShape, n, n2, bl, bl2, bl3, bl4, bl5, bl6, string) : new GamaSpatialMatrix(iScope, iShape, n, n2, bl, bl2, bl5, bl6, string);
    }

    public GridTopology(IScope iScope, IShape iShape, GamaGridFile gamaGridFile, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) throws GamaRuntimeException {
        super(iScope, iShape, null);
        this.places = new GamaSpatialMatrix(iScope, gamaGridFile, bl, bl2, bl3, bl4, string);
    }

    public GridTopology(IScope iScope, IShape iShape, IList<GamaGridFile> iList, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) throws GamaRuntimeException {
        super(iScope, iShape, null);
        this.places = new GamaSpatialMatrix(iScope, iList, bl, bl2, bl3, bl4, string);
    }

    @Override
    public IAgent getAgentClosestTo(IScope iScope, IShape iShape, IAgentFilter iAgentFilter) {
        return ((GamaSpatialMatrix)this.getPlaces()).getAgentClosestTo(iScope, iShape, iAgentFilter);
    }

    @Override
    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return "Grid topology in " + this.environment.toString() + " as " + this.places.toString();
    }

    @Override
    protected String _toGaml(boolean bl) {
        return "topology (" + this.places.serializeToGaml(bl) + ")";
    }

    @Override
    protected ITopology _copy(IScope iScope) throws GamaRuntimeException {
        IGrid iGrid = (IGrid)this.places;
        return new GridTopology(iScope, this.environment, iGrid.getRows(iScope), iGrid.getCols(iScope), iGrid.isTorus(), iGrid.getNeighborhood().isVN(), iGrid.isHexagon(), iGrid.isHorizontalOrientation(), iGrid.usesIndiviualShapes(), iGrid.usesNeighborsCache(), iGrid.optimizer());
    }

    public IGrid getPlaces() {
        return (IGrid)super.getPlaces();
    }

    public GamaSpatialPath pathBetween(IScope iScope, IShape iShape, IShape iShape2, IList<IAgent> iList) throws GamaRuntimeException {
        return this.getPlaces().computeShortestPathBetween(iScope, iShape, iShape2, this, iList);
    }

    public GamaSpatialPath pathBetween(IScope iScope, IShape iShape, IShape iShape2, Map<IAgent, Object> map) throws GamaRuntimeException {
        return this.getPlaces().computeShortestPathBetweenWeighted(iScope, iShape, iShape2, this, map);
    }

    @Override
    public GamaSpatialPath pathBetween(IScope iScope, IShape iShape, IShape iShape2) throws GamaRuntimeException {
        return this.getPlaces().computeShortestPathBetween(iScope, iShape, iShape2, this, null);
    }

    @Override
    public boolean isValidLocation(IScope iScope, GamaPoint gamaPoint) {
        return this.getPlaces().getPlaceAt(gamaPoint) != null;
    }

    @Override
    public boolean isValidGeometry(IScope iScope, IShape iShape) {
        return this.isValidLocation(iScope, iShape.getLocation());
    }

    @Override
    public Double distanceBetween(IScope iScope, IShape iShape, IShape iShape2) {
        if (!this.isValidGeometry(iScope, iShape) || !this.isValidGeometry(iScope, iShape2)) {
            return Double.MAX_VALUE;
        }
        return this.getPlaces().manhattanDistanceBetween(iShape, iShape2);
    }

    @Override
    public Double distanceBetween(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        if (!this.isValidLocation(iScope, gamaPoint) || !this.isValidLocation(iScope, gamaPoint2)) {
            return Double.MAX_VALUE;
        }
        return this.getPlaces().manhattanDistanceBetween(gamaPoint, gamaPoint2);
    }

    @Override
    public Double directionInDegreesTo(IScope iScope, IShape iShape, IShape iShape2) {
        return this.root.directionInDegreesTo(iScope, iShape, iShape2);
    }

    @Override
    public Collection<IAgent> getNeighborsOf(IScope iScope, IShape iShape, Double d, IAgentFilter iAgentFilter) throws GamaRuntimeException {
        Set<IAgent> set = this.getPlaces().getNeighborsOf(iScope, iShape, d, this.getPlaces().getCellSpecies());
        if (iAgentFilter.getSpecies() == this.getPlaces().getCellSpecies()) {
            if (iAgentFilter instanceof IPopulationSet) {
                return set;
            }
            Throwable throwable = null;
            Object var7_9 = null;
            try (Collector.AsOrderedSet asOrderedSet = Collector.getOrderedSet();){
                for (IAgent iAgent : set) {
                    if (!iAgentFilter.accept(iScope, null, iAgent)) continue;
                    asOrderedSet.add(iAgent);
                }
                return asOrderedSet.items();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        boolean bl = iAgentFilter.getSpecies() != null || !(iAgentFilter instanceof Different);
        IAgentFilter iAgentFilter2 = bl ? iAgentFilter : new DifferentList(this.getPlaces().getCellSpecies().listValue(iScope, Types.NO_TYPE, false));
        Collection<IAgent> collection = this.getAgentsIn(iScope, GamaGeometryType.geometriesToGeometry(iScope, GamaListFactory.wrap(Types.AGENT, set)), iAgentFilter2, ITopology.SpatialRelation.OVERLAP);
        if (!bl) {
            collection.addAll(set);
        }
        return collection;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getPlaces().dispose();
    }

    public void setPlaces(IGrid iGrid) {
        this.places = iGrid;
    }
}

