/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime;

import gama.core.common.interfaces.IBenchmarkable;
import gama.core.common.interfaces.IGui;
import gama.core.common.interfaces.ISnapshotMaker;
import gama.core.common.interfaces.ITopLevelAgentChangeListener;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.util.PoolUtils;
import gama.core.common.util.RandomUtils;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.ExperimentPlan;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.IExperimentController;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.kernel.model.IModel;
import gama.core.kernel.root.PlatformAgent;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.runtime.IExperimentStateListener;
import gama.core.runtime.IScope;
import gama.core.runtime.NullGuiHandler;
import gama.core.runtime.benchmark.Benchmark;
import gama.core.runtime.benchmark.StopWatch;
import gama.core.runtime.concurrent.BufferingController;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.runtime.server.IGamaServer;
import gama.dev.DEBUG;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.kernel.GamaBundleLoader;
import gama.gaml.compilation.kernel.GamaMetaModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class GAMA {
    public static final String VERSION_NUMBER = "2025.5.0-SNAPSHOT";
    public static final String VERSION = "GAMA 2025.5.0-SNAPSHOT";
    private static volatile PlatformAgent agent;
    private static ISnapshotMaker snapshotAgent;
    private static Benchmark benchmarkAgent;
    private static boolean isInHeadlessMode;
    private static boolean isInServerMode;
    private static volatile boolean isSynchronized;
    private static IGui regularGui;
    private static volatile IGui headlessGui;
    private static volatile ITopLevelAgent currentTopLevelAgent;
    private static List<ITopLevelAgentChangeListener> topLevelAgentListeners;
    private static List<IExperimentStateListener> experimentStateListeners;
    private static final List<IExperimentController> controllers;
    private static final BufferingController bufferingController;

    static {
        DEBUG.OFF();
        topLevelAgentListeners = new CopyOnWriteArrayList<ITopLevelAgentChangeListener>();
        experimentStateListeners = new CopyOnWriteArrayList<IExperimentStateListener>();
        controllers = new CopyOnWriteArrayList<IExperimentController>();
        bufferingController = new BufferingController();
    }

    public static List<IExperimentController> getControllers() {
        return controllers;
    }

    public static IExperimentController getFrontmostController() {
        return controllers.isEmpty() ? null : controllers.get(0);
    }

    public static BufferingController getBufferingController() {
        return bufferingController;
    }

    public static void runGuiExperiment(String string, IModel iModel) {
        IExperimentPlan iExperimentPlan;
        IExperimentPlan iExperimentPlan2 = iModel.getExperiment(string);
        if (iExperimentPlan2 == null) {
            return;
        }
        IExperimentController iExperimentController = GAMA.getFrontmostController();
        if (iExperimentController != null && (iExperimentPlan = iExperimentController.getExperiment()) != null) {
            iExperimentController.processPause(true);
            if (!GAMA.getGui().confirmClose(iExperimentPlan)) {
                return;
            }
        }
        iExperimentController = iExperimentPlan2.getController();
        if (!controllers.isEmpty()) {
            GAMA.closeAllExperiments(false, false);
        }
        if (GAMA.getGui().openSimulationPerspective(iModel, string)) {
            controllers.add(iExperimentController);
            GAMA.startBenchmark(iExperimentPlan2);
            iExperimentController.processOpen(false);
        } else {
            DEBUG.ERR((Object)("Unable to launch simulation perspective for experiment " + string + " of model " + iModel.getFilePath()));
        }
    }

    public static synchronized IExperimentPlan addHeadlessExperiment(IModel iModel, String string, ParametersSet parametersSet, Double d) {
        ExperimentPlan experimentPlan = (ExperimentPlan)iModel.getExperiment(string);
        if (experimentPlan == null) {
            throw GamaRuntimeException.error("Experiment " + string + " does not exist. Please check its name.", GAMA.getRuntimeScope());
        }
        experimentPlan.setHeadless(true);
        for (Map.Entry entry : parametersSet.entrySet()) {
            IParameter.Batch batch = experimentPlan.getParameterByTitle((String)entry.getKey());
            if (batch != null) {
                experimentPlan.setParameterValueByTitle(experimentPlan.getExperimentScope(), (String)entry.getKey(), entry.getValue());
                continue;
            }
            experimentPlan.setParameterValue(experimentPlan.getExperimentScope(), (String)entry.getKey(), entry.getValue());
        }
        experimentPlan.open(d);
        controllers.add(experimentPlan.getController());
        return experimentPlan;
    }

    public static void closeExperiment(IExperimentPlan iExperimentPlan) {
        if (iExperimentPlan == null) {
            return;
        }
        GAMA.closeController(iExperimentPlan.getController());
        GAMA.changeCurrentTopLevelAgent(GAMA.getPlatformAgent(), false);
    }

    public static void closeAllExperiments(boolean bl, boolean bl2) {
        for (IExperimentController iExperimentController : new ArrayList<IExperimentController>(controllers)) {
            GAMA.closeController(iExperimentController);
        }
        GAMA.getGui().closeSimulationViews(null, bl, bl2);
        PoolUtils.writeStats();
        GAMA.changeCurrentTopLevelAgent(GAMA.getPlatformAgent(), false);
    }

    private static void closeController(IExperimentController iExperimentController) {
        if (iExperimentController == null) {
            return;
        }
        GAMA.stopBenchmark(iExperimentController.getExperiment());
        GAMA.desynchronizeFrontmostExperiment();
        iExperimentController.close();
        controllers.remove(iExperimentController);
    }

    public static SimulationAgent getSimulation() {
        IExperimentController iExperimentController = GAMA.getFrontmostController();
        if (iExperimentController == null || iExperimentController.getExperiment() == null) {
            return null;
        }
        return iExperimentController.getExperiment().getCurrentSimulation();
    }

    public static IExperimentPlan getExperiment() {
        IExperimentController iExperimentController = GAMA.getFrontmostController();
        if (iExperimentController == null) {
            return null;
        }
        return iExperimentController.getExperiment();
    }

    public static IExperimentAgent getExperimentAgent() {
        IExperimentPlan iExperimentPlan = GAMA.getExperiment();
        if (iExperimentPlan == null) {
            return null;
        }
        return iExperimentPlan.getAgent();
    }

    public static IModel getModel() {
        IExperimentController iExperimentController = GAMA.getFrontmostController();
        if (iExperimentController == null || iExperimentController.getExperiment() == null) {
            return GamaMetaModel.INSTANCE.getAbstractModelSpecies();
        }
        return iExperimentController.getExperiment().getModel();
    }

    public static boolean reportError(IScope iScope, GamaRuntimeException gamaRuntimeException, boolean bl) {
        boolean bl2;
        boolean bl3 = gamaRuntimeException.isWarning();
        boolean bl4 = bl2 = (bl3 && GamaPreferences.Runtime.CORE_WARNINGS.getValue() != false || !bl3 && bl) && GamaPreferences.Runtime.CORE_REVEAL_AND_STOP.getValue() != false;
        if (gamaRuntimeException.isReported()) {
            return !bl2;
        }
        IExperimentController iExperimentController = GAMA.getFrontmostController();
        if (iExperimentController == null || iExperimentController.getExperiment() == null || iExperimentController.isDisposing() || iExperimentController.getExperiment().getAgent() == null) {
            return false;
        }
        if (!(gamaRuntimeException instanceof GamaRuntimeException.GamaRuntimeFileException) && iScope != null && !iScope.reportErrors()) {
            gamaRuntimeException.printStackTrace();
            return true;
        }
        if (iScope != null && iScope.getGui() != null) {
            iScope.getGui().runtimeError(iScope, gamaRuntimeException);
        }
        gamaRuntimeException.setReported();
        return !bl2;
    }

    public static void reportAndThrowIfNeeded(IScope iScope, GamaRuntimeException gamaRuntimeException, boolean bl) {
        boolean bl2;
        if (iScope == null || GAMA.getExperiment() == null && !(gamaRuntimeException instanceof GamaRuntimeException.GamaRuntimeFileException) && !iScope.reportErrors()) {
            gamaRuntimeException.printStackTrace();
            return;
        }
        if (iScope.getAgent() != null) {
            String string = iScope.getAgent().getName();
            if (!gamaRuntimeException.getAgentsNames().contains(string)) {
                gamaRuntimeException.addAgent(string);
            }
        }
        iScope.setCurrentError(gamaRuntimeException);
        if (iScope.isInTryMode()) {
            throw gamaRuntimeException;
        }
        boolean bl3 = bl2 = !GAMA.reportError(iScope, gamaRuntimeException, bl);
        if (bl2) {
            if (GAMA.isInHeadLessMode() && !GAMA.isInServerMode()) {
                throw gamaRuntimeException;
            }
            GAMA.pauseFrontmostExperiment(false);
            throw gamaRuntimeException;
        }
    }

    public static boolean startPauseFrontmostExperiment(boolean bl) {
        for (IExperimentController iExperimentController : controllers) {
            if (iExperimentController.processStartPause(bl)) continue;
            return false;
        }
        return true;
    }

    public static boolean stepFrontmostExperiment(boolean bl) {
        for (IExperimentController iExperimentController : controllers) {
            if (iExperimentController.processStep(bl)) continue;
            return false;
        }
        return true;
    }

    public static boolean stepBackFrontmostExperiment(boolean bl) {
        for (IExperimentController iExperimentController : controllers) {
            if (iExperimentController.processBack(bl)) continue;
            return false;
        }
        return true;
    }

    public static boolean pauseFrontmostExperiment(boolean bl) {
        for (IExperimentController iExperimentController : controllers) {
            if (iExperimentController.processPause(bl)) continue;
            return false;
        }
        return true;
    }

    public static boolean resumeFrontmostExperiment(boolean bl) {
        for (IExperimentController iExperimentController : controllers) {
            if (iExperimentController.processStart(bl)) continue;
            return false;
        }
        return true;
    }

    public static boolean reloadFrontmostExperiment(boolean bl) {
        IExperimentController iExperimentController = GAMA.getFrontmostController();
        return iExperimentController != null && iExperimentController.processReload(bl);
    }

    public static boolean startFrontmostExperiment(boolean bl) {
        IExperimentController iExperimentController = GAMA.getFrontmostController();
        return iExperimentController != null && iExperimentController.processStart(bl);
    }

    public static boolean isPaused() {
        IExperimentController iExperimentController = GAMA.getFrontmostController();
        if (iExperimentController == null || iExperimentController.getExperiment() == null) {
            return true;
        }
        return iExperimentController.isPaused();
    }

    public static void releaseScope(IScope iScope) {
        if (iScope != null) {
            iScope.clear();
        }
    }

    private static IScope copyRuntimeScope(String string) {
        IScope iScope = GAMA.getRuntimeScope();
        if (iScope != null) {
            return iScope.copy(string);
        }
        return null;
    }

    public static IScope getRuntimeScope() {
        if (!GamaBundleLoader.LOADED) {
            return null;
        }
        IExperimentController iExperimentController = GAMA.getFrontmostController();
        if (iExperimentController == null || iExperimentController.getExperiment() == null) {
            return GAMA.getPlatformAgent().getScope();
        }
        ExperimentAgent experimentAgent = iExperimentController.getExperiment().getAgent();
        if (experimentAgent == null || experimentAgent.dead()) {
            return iExperimentController.getExperiment().getExperimentScope();
        }
        SimulationAgent simulationAgent = experimentAgent.getSimulation();
        if (simulationAgent == null || simulationAgent.dead()) {
            return experimentAgent.getScope();
        }
        return simulationAgent.getScope();
    }

    public static RandomUtils getCurrentRandom() {
        IScope iScope = GAMA.getRuntimeScope();
        if (iScope == null) {
            return new RandomUtils();
        }
        return iScope.getRandom();
    }

    public static <T> T run(InScope<T> inScope) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IScope iScope = GAMA.copyRuntimeScope(" in temporary scope block");){
            return inScope.run(iScope);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final void runAndUpdateAll(Runnable runnable) {
        runnable.run();
        IExperimentPlan iExperimentPlan = GAMA.getExperiment();
        if (iExperimentPlan != null) {
            iExperimentPlan.refreshAllOutputs();
        }
    }

    public static IGui getGui() {
        if (isInHeadlessMode || regularGui == null) {
            return GAMA.getHeadlessGui();
        }
        return regularGui;
    }

    public static IGui getHeadlessGui() {
        if (headlessGui == null) {
            headlessGui = new NullGuiHandler();
        }
        return headlessGui;
    }

    public static IGui getRegularGui() {
        return regularGui;
    }

    public static void setHeadlessGui(IGui iGui) {
        headlessGui = iGui;
    }

    public static void setRegularGui(IGui iGui) {
        regularGui = iGui;
    }

    public static boolean isInHeadLessMode() {
        return isInHeadlessMode;
    }

    public static boolean isInServerMode() {
        return isInServerMode;
    }

    public static void setHeadLessMode(boolean bl) {
        isInHeadlessMode = true;
        isInServerMode = bl;
    }

    public static void relaunchFrontmostExperiment() {
    }

    public static void registerTopLevelAgentChangeListener(ITopLevelAgentChangeListener iTopLevelAgentChangeListener) {
        if (!topLevelAgentListeners.contains(iTopLevelAgentChangeListener)) {
            topLevelAgentListeners.add(iTopLevelAgentChangeListener);
        }
    }

    public static void removeTopLevelAgentChangeListener(ITopLevelAgentChangeListener iTopLevelAgentChangeListener) {
        topLevelAgentListeners.remove(iTopLevelAgentChangeListener);
    }

    public static PlatformAgent getPlatformAgent() {
        if (agent == null) {
            agent = new PlatformAgent();
        }
        return agent;
    }

    public static IGamaServer getServer() {
        return GAMA.getPlatformAgent().getServer();
    }

    public static ITopLevelAgent getCurrentTopLevelAgent() {
        if (currentTopLevelAgent == null || currentTopLevelAgent.dead() || currentTopLevelAgent.getScope().isClosed()) {
            currentTopLevelAgent = GAMA.computeCurrentTopLevelAgent();
        }
        return currentTopLevelAgent;
    }

    public static void changeCurrentTopLevelAgent(ITopLevelAgent iTopLevelAgent, boolean bl) {
        if (currentTopLevelAgent == iTopLevelAgent && !bl) {
            return;
        }
        currentTopLevelAgent = iTopLevelAgent;
        for (ITopLevelAgentChangeListener iTopLevelAgentChangeListener : topLevelAgentListeners) {
            iTopLevelAgentChangeListener.topLevelAgentChanged(iTopLevelAgent);
        }
    }

    private static ITopLevelAgent computeCurrentTopLevelAgent() {
        IExperimentPlan iExperimentPlan = GAMA.getExperiment();
        if (iExperimentPlan == null) {
            return GAMA.getPlatformAgent();
        }
        ExperimentAgent experimentAgent = iExperimentPlan.getAgent();
        if (experimentAgent == null || experimentAgent.dead()) {
            return GAMA.getPlatformAgent();
        }
        SimulationAgent simulationAgent = experimentAgent.getSimulation();
        if (simulationAgent == null || simulationAgent.dead()) {
            return experimentAgent;
        }
        return simulationAgent;
    }

    public static StopWatch benchmark(IScope iScope, Object object) {
        if (benchmarkAgent == null || object == null || iScope == null) {
            return StopWatch.NULL;
        }
        if (object instanceof IBenchmarkable) {
            IBenchmarkable iBenchmarkable = (IBenchmarkable)object;
            return benchmarkAgent.record(iScope, iBenchmarkable);
        }
        if (object instanceof ISymbol) {
            ISymbol iSymbol = (ISymbol)object;
            return benchmarkAgent.record(iScope, iSymbol.getDescription());
        }
        return StopWatch.NULL;
    }

    public static void startBenchmark(IExperimentPlan iExperimentPlan) {
        if (iExperimentPlan.shouldBeBenchmarked()) {
            benchmarkAgent = new Benchmark(iExperimentPlan);
        }
    }

    public static void stopBenchmark(IExperimentPlan iExperimentPlan) {
        if (benchmarkAgent != null) {
            benchmarkAgent.saveAndDispose(iExperimentPlan);
        }
        benchmarkAgent = null;
    }

    public static void desynchronizeFrontmostExperiment() {
        isSynchronized = false;
    }

    public static boolean isSynchronized() {
        return isSynchronized;
    }

    public static void synchronizeFrontmostExperiment() {
        isSynchronized = true;
    }

    public static void setSnapshotMaker(ISnapshotMaker iSnapshotMaker) {
        if (iSnapshotMaker != null) {
            snapshotAgent = iSnapshotMaker;
        }
    }

    public static ISnapshotMaker getSnapshotMaker() {
        if (snapshotAgent == null) {
            return IGui.NULL_SNAPSHOT_MAKER;
        }
        return snapshotAgent;
    }

    public static void addExperimentStateListener(IExperimentStateListener iExperimentStateListener) {
        if (!experimentStateListeners.contains(iExperimentStateListener)) {
            experimentStateListeners.add(iExperimentStateListener);
        }
    }

    public static void removeExperimentStateListener(IExperimentStateListener iExperimentStateListener) {
        experimentStateListeners.remove(iExperimentStateListener);
    }

    public static IExperimentStateListener.State getExperimentState(IExperimentPlan iExperimentPlan) {
        IExperimentController iExperimentController;
        IExperimentController iExperimentController2 = iExperimentController = iExperimentPlan == null ? GAMA.getFrontmostController() : iExperimentPlan.getController();
        if (iExperimentController != null) {
            if (iExperimentController.isPaused()) {
                return IExperimentStateListener.State.PAUSED;
            }
            return IExperimentStateListener.State.RUNNING;
        }
        return IExperimentStateListener.State.NONE;
    }

    public static void updateExperimentState(IExperimentPlan iExperimentPlan, IExperimentStateListener.State state) {
        for (IExperimentStateListener iExperimentStateListener : experimentStateListeners) {
            iExperimentStateListener.updateStateTo(iExperimentPlan, state);
        }
        GAMA.getGui().getStatus().updateExperimentStatus();
    }

    public static void updateExperimentState(IExperimentPlan iExperimentPlan) {
        GAMA.updateExperimentState(iExperimentPlan, GAMA.getExperimentState(iExperimentPlan));
    }

    public static interface InScope<T> {
        public T run(IScope var1);

        public static abstract class Void
        implements InScope<Object> {
            @Override
            public Object run(IScope iScope) {
                this.process(iScope);
                return null;
            }

            public abstract void process(IScope var1);
        }
    }
}

