/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.json;

import gama.core.metamodel.agent.SerialisedAgent;
import gama.core.runtime.IScope;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonAbstractObject;
import gama.core.util.file.json.JsonObjectMember;
import gama.core.util.file.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public class JsonGamlAgent
extends JsonAbstractObject {
    final String species;
    int index;

    public JsonGamlAgent(String string, int n, Json json) {
        super(json);
        this.species = string;
        this.index = n;
    }

    public JsonGamlAgent(String string, int n, JsonAbstractObject jsonAbstractObject, Json json) {
        this(string, n, json);
        for (JsonObjectMember jsonObjectMember : jsonAbstractObject) {
            this.add(jsonObjectMember.getName(), jsonObjectMember.getValue());
        }
    }

    @Override
    public SerialisedAgent toGamlValue(IScope iScope) {
        IMap<String, Object> iMap = this.toMap(iScope);
        return SerialisedAgent.of(this.index, this.species, (Map)iMap.get("attributes"));
    }

    @Override
    protected void writeMembers(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeMemberName("gaml_species");
        jsonWriter.writeMemberSeparator();
        jsonWriter.writeString(this.species);
        jsonWriter.writeObjectSeparator();
        jsonWriter.writeMemberName("index");
        jsonWriter.writeMemberSeparator();
        jsonWriter.writeNumber(String.valueOf(this.index));
        jsonWriter.writeObjectSeparator();
        super.writeMembers(jsonWriter);
    }

    @Override
    public boolean isGamlAgent() {
        return true;
    }

    @Override
    public JsonGamlAgent asGamlAgent() {
        return this;
    }
}

