/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.collect.Iterables;
import gama.gaml.compilation.GAML;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IVarDescriptionProvider;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IVarExpression;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.Facets;
import gama.gaml.types.IType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class StatementWithChildrenDescription
extends StatementDescription {
    protected Map<String, IVarExpression> temps;
    protected List<IDescription> children;

    public StatementWithChildrenDescription(String string, IDescription iDescription, Iterable<IDescription> iterable, boolean bl, EObject eObject, Facets facets2, Arguments arguments) {
        super(string, iDescription, bl, eObject, facets2, arguments);
        this.setIf(IDescription.Flag.Breakable, this.getMeta().isBreakable());
        this.setIf(IDescription.Flag.Continuable, this.getMeta().isContinuable());
        this.addChildren(iterable);
    }

    @Override
    public boolean visitChildren(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        if (this.children != null) {
            for (IDescription iDescription : this.children) {
                if (descriptionVisitor.process(iDescription)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean visitOwnChildrenRecursively(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        if (this.children != null) {
            for (IDescription iDescription : this.children) {
                if (descriptionVisitor.process(iDescription) && iDescription.visitOwnChildrenRecursively(descriptionVisitor)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean visitOwnChildren(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        if (this.children != null) {
            for (IDescription iDescription : this.children) {
                if (descriptionVisitor.process(iDescription)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterable<IDescription> getOwnChildren() {
        if (this.children != null) {
            return this.children;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.children != null) {
            this.children.clear();
            this.children = null;
        }
        if (this.temps != null) {
            this.temps.forEach((string, iVarExpression) -> iVarExpression.dispose());
        }
        this.temps = null;
    }

    @Override
    public boolean hasAttribute(String string) {
        return this.temps != null && this.temps.containsKey(string);
    }

    @Override
    public IVarDescriptionProvider getDescriptionDeclaringVar(String string) {
        IDescription iDescription = this.getEnclosingDescription();
        return this.hasAttribute(string) ? this : (iDescription == null ? null : iDescription.getDescriptionDeclaringVar(string));
    }

    @Override
    public IExpression getVarExpr(String string, boolean bl) {
        if (this.temps != null) {
            return this.temps.get(string);
        }
        return null;
    }

    public boolean hasTemps() {
        return this.getMeta().hasScope() && this.temps != null;
    }

    public IExpression addTemp(IDescription iDescription, String string, IType<?> iType) {
        Object object;
        boolean bl;
        String string2;
        IDescription iDescription2 = this.getEnclosingDescription();
        if (!this.getMeta().hasScope()) {
            IExpression iExpression;
            if (iDescription2 instanceof StatementWithChildrenDescription) {
                StatementWithChildrenDescription statementWithChildrenDescription = (StatementWithChildrenDescription)iDescription2;
                iExpression = statementWithChildrenDescription.addTemp(iDescription, string, iType);
            } else {
                iExpression = null;
            }
            return iExpression;
        }
        String string3 = this.getKeyword();
        String string4 = string2 = "let".equals(string3) || "loop".equals(string3) ? "name" : "returns";
        if (this.temps == null) {
            this.temps = new LinkedHashMap<String, IVarExpression>();
        }
        if (!(bl = "myself".equals(string)) && (object = this.getDescriptionDeclaringVar(string)) != null) {
            if (object instanceof SpeciesDescription) {
                iDescription.warning("This declaration of " + string + " shadows the declaration of an attribute of " + ((SpeciesDescription)object).getName(), "gaml.shadows.name.issue", string2, new String[0]);
            } else if (object instanceof ModelDescription) {
                iDescription.warning("This declaration of " + string + " shadows the declaration of a global attribute", "gaml.shadows.name.issue", string2, new String[0]);
            } else {
                iDescription.warning("This declaration of " + string + " shadows a previous declaration", "gaml.shadows.name.issue", string2, new String[0]);
            }
        }
        object = GAML.getExpressionFactory().createVar(string, iType, false, bl ? 6 : 2, this);
        this.temps.put(string, (IVarExpression)object);
        return object;
    }

    @Override
    public IDescription addChild(IDescription iDescription) {
        IDescription iDescription2 = super.addChild(iDescription);
        if (iDescription2 != null) {
            if (this.children == null) {
                this.children = new ArrayList<IDescription>();
            }
            this.children.add(iDescription);
        }
        return iDescription2;
    }

    public List<IDescription> getChildren() {
        if (this.children != null) {
            return this.children;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public StatementWithChildrenDescription copy(IDescription iDescription) {
        Iterable iterable = this.children == null ? null : Iterables.transform(this.children, iDescription2 -> iDescription2.copy(iDescription));
        StatementWithChildrenDescription statementWithChildrenDescription = new StatementWithChildrenDescription(this.getKeyword(), iDescription, iterable, false, this.element, this.getFacetsCopy(), this.passedArgs == null ? null : this.passedArgs.cleanCopy());
        statementWithChildrenDescription.originName = this.getOriginName();
        return statementWithChildrenDescription;
    }

    @Override
    public void replaceChildrenWith(Iterable<IDescription> iterable) {
        List<IDescription> list = Arrays.asList((IDescription[])Iterables.toArray(iterable, IDescription.class));
        if (this.children == null) {
            this.children = new ArrayList<IDescription>();
        } else {
            this.children.clear();
        }
        this.children.addAll(list);
    }

    public boolean isBreakable() {
        return this.isSet(IDescription.Flag.Breakable);
    }

    @Override
    public IVarExpression addNewTempIfNecessary(String string, IType iType) {
        if ("loop".equals(this.getKeyword()) && "name".equals(string)) {
            return (IVarExpression)this.addTemp(this, this.getLitteral(string), iType);
        }
        return super.addNewTempIfNecessary(string, iType);
    }

    public boolean isContinuable() {
        return this.isSet(IDescription.Flag.Continuable);
    }
}

