/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators.spatial;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.metamodel.topology.filter.In;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.matrix.GamaMatrix;
import gama.core.util.matrix.IMatrix;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Containers;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpatialStatistics {
    @GamlAnnotations.operator(value={"k_nearest_neighbors"}, content_type=-199, category={"Spatial operators", "Spatial statistical operators", "Statistical operators"}, concept={"geometry", "spatial_computation", "agent_location", "statistic"})
    @GamlAnnotations.doc(value="This operator allows user to find the attribute of an agent basing on its k-nearest agents", comment="In order to use this operator, users have to create a map which map the agents with one of their attributes (for example color or size,..). In the example below, 'map' is the map that I mention above, 'k' is the number of the nearest agents that we areconsidering", examples={@GamlAnnotations.example(value="self k_nearest_neighbors (map,k)", equals="this will return the attribute which has highest frequency in the k-nearest neighbors of our agent ", isExecutable=false)})
    public static Object KNN(IScope iScope, IAgent iAgent, IMap<IAgent, Object> iMap, int n) {
        class DistanceCalc
        implements Comparable<DistanceCalc> {
            public Object label;
            public Double dist;

            public DistanceCalc(IAgent iAgent, IAgent iAgent2, Object object, IScope iScope) {
                this.label = object;
                this.dist = iScope.getTopology().distanceBetween(iScope, iAgent, iAgent2);
            }

            @Override
            public int compareTo(DistanceCalc distanceCalc) {
                if (this.dist.equals(distanceCalc.dist)) {
                    return 0;
                }
                if (this.dist > distanceCalc.dist) {
                    return 1;
                }
                return -1;
            }
        }
        ArrayList<DistanceCalc> arrayList = new ArrayList<DistanceCalc>();
        for (IAgent object2 : iMap.getKeys()) {
            arrayList.add(new DistanceCalc(iAgent, object2, iMap.get(object2), iScope));
        }
        Collections.sort(arrayList);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n2 = 0;
        while (n2 < Math.min(n, arrayList.size())) {
            arrayList2.add(((DistanceCalc)arrayList.get((int)n2)).label);
            ++n2;
        }
        n2 = 0;
        Object var7_9 = null;
        int n3 = 0;
        while (n3 < n) {
            int n4 = Collections.frequency(arrayList2, arrayList2.get(n3));
            if (n4 > n2) {
                n2 = n4;
                var7_9 = arrayList2.get(n3);
            }
            ++n3;
        }
        return var7_9;
    }

    @GamlAnnotations.operator(value={"simple_clustering_by_distance", "simple_clustering_by_envelope_distance"}, content_type=-199, category={"Spatial operators", "Spatial statistical operators", "Statistical operators"}, concept={"geometry", "spatial_computation", "agent_location", "statistic"})
    @GamlAnnotations.doc(value="A list of agent groups clustered by distance considering a distance min between two groups.", examples={@GamlAnnotations.example(value="[ag1, ag2, ag3, ag4, ag5] simpleClusteringByDistance 20.0", equals="for example, can return [[ag1, ag3], [ag2], [ag4, ag5]]", isExecutable=false)}, see={"hierarchical_clustering"})
    public static IList<IList<IAgent>> simpleClusteringByDistance(IScope iScope, IContainer<?, IAgent> iContainer, Double d) {
        IList<IList<IAgent>> iList = GamaListFactory.create(Types.LIST.of(iContainer.getGamlType().getContentType()));
        IAgentFilter iAgentFilter = In.list(iScope, iContainer);
        if (iAgentFilter == null) {
            return iList;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (Collector.AsOrderedSet<IAgent> asOrderedSet = Collector.getOrderedSet();){
            for (IAgent iAgent : iContainer.iterable(iScope)) {
                if (asOrderedSet.contains(iAgent)) continue;
                iList.add(SpatialStatistics.simpleClusteringByDistanceRec(iScope, iAgentFilter, d, asOrderedSet, iAgent));
            }
            return iList;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static IList<IAgent> simpleClusteringByDistanceRec(IScope iScope, IAgentFilter iAgentFilter, Double d, Collection<IAgent> collection, IAgent iAgent) {
        IList<IAgent> iList = GamaListFactory.create(Types.AGENT);
        ArrayList<IAgent> arrayList = new ArrayList<IAgent>(iScope.getTopology().getNeighborsOf(iScope, iAgent, d, iAgentFilter));
        collection.add(iAgent);
        iList.add(iAgent);
        for (IAgent iAgent2 : arrayList) {
            if (collection.contains(iAgent2)) continue;
            iList.addAll(SpatialStatistics.simpleClusteringByDistanceRec(iScope, iAgentFilter, d, collection, iAgent2));
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"hierarchical_clustering"}, category={"Spatial operators", "Spatial statistical operators", "Statistical operators"}, concept={"geometry", "spatial_computation", "agent_location", "statistic"})
    @GamlAnnotations.doc(value="A tree (list of list) contained groups of agents clustered by distance considering a distance min between two groups.", comment="use of hierarchical clustering with Minimum for linkage criterion between two groups of agents.", examples={@GamlAnnotations.example(value="[ag1, ag2, ag3, ag4, ag5] hierarchical_clustering 20.0", equals="for example, can return [[[ag1],[ag3]], [ag2], [[[ag4],[ag5]],[ag6]]", isExecutable=false)}, see={"simple_clustering_by_distance"})
    public static IList hierarchicalClusteringe(IScope iScope, IContainer<?, IAgent> iContainer, Double d) {
        ArrayList[] arrayListArray;
        IList iList;
        Object object;
        List<Object> list;
        int n = iContainer.length(iScope);
        IList<Object> iList2 = GamaListFactory.create();
        if (n == 0) {
            return iList2;
        }
        double d2 = Double.MAX_VALUE;
        List<E>[] listArray = null;
        HashMap<ArrayList[], Double> hashMap = new HashMap<ArrayList[], Double>();
        for (IAgent iAgent : iContainer.iterable(iScope)) {
            list = GamaListFactory.create(Types.AGENT);
            list.add(iAgent);
            iList2.add(list);
        }
        if (n == 1) {
            return iList2;
        }
        int n2 = 0;
        while (n2 < n - 1) {
            object = (IList)iList2.get(n2);
            int n3 = n2 + 1;
            while (n3 < n) {
                iList = (IList)iList2.get(n3);
                ArrayList[] object2 = new ArrayList[]{object, iList};
                Iterator iterator = (IAgent)object.get(0);
                arrayListArray = (ArrayList[])iList.get(0);
                Double d3 = iScope.getTopology().distanceBetween(iScope, (IShape)((Object)iterator), (IShape)arrayListArray);
                if (d3 < d) {
                    hashMap.put(object2, d3);
                    if (d3 < d2) {
                        d2 = d3;
                        listArray = object2;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        while (d2 <= d) {
            IList iList3 = GamaListFactory.create();
            iList3.add(listArray[0]);
            iList3.add(listArray[1]);
            object = (List)iList3.get(0);
            list = (List)iList3.get(1);
            hashMap.remove(listArray);
            iList3 = null;
            iList2.remove(list);
            iList2.remove(object);
            iList = GamaListFactory.create(Types.LIST.of(Types.AGENT));
            iList.add(list);
            iList.add(object);
            for (List list2 : iList2) {
                double d4;
                arrayListArray = new ArrayList[]{list2, object};
                double d5 = Double.MAX_VALUE;
                if (hashMap.containsKey(arrayListArray)) {
                    d5 = (Double)hashMap.remove(arrayListArray);
                }
                arrayListArray[1] = list;
                double d6 = Double.MAX_VALUE;
                if (hashMap.containsKey(arrayListArray)) {
                    d6 = (Double)hashMap.remove(arrayListArray);
                }
                if (!((d4 = Math.min(d5, d6)) <= d)) continue;
                arrayListArray[1] = iList;
                hashMap.put(arrayListArray, d4);
            }
            iList2.add(iList);
            d2 = Double.MAX_VALUE;
            listArray = null;
            for (Map.Entry entry : hashMap.entrySet()) {
                double d7 = (Double)entry.getValue();
                if (!(d7 < d2)) continue;
                listArray = (List[])entry.getKey();
                d2 = d7;
            }
        }
        return iList2;
    }

    @GamlAnnotations.operator(value={"IDW", "inverse_distance_weighting"}, category={"Spatial operators"}, concept={"geometry", "spatial_computation", "statistic"})
    @GamlAnnotations.doc(value="Inverse Distance Weighting (IDW) is a type of deterministic method for multivariate interpolation with a known scattered set of points. The assigned values to each geometry are calculated with a weighted average of the values available at the known points. See: http://en.wikipedia.org/wiki/Inverse_distance_weighting Usage: IDW (list of geometries, map of points (key: point, value: value), power parameter)", examples={@GamlAnnotations.example(value="IDW([ag1, ag2, ag3, ag4, ag5],[{10,10}::25.0, {10,80}::10.0, {100,10}::15.0], 2)", equals="for example, can return [ag1::12.0, ag2::23.0,ag3::12.0,ag4::14.0,ag5::17.0]", isExecutable=false)})
    @GamlAnnotations.test(value="map<point, float> mapLocationPoints <- [{0,0}::10.0,{0,10}::-3.0];\r\n\t\tlist<point> queryPoint <- [{0,5}];\r\n\t\tfloat((IDW(list(geometry(queryPoint)),mapLocationPoints,1)).pairs[0].value) with_precision 1 = 3.5")
    public static IMap<IShape, Double> primIDW(IScope iScope, IContainer<?, ? extends IShape> iContainer, IMap iMap, int n) {
        IMap iMap2 = GamaMapFactory.create(Types.GEOMETRY, Types.FLOAT);
        if (iMap == null || iMap.isEmpty()) {
            return null;
        }
        if (iContainer == null || iContainer.isEmpty(iScope)) {
            return iMap2;
        }
        for (IShape iShape : iContainer.iterable(iScope)) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            int n2 = 0;
            for (Object k : iMap.keySet()) {
                GamaPoint gamaPoint = Cast.asPoint(iScope, k);
                double d4 = iScope.getTopology().distanceBetween(iScope, iShape, (IShape)gamaPoint);
                if (d4 == 0.0) {
                    ++n2;
                    d3 += Cast.asFloat(iScope, iMap.get(gamaPoint)).doubleValue();
                }
                if (n2 != 0) continue;
                double d5 = 1.0 / Math.pow(d4, n);
                d2 += d5;
                d += d5 * Cast.asFloat(iScope, iMap.get(gamaPoint));
            }
            if (n2 > 0) {
                iMap2.put(iShape, d3 / (double)n2);
                continue;
            }
            iMap2.put(iShape, d / d2);
        }
        return iMap2;
    }

    @GamlAnnotations.operator(value={"moran"}, category={"Spatial operators", "Statistical operators"}, concept={"geometry", "spatial_computation"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="return the Moran Index of the given list of interest points (list of floats) and the weight matrix (matrix of float)", examples={@GamlAnnotations.example(value="moran([1.0, 0.5, 2.0], weight_matrix)", equals="the Moran index is computed", test=false, isExecutable=false)})})
    public static double moranIndex(IScope iScope, IList<Double> iList, IMatrix<Double> iMatrix) {
        GamaMatrix gamaMatrix = (GamaMatrix)iMatrix;
        if (gamaMatrix == null || gamaMatrix.numCols != gamaMatrix.numRows) {
            throw GamaRuntimeException.error("A squared weight matrix should be given for the moran index computation", iScope);
        }
        int n = iList.size();
        if (n != gamaMatrix.numRows) {
            throw GamaRuntimeException.error("The lengths of the value list and of the weight matrix do not match", iScope);
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Double d4 = (Double)Containers.opMean(iScope, iList);
        int n2 = 0;
        while (n2 < n) {
            double d5 = (Double)iList.get(n2);
            double d6 = d5 - d4;
            d3 += Math.pow(d6, 2.0);
            int n3 = 0;
            while (n3 < n) {
                Double d7 = (Double)gamaMatrix.get(iScope, n2, n3);
                d2 += d7.doubleValue();
                d += d7 * d6 * ((Double)iList.get(n3) - d4);
                ++n3;
            }
            ++n2;
        }
        d /= d3;
        return d *= (double)n / d2;
    }
}

