/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.draw;

import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.geometry.ICoordinates;
import gama.core.common.geometry.Scaling3D;
import gama.core.common.interfaces.IDrawDelegate;
import gama.core.common.interfaces.IImageProvider;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.IGamaFile;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.draw.DrawingAttributes;
import gama.gaml.statements.draw.DrawingData;
import gama.gaml.statements.draw.ShapeDrawingAttributes;
import gama.gaml.types.GamaFileType;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.geom.Rectangle2D;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class ShapeDrawer
implements IDrawDelegate {
    @Override
    public Rectangle2D executeOn(IScope.IGraphicsScope iGraphicsScope, DrawingData drawingData, IExpression ... iExpressionArray) throws GamaRuntimeException {
        GamaPoint gamaPoint;
        Object object;
        GamaPoint gamaPoint2;
        IShape iShape = Cast.asGeometry(iGraphicsScope, iExpressionArray[0].value(iGraphicsScope), false);
        if (iShape == null) {
            return null;
        }
        DrawingAttributes drawingAttributes = this.computeAttributes(iGraphicsScope, drawingData, iShape);
        Object object2 = iShape.getInnerGeometry();
        if (object2 == null) {
            return null;
        }
        ICoordinates iCoordinates = GeometryUtils.getContourCoordinates(object2);
        iCoordinates.ensureClockwiseness();
        if (iGraphicsScope.getGraphics().is2D()) {
            gamaPoint2 = iCoordinates.getCenter();
            object = drawingAttributes.getRotation();
            gamaPoint = drawingAttributes.getLocation();
            if (object != null || gamaPoint != null) {
                object2 = object2.buffer(0.0, 8, 2);
            }
            GeometryUtils.rotate(object2, gamaPoint2, (AxisAngle)object);
            if (gamaPoint != null) {
                if (object2.getNumPoints() == 1) {
                    object2 = GeometryUtils.GEOMETRY_FACTORY.createPoint(gamaPoint);
                } else {
                    GeometryUtils.translate(object2, gamaPoint2, gamaPoint);
                }
            }
        }
        if (iExpressionArray.length > 1 && (gamaPoint2 = this.addArrows(iGraphicsScope, (Geometry)object2, iExpressionArray[1], iExpressionArray[2], !drawingAttributes.isEmpty())) != object2) {
            object2 = gamaPoint2;
            drawingAttributes.setType(IShape.Type.NULL);
        }
        if ((gamaPoint2 = this.addToroidalParts(iGraphicsScope, (Geometry)object2)) != object2) {
            object2 = gamaPoint2;
            drawingAttributes.setType(IShape.Type.NULL);
        }
        if (GamaPreferences.Displays.DISPLAY_ONLY_VISIBLE.getValue().booleanValue() && !iGraphicsScope.getExperiment().isHeadless()) {
            object = iShape.getEnvelope();
            try {
                gamaPoint = iGraphicsScope.getGraphics().getVisibleRegion();
                if (gamaPoint != null && !gamaPoint.intersects((Envelope)object)) {
                    return null;
                }
            }
            finally {
                ((Envelope3D)object).dispose();
            }
        }
        this.addTextures(iGraphicsScope, drawingAttributes);
        return iGraphicsScope.getGraphics().drawShape((Geometry)object2, drawingAttributes);
    }

    DrawingAttributes computeAttributes(IScope iScope, DrawingData drawingData, IShape iShape) {
        Double d = drawingData.depth.get();
        if (d == null) {
            d = iShape.getDepth();
        }
        return new ShapeDrawingAttributes(Scaling3D.of(drawingData.size.get()), d, drawingData.rotation.get(), drawingData.getLocation(), drawingData.empty.get(), drawingData.color.get(), drawingData.border.get(), drawingData.texture.get(), iScope.getAgent(), iShape.getGeometricalType(), drawingData.lineWidth.get(), drawingData.lighting.get());
    }

    private void addTextures(IScope iScope, DrawingAttributes drawingAttributes) {
        if (drawingAttributes.getTextures() == null) {
            return;
        }
        drawingAttributes.getTextures().replaceAll(object -> {
            IImageProvider iImageProvider;
            block3: {
                IImageProvider iImageProvider2;
                block5: {
                    block4: {
                        block2: {
                            iImageProvider = null;
                            if (!(object instanceof IImageProvider)) break block2;
                            iImageProvider = (IImageProvider)object;
                            break block3;
                        }
                        if (!(object instanceof String)) break block3;
                        IGamaFile iGamaFile = GamaFileType.createFile(iScope, (String)object, false, null);
                        if (!(iGamaFile instanceof IImageProvider)) break block4;
                        iImageProvider2 = (IImageProvider)((Object)iGamaFile);
                        if (iGamaFile.exists(iScope).booleanValue()) break block5;
                    }
                    throw new GamaRuntimeException.GamaRuntimeFileException(iScope, "Texture file not found: " + String.valueOf(object));
                }
                iImageProvider = iImageProvider2;
            }
            return iImageProvider;
        });
    }

    private Geometry addToroidalParts(IScope iScope, Geometry geometry) {
        return geometry;
    }

    private Geometry addArrows(IScope iScope, Geometry geometry, IExpression iExpression, IExpression iExpression2, Boolean bl) {
        double d;
        if (geometry == null) {
            return geometry;
        }
        GamaPoint[] gamaPointArray = GeometryUtils.getPointsOf(geometry);
        int n = gamaPointArray.length;
        if (n < 2) {
            return geometry;
        }
        Geometry geometry2 = null;
        Geometry geometry3 = null;
        if (iExpression2 != null && (d = Cast.asFloat(iScope, iExpression2.value(iScope)).doubleValue()) > 0.0) {
            geometry2 = GamaGeometryType.buildArrow(gamaPointArray[n - 2], gamaPointArray[n - 1], d, d + d / 3.0, bl).getInnerGeometry();
        }
        if (iExpression != null && (d = Cast.asFloat(iScope, iExpression.value(iScope)).doubleValue()) > 0.0) {
            geometry3 = GamaGeometryType.buildArrow(gamaPointArray[1], gamaPointArray[0], d, d + d / 3.0, bl).getInnerGeometry();
        }
        if (geometry2 == null) {
            if (geometry3 == null) {
                return geometry;
            }
            return GeometryUtils.GEOMETRY_FACTORY.createCollection(geometry, geometry3);
        }
        if (geometry3 == null) {
            return GeometryUtils.GEOMETRY_FACTORY.createCollection(geometry, geometry2);
        }
        return geometry;
    }

    @Override
    public IType<?> typeDrawn() {
        return Types.GEOMETRY;
    }
}

