/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.lang.runtime.SwitchBootstraps;

@GamlAnnotations.type(name="int", id=1, wraps={Integer.class, int.class, Long.class}, kind=101, concept={"type"}, doc={@GamlAnnotations.doc(value="Type of integer numbers")})
public class GamaIntegerType
extends GamaType<Integer> {
    @Override
    @GamlAnnotations.doc(value="Returns the parameter casted to an int value. If it is an integer, returns it. A float, returns its integer value. A color, its rgb value. An agent, its index. A string, attempts to parse it (with a radix of 16 if it begins with '#'). A bool, return 1 if true. A font, return its size.  Otherwise return 0")
    public Integer cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return GamaIntegerType.staticCast(iScope, object, object2, bl);
    }

    public static Integer staticCast(IScope iScope, Object object, Object object2, boolean bl) {
        Object object3 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Number.class, String.class, Boolean.class, IValue.class}, (Object)object3, n)) {
            case -1 -> 0;
            case 0 -> {
                Integer var6_6;
                yield var6_6 = (Integer)object3;
            }
            case 1 -> {
                Number var7_7 = (Number)object3;
                yield var7_7.intValue();
            }
            case 2 -> {
                String var8_8 = (String)object3;
                yield GamaIntegerType.castFromString(var8_8, object2);
            }
            case 3 -> {
                Boolean var9_9 = (Boolean)object3;
                yield var9_9 != false ? 1 : 0;
            }
            case 4 -> {
                IValue var10_10 = (IValue)object3;
                yield var10_10.intValue(iScope);
            }
            default -> 0;
        };
    }

    private static Integer castFromString(String string, Object object) {
        String string2 = string.replaceAll("\\p{Zs}", "");
        try {
            if (string2.startsWith("#")) {
                return Integer.parseInt(string2.substring(1), 16);
            }
            int n = 10;
            if (object instanceof Integer) {
                n = (Integer)object;
            }
            return Integer.parseInt(string2, n);
        }
        catch (NumberFormatException numberFormatException) {
            Double d = 0.0;
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException2) {
                return 0;
            }
            return d.intValue();
        }
    }

    @Override
    public Integer getDefault() {
        return 0;
    }

    @Override
    public boolean isTranslatableInto(IType<?> iType) {
        return iType.isNumber() || iType == Types.NO_TYPE;
    }

    @Override
    public IType<?> coerce(IType<?> iType, IDescription iDescription) {
        if (iType == this) {
            return null;
        }
        return this;
    }

    @Override
    public IType findCommonSupertypeWith(IType<?> iType) {
        return iType == this ? this : (iType.id() == 2 ? iType : Types.NO_TYPE);
    }

    @Override
    public boolean canCastToConst() {
        return true;
    }

    @Override
    public boolean isNumber() {
        return true;
    }
}

