/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.experiment;

import gama.core.kernel.batch.IExploration;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.IExperimentController;
import gama.core.kernel.experiment.IExperimentDisplayable;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.model.IModel;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.outputs.IOutputManager;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.gaml.compilation.GAML;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.ConstantExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.species.ISpecies;
import gama.gaml.types.Types;
import java.util.List;
import java.util.Map;

public interface IExperimentPlan
extends ISpecies {
    public static final String TEST_CATEGORY_NAME = "Configuration of tests";
    public static final String EXPLORABLE_CATEGORY_NAME = "Parameters to explore";
    public static final String SYSTEM_CATEGORY_PREFIX = "Random number generation";

    public IModel getModel();

    public void setModel(IModel var1);

    public IOutputManager getOriginalSimulationOutputs();

    public void refreshAllOutputs();

    public void pauseAllOutputs();

    public void resumeAllOutputs();

    public void closeAllOutputs();

    public IOutputManager getExperimentOutputs();

    public boolean hasParameter(String var1);

    public ExperimentAgent getAgent();

    public IScope getExperimentScope();

    public void open();

    public void reload();

    public SimulationAgent getCurrentSimulation();

    public Map<String, IParameter> getParameters();

    public IExploration getExplorationAlgorithm();

    public boolean isBatch();

    public boolean isMemorize();

    public Map<String, IParameter.Batch> getExplorableParameters();

    public IExperimentController getController();

    public void setController(IExperimentController var1);

    public boolean isHeadless();

    public void setHeadless(boolean var1);

    public String getExperimentType();

    public boolean keepsSeed();

    public boolean keepsSimulations();

    public boolean hasParametersOrUserCommands();

    public void recomputeAndRefreshAllOutputs();

    public Iterable<IOutputManager> getActiveOutputManagers();

    public boolean isAutorun();

    public boolean isTest();

    @Override
    public ExperimentDescription getDescription();

    public boolean shouldBeBenchmarked();

    public List<IExperimentDisplayable> getDisplayables();

    public void setConcurrency(IExpression var1);

    public IExpression shouldRecord();

    public IExpression getStopCondition();

    public void setStopCondition(IExpression var1);

    default public void setStopCondition(String string) {
        ConstantExpression constantExpression = IExpressionFactory.FALSE_EXPR;
        if (string != null && !string.isBlank()) {
            this.setStopCondition(GAML.getExpressionFactory().createExpr(string, (IDescription)this.getModel().getDescription()));
        }
        if (constantExpression.getGamlType() != Types.BOOL) {
            throw GamaRuntimeException.error("The until condition of the experiment should be a boolean", GAMA.getRuntimeScope());
        }
    }

    public void setParameterValues(IList var1);

    public boolean isReloading();
}

