/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.properties;

import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.properties.ICameraDefinition;

public class GenericCameraDefinition
implements ICameraDefinition {
    final GamaPoint currentLocation;
    final GamaPoint currentTarget;
    final GamaPoint initialLocation;
    final GamaPoint initialTarget;
    Integer lens = 45;
    Boolean isLocked = false;
    final String name;

    public GenericCameraDefinition(String string, GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        this.initialLocation = new GamaPoint(gamaPoint);
        this.currentLocation = new GamaPoint(gamaPoint);
        this.initialTarget = new GamaPoint(gamaPoint2);
        this.currentTarget = new GamaPoint(gamaPoint2);
        this.name = string;
    }

    public GenericCameraDefinition(String string, GamaPoint gamaPoint, double d, double d2, double d3) {
        GamaPoint gamaPoint2 = this.computeLocation(string, gamaPoint, d, d2, d3);
        this.initialLocation = new GamaPoint(gamaPoint2);
        this.currentLocation = new GamaPoint(gamaPoint2);
        this.initialTarget = new GamaPoint(gamaPoint);
        this.currentTarget = new GamaPoint(gamaPoint);
        this.name = string;
    }

    @Override
    public GamaPoint getLocation() {
        return this.currentLocation;
    }

    @Override
    public GamaPoint getTarget() {
        return this.currentTarget;
    }

    @Override
    public Integer getLens() {
        return this.lens;
    }

    @Override
    public Boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public Boolean isDynamic() {
        return false;
    }

    @Override
    public void setLocked(Boolean bl) {
        this.isLocked = bl;
    }

    @Override
    public boolean setLocation(GamaPoint gamaPoint) {
        if (this.currentLocation.equals(gamaPoint)) {
            return false;
        }
        this.currentLocation.setLocation(gamaPoint);
        return true;
    }

    @Override
    public boolean setTarget(GamaPoint gamaPoint) {
        if (this.currentTarget.equals(gamaPoint)) {
            return false;
        }
        this.currentTarget.setLocation(gamaPoint);
        return true;
    }

    @Override
    public void setLens(Integer n) {
        this.lens = n;
    }

    @Override
    public void reset() {
        this.currentLocation.setLocation(this.initialLocation);
        this.currentTarget.setLocation(this.initialTarget);
        this.isLocked = false;
    }

    @Override
    public boolean setDistance(Double d) {
        if (d.equals(this.currentLocation.distance3D(this.currentTarget))) {
            return false;
        }
        GamaPoint gamaPoint = this.currentLocation.minus(this.currentTarget).normalized().times(d);
        this.currentLocation.setLocation(this.currentTarget.plus(gamaPoint));
        return true;
    }

    @Override
    public Double getDistance() {
        return this.currentLocation.distance3D(this.currentTarget);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

