/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime;

import gama.core.common.interfaces.IConsoleListener;
import gama.core.common.interfaces.IDisplayCreator;
import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IGui;
import gama.core.kernel.experiment.IParameter;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.display.NullDisplaySurface;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.statements.test.CompoundSummary;
import java.util.List;
import java.util.Map;

public class NullGuiHandler
implements IGui {
    protected IConsoleListener console = null;
    private IHeadlessLogger logger = DEBUG::LOG;

    static {
        GAMA.setHeadlessGui(new NullGuiHandler());
    }

    @Override
    public Map<String, Object> openUserInputDialog(IScope iScope, String string, List<IParameter> list, GamaFont gamaFont, GamaColor gamaColor, Boolean bl) {
        IMap iMap = GamaMapFactory.create();
        list.forEach(iParameter -> iMap.put(iParameter.getName(), iParameter.getInitialValue(iScope)));
        return iMap;
    }

    @Override
    public IMap<String, IMap<String, Object>> openWizard(IScope iScope, String string, ActionDescription actionDescription, IList<IMap<String, Object>> iList) {
        IMap iMap = GamaMapFactory.create();
        for (IMap iMap2 : iList) {
            IMap iMap3 = GamaMapFactory.create();
            String string2 = (String)iMap2.get("title");
            iMap.put(string2, iMap3);
            IList iList2 = (IList)iMap2.get("parameters");
            if (iList2 == null) continue;
            iList2.forEach(iParameter -> iMap3.put(iParameter.getName(), iParameter.getInitialValue(iScope)));
        }
        return iMap;
    }

    @Override
    public void openMessageDialog(IScope iScope, String string) {
        this.logger.log("Message: " + string);
    }

    @Override
    public void openErrorDialog(IScope iScope, String string) {
        this.logger.log("Error: " + string);
    }

    @Override
    public void runtimeError(IScope iScope, GamaRuntimeException gamaRuntimeException) {
        this.logger.log("Runtime error: " + gamaRuntimeException.getMessage());
    }

    @Override
    public IDisplaySurface createDisplaySurfaceFor(LayeredDisplayOutput layeredDisplayOutput, Object ... objectArray) {
        IDisplaySurface iDisplaySurface = null;
        IDisplayCreator iDisplayCreator = (IDisplayCreator)DISPLAYS.get("image");
        if (iDisplayCreator == null) {
            return new NullDisplaySurface();
        }
        iDisplaySurface = iDisplayCreator.create(layeredDisplayOutput);
        iDisplaySurface.outputReloaded();
        return iDisplaySurface;
    }

    @Override
    public IDisplayCreator.DisplayDescription getDisplayDescriptionFor(String string) {
        return new IDisplayCreator.DisplayDescription(null, null, "display", "gama.core");
    }

    public void setHeadlessLogger(IHeadlessLogger iHeadlessLogger) {
        this.logger = iHeadlessLogger;
    }

    @Override
    public IConsoleListener getConsole() {
        if (this.console == null) {
            this.console = (string, iTopLevelAgent, gamaColor) -> this.logger.log(string);
        }
        return this.console;
    }

    @Override
    public void run(String string, Runnable runnable, boolean bl) {
        if (runnable != null) {
            if (bl) {
                new Thread(runnable).start();
            } else {
                runnable.run();
            }
        }
    }

    @Override
    public void exit() {
        System.exit(0);
    }

    @Override
    public void displayTestsResults(IScope iScope, CompoundSummary<?, ?> compoundSummary) {
        this.logger.log(compoundSummary.toString());
    }

    public static interface IHeadlessLogger {
        public void log(String var1);
    }
}

