/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.BiConsumerWithPruning;
import gama.core.util.ConsumerWithPruning;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.GamaPair;
import gama.core.util.GamaPairList;
import gama.core.util.IAddressableContainer;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IModifiableContainer;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonObject;
import gama.core.util.file.json.JsonValue;
import gama.core.util.matrix.GamaObjectMatrix;
import gama.core.util.matrix.IMatrix;
import gama.dev.FLAGS;
import gama.gaml.interfaces.IJsonable;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="keys", type=5, of=-399, doc={@GamlAnnotations.doc(value="Returns the list of keys of this map (in their order of insertion)")}), @GamlAnnotations.variable(name="values", type=5, of=-299, doc={@GamlAnnotations.doc(value="Returns the list of values of this map (in their order of insertion)")}), @GamlAnnotations.variable(name="pairs", type=5, of=-449, doc={@GamlAnnotations.doc(value="Returns the list of pairs (key, value) that compose this map")})})
public interface IMap<K, V>
extends Map<K, V>,
IModifiableContainer<K, V, K, V>,
IAddressableContainer<K, V, K, V>,
IJsonable {
    public static final String KEYS = "keys";
    public static final String VALUES = "values";
    public static final String PAIRS = "pairs";

    @Override
    default public String stringValue(IScope iScope) {
        return this.serializeToGaml(false);
    }

    @Override
    default public void addValue(IScope iScope, V v) {
        if (v instanceof GamaPair) {
            this.setValueAtIndex(iScope, ((GamaPair)v).key, (V)((GamaPair)v).value);
        } else {
            this.setValueAtIndex(iScope, (Object)v, v);
        }
    }

    @Override
    default public void addValueAtIndex(IScope iScope, Object object, V v) {
        this.setValueAtIndex(iScope, object, v);
    }

    @Override
    default public void addValues(IScope iScope, Object object, IContainer iContainer) {
        if (object != null) {
            Iterable iterable = iContainer.iterable(iScope);
            this.setValueAtIndex(iScope, object, (V)Iterables.getLast(iterable));
        } else {
            for (Object ValueType : iContainer.iterable(iScope)) {
                this.addValue(iScope, (V)ValueType);
            }
        }
    }

    @Override
    default public void removeIndex(IScope iScope, Object object) {
        this.remove(object);
    }

    @Override
    default public boolean containsKey(IScope iScope, Object object) throws GamaRuntimeException {
        return this.containsKey(object);
    }

    @Override
    default public int length(IScope iScope) {
        return this.size();
    }

    @Override
    default public boolean isEmpty(IScope iScope) {
        return this.length(iScope) == 0;
    }

    @Override
    default public V anyValue(IScope iScope) {
        int n = this.length(iScope);
        if (n == 0) {
            return null;
        }
        Object k = iScope.getRandom().oneOf(this.keySet());
        return this.get(k);
    }

    @Override
    default public V firstValue(IScope iScope) throws GamaRuntimeException {
        if (this.length(iScope) == 0) {
            return null;
        }
        return (V)Iterators.get(this.values().iterator(), (int)0);
    }

    @Override
    default public V lastValue(IScope iScope) throws GamaRuntimeException {
        if (this.length(iScope) == 0) {
            return null;
        }
        return (V)Iterators.getLast(this.values().iterator());
    }

    default public V valueAt(int n) {
        if (this.size() == 0) {
            return null;
        }
        return (V)Iterators.get(this.values().iterator(), (int)n);
    }

    @Override
    default public void removeValues(IScope iScope, IContainer<?, ?> iContainer) {
        for (Object obj : iContainer.iterable(iScope)) {
            this.removeValue(iScope, obj);
        }
    }

    @Override
    default public void removeIndexes(IScope iScope, IContainer<?, ?> iContainer) {
        for (Object obj : iContainer.iterable(iScope)) {
            this.remove(obj);
        }
    }

    default public V buildValue(IScope iScope, Object object) {
        if (!FLAGS.CAST_CONTAINER_CONTENTS || object instanceof GamaPair && !this.getGamlType().getContentType().isTranslatableInto(Types.PAIR)) {
            return (V)object;
        }
        return (V)this.getGamlType().getContentType().cast(iScope, object, null, false);
    }

    default public K buildIndex(IScope iScope, Object object) {
        return (K)(FLAGS.CAST_CONTAINER_CONTENTS ? this.getGamlType().getKeyType().cast(iScope, object, null, false) : object);
    }

    @Override
    default public Iterable<V> iterable(IScope iScope) {
        return this.values();
    }

    @Override
    default public V getFromIndicesList(IScope iScope, IList<K> iList) throws GamaRuntimeException {
        if (iList == null || iList.isEmpty()) {
            return null;
        }
        return this.get(iScope, (K)iList.get(0));
    }

    @Override
    default public boolean contains(IScope iScope, Object object) {
        return this.containsValue(object);
    }

    @Override
    default public IList<V> listValue(IScope iScope, IType iType, boolean bl) {
        IType<?> iType2 = this.getGamlType().getContentType();
        if (GamaType.requiresCasting(iType, iType2)) {
            return GamaListFactory.create(iScope, iType, this.values());
        }
        if (!bl) {
            return GamaListFactory.wrap(iType, this.values());
        }
        return GamaListFactory.createWithoutCasting(iType, this.values());
    }

    @Override
    default public IMatrix matrixValue(IScope iScope, IType iType, boolean bl) throws GamaRuntimeException {
        GamaObjectMatrix gamaObjectMatrix = new GamaObjectMatrix(2, this.size(), iType);
        int n = 0;
        for (Map.Entry entry : this.entrySet()) {
            gamaObjectMatrix.set(iScope, 0, n, GamaType.toType(iScope, entry.getKey(), iType, false));
            gamaObjectMatrix.set(iScope, 1, n, GamaType.toType(iScope, entry.getValue(), iType, false));
            ++n;
        }
        return gamaObjectMatrix;
    }

    @Override
    default public IMatrix matrixValue(IScope iScope, IType iType, GamaPoint gamaPoint, boolean bl) throws GamaRuntimeException {
        return this.matrixValue(iScope, iType, bl);
    }

    @Override
    default public String serializeToGaml(boolean bl) {
        return "map(" + this.getPairs().serializeToGaml(bl) + ")";
    }

    @Override
    default public IMap mapValue(IScope iScope, IType iType, IType iType2, boolean bl) {
        IType<?> iType3 = this.getGamlType().getKeyType();
        IType<?> iType4 = this.getGamlType().getContentType();
        boolean bl2 = GamaType.requiresCasting(iType, iType3);
        boolean bl3 = GamaType.requiresCasting(iType2, iType4);
        if (bl2 || bl3) {
            IMap iMap = GamaMapFactory.create(iType, iType2, this.size());
            for (Map.Entry entry : this.entrySet()) {
                iMap.put(bl2 ? iMap.buildIndex(iScope, entry.getKey()) : entry.getKey(), bl3 ? iMap.buildValue(iScope, entry.getValue()) : entry.getValue());
            }
            return iMap;
        }
        if (bl) {
            return this.copy(iScope);
        }
        if (!iType.equals(iType3) || !iType2.equals(iType4)) {
            return GamaMapFactory.wrap(iType, iType2, this);
        }
        return this;
    }

    @Override
    default public IMap<K, V> copy(IScope iScope) {
        return GamaMapFactory.createWithoutCasting(this.getGamlType().getKeyType(), this.getGamlType().getContentType(), this, this.isOrdered());
    }

    @Override
    default public void setValueAtIndex(IScope iScope, Object object, V v) {
        K k = this.buildIndex(iScope, object);
        V v2 = this.buildValue(iScope, v);
        this.put(k, v2);
    }

    @GamlAnnotations.operator(value={"reverse"}, can_be_const=true, type=10, content_type=-399, index_type=-299, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="Specialization of the reverse operator for maps. Reverses keys and values", comment="", examples={@GamlAnnotations.example(value="map<int,int> m <- [1::111,2::222, 3::333, 4::444];"), @GamlAnnotations.example(value="reverse(m)", equals="map([111::1,222::2,333::3,444::4])")})
    @GamlAnnotations.test(value="map<int,int> m2 <- [1::111,2::222, 3::333, 4::444]; reverse(m2) = map([111::1,222::2,333::3,444::4])")
    default public IMap reverse(IScope iScope) {
        IMap iMap = GamaMapFactory.create(this.getGamlType().getContentType(), this.getGamlType().getKeyType());
        for (Map.Entry entry : this.entrySet()) {
            iMap.put(entry.getValue(), entry.getKey());
        }
        return iMap;
    }

    @Override
    default public void removeAllOccurrencesOfValue(IScope iScope, Object object) {
        this.values().removeIf(object2 -> Objects.equal((Object)object, (Object)object2));
    }

    @Override
    default public void removeValue(IScope iScope, Object object) {
        Collection collection = this.values();
        for (Object v : collection) {
            if (!Objects.equal(v, (Object)object)) continue;
            collection.remove(v);
            return;
        }
    }

    @GamlAnnotations.getter(value="keys")
    default public IList<K> getKeys() {
        return GamaListFactory.createWithoutCasting(this.getGamlType().getKeyType(), this.keySet());
    }

    @GamlAnnotations.getter(value="values")
    default public IList<V> getValues() {
        return GamaListFactory.wrap(this.getGamlType().getContentType(), this.values());
    }

    @Override
    default public V get(IScope iScope, K k) throws GamaRuntimeException {
        return this.get(k);
    }

    @Override
    default public void setAllValues(IScope iScope, V v) {
        this.replaceAll((object2, object3) -> v);
    }

    @GamlAnnotations.getter(value="pairs")
    default public IPairList getPairs() {
        GamaPairList gamaPairList = new GamaPairList(this);
        this.forEach((object, object2) -> {
            boolean bl = gamaPairList.add(new GamaPair<Object, Object>(object, object2, this.getGamlType().getKeyType(), this.getGamlType().getContentType()));
        });
        return gamaPairList;
    }

    default public boolean forEachPair(BiConsumerWithPruning<K, V> biConsumerWithPruning) {
        for (Map.Entry entry : this.entrySet()) {
            if (biConsumerWithPruning.process(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean isOrdered();

    default public boolean forEachValue(ConsumerWithPruning<? super V> consumerWithPruning) {
        for (Map.Entry entry : this.entrySet()) {
            if (consumerWithPruning.process(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    default public boolean forEachKey(ConsumerWithPruning<K> consumerWithPruning) {
        for (Map.Entry entry : this.entrySet()) {
            if (consumerWithPruning.process(entry.getKey())) continue;
            return false;
        }
        return true;
    }

    @Override
    default public JsonValue serializeToJson(Json json) {
        JsonObject jsonObject = json.object();
        for (Map.Entry entry : this.entrySet()) {
            jsonObject.add(entry.getKey().toString(), json.valueOf(entry.getValue()));
        }
        return jsonObject;
    }

    public static interface IPairList<K, V>
    extends Set<Map.Entry<K, V>>,
    IList<Map.Entry<K, V>> {
        @Override
        default public Spliterator<Map.Entry<K, V>> spliterator() {
            return IList.super.spliterator();
        }
    }
}

