/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.compilation;

import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.COUNTER;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.SymbolTracer;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.expressions.IExpression;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class Symbol
implements ISymbol {
    protected String name;
    protected final IDescription description;
    protected int order;

    @Override
    public IDescription getDescription() {
        return this.description;
    }

    @Override
    public URI getURI() {
        if (this.description == null) {
            return null;
        }
        EObject eObject = this.description.getUnderlyingElement();
        return eObject == null ? null : EcoreUtil.getURI((EObject)eObject);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int n) {
        this.order = n;
    }

    public Symbol(IDescription iDescription) {
        this.description = iDescription;
        this.order = COUNTER.GET_UNIQUE();
    }

    @Override
    public String serializeToGaml(boolean bl) {
        if (this.description == null) {
            return "";
        }
        return this.description.serializeToGaml(bl);
    }

    @Override
    public String getKeyword() {
        if (this.description == null) {
            return null;
        }
        return this.description.getKeyword();
    }

    @Override
    public final IExpression getFacet(String ... stringArray) {
        if (this.description == null) {
            return null;
        }
        return this.description.getFacetExpr(stringArray);
    }

    public Object getFacetValue(IScope iScope, String string) throws GamaRuntimeException {
        return this.getFacetValue(iScope, string, null);
    }

    public final <T> T getFacetValue(IScope iScope, String string, T t) throws GamaRuntimeException {
        IExpression iExpression = this.getFacet(string);
        return (T)(iExpression == null ? t : iExpression.value(iScope));
    }

    public String getLiteral(String string) {
        return this.getLiteral(string, null);
    }

    public String getLiteral(String string, String string2) {
        IExpression iExpression = this.getFacet(string);
        return iExpression == null ? string2 : iExpression.literalValue();
    }

    protected void setFacet(String string, IExpressionDescription iExpressionDescription) {
        if (this.description == null) {
            return;
        }
        this.description.setFacetExprDescription(string, iExpressionDescription);
    }

    @Override
    public boolean hasFacet(String string) {
        return this.description != null && this.description.hasFacet(string);
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getTrace(IScope iScope) {
        return new SymbolTracer().trace(iScope, this);
    }

    @Override
    public void setEnclosing(ISymbol iSymbol) {
    }
}

