/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.collect.ImmutableList;
import gama.annotations.precompiler.GamlProperties;
import gama.core.common.preferences.GamaPreferences;
import gama.core.runtime.GAMA;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.DEBUG;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.FacetProto;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.IVarDescriptionProvider;
import gama.gaml.descriptions.LabelExpressionDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.StatementRemoteWithChildrenDescription;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.descriptions.ValidationContext;
import gama.gaml.expressions.IExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.statements.Facets;
import gama.gaml.statements.IStatement;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;

public abstract class SymbolDescription
implements IDescription {
    protected static final Set<String> typeProviderFacets;
    private final EnumSet<IDescription.Flag> state = EnumSet.noneOf(IDescription.Flag.class);
    private Facets facets;
    protected final EObject element;
    private IDescription enclosingDescription;
    private ModelDescription modelDescription;
    protected String originName;
    protected String name;
    protected final String keyword;
    private IType<?> type;
    final SymbolProto proto;
    static final String[] EMPTY_DATA;
    static final String[] staticTypeProviders;
    static final String[] dynamicTypeProviders;

    static {
        DEBUG.OFF();
        typeProviderFacets = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("value", "type", "as", "species", "of", "over", "from", "index", "function", "update", "init", "default")));
        EMPTY_DATA = new String[0];
        staticTypeProviders = new String[]{"data", "type", "species", "as", "target"};
        dynamicTypeProviders = new String[]{"init", "value", "update", "function", "default"};
    }

    public SymbolDescription(String string, IDescription iDescription, EObject eObject, Facets facets2) {
        this.keyword = string;
        this.facets = facets2;
        this.element = eObject;
        this.setIf(IDescription.Flag.BuiltIn, this.element == null);
        if (facets2 != null && facets2.containsKey("**no_type_inference**")) {
            this.set(IDescription.Flag.NoTypeInference);
            facets2.remove("**no_type_inference**");
        }
        if (facets2 != null && facets2.containsKey("**origin**")) {
            this.originName = facets2.getLabel("**origin**");
            facets2.remove("**origin**");
        } else if (iDescription != null) {
            this.originName = iDescription.getName();
        }
        this.setEnclosingDescription(iDescription);
        this.proto = DescriptionFactory.getProto(this.getKeyword(), this.getSpeciesContext());
    }

    protected void set(IDescription.Flag flag) {
        this.state.add(flag);
    }

    protected void setIf(IDescription.Flag flag, boolean bl) {
        if (bl) {
            this.set(flag);
        } else {
            this.unSet(flag);
        }
    }

    protected void unSet(IDescription.Flag flag) {
        this.state.remove((Object)flag);
    }

    protected boolean isSet(IDescription.Flag flag) {
        return this.state.contains((Object)flag);
    }

    protected boolean hasFacets() {
        return this.facets != null;
    }

    protected boolean hasFacetsNotIn(Set<String> set) {
        if (this.facets == null) {
            return false;
        }
        return !this.visitFacets((string, iExpressionDescription) -> set.contains(string));
    }

    @Override
    public final SymbolSerializer<? extends SymbolDescription> getSerializer() {
        SymbolProto symbolProto = this.getMeta();
        SymbolSerializer<? extends SymbolDescription> symbolSerializer = symbolProto.getSerializer();
        if (symbolSerializer == null) {
            symbolSerializer = this.createSerializer();
            symbolProto.setSerializer(symbolSerializer);
        }
        return symbolSerializer;
    }

    @Override
    public IExpressionDescription getFacet(String string) {
        return !this.hasFacets() ? null : (IExpressionDescription)this.facets.get(string);
    }

    @Override
    public IExpression getFacetExpr(String ... stringArray) {
        return !this.hasFacets() ? null : this.facets.getExpr(stringArray);
    }

    @Override
    public IExpressionDescription getFacet(String ... stringArray) {
        return !this.hasFacets() ? null : this.facets.getDescr(stringArray);
    }

    @Override
    public boolean hasFacet(String string) {
        return this.hasFacets() && this.facets.containsKey(string);
    }

    @Override
    public String getLitteral(String string) {
        return !this.hasFacets() ? null : this.facets.getLabel(string);
    }

    @Override
    public void setFacetExprDescription(String string, IExpressionDescription iExpressionDescription) {
        if (!this.hasFacets()) {
            this.facets = new Facets();
        }
        this.facets.put(string, iExpressionDescription);
    }

    @Override
    public void setFacet(String string, IExpression iExpression) {
        if (!this.hasFacets()) {
            this.facets = new Facets();
        }
        this.facets.putExpression(string, iExpression);
    }

    @Override
    public void removeFacets(String ... stringArray) {
        if (!this.hasFacets()) {
            return;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.facets.remove(string);
            ++n2;
        }
        if (this.facets.isEmpty()) {
            this.facets = null;
        }
    }

    @Override
    public final boolean visitFacets(Set<String> set, IDescription.IFacetVisitor iFacetVisitor) {
        if (!this.hasFacets()) {
            return true;
        }
        return this.facets.forEachFacetIn(set, iFacetVisitor);
    }

    @Override
    public final boolean visitFacets(IDescription.IFacetVisitor iFacetVisitor) {
        if (!this.hasFacets()) {
            return true;
        }
        return this.facets.forEachFacet(iFacetVisitor);
    }

    public IType<?> getTypeDenotedByFacet(String ... stringArray) {
        if (!this.hasFacets()) {
            return Types.NO_TYPE;
        }
        return this.getTypeDenotedByFacet(this.facets.getFirstExistingAmong(stringArray), Types.NO_TYPE);
    }

    @Override
    public String firstFacetFoundAmong(String ... stringArray) {
        if (!this.hasFacets()) {
            return null;
        }
        return this.facets.getFirstExistingAmong(stringArray);
    }

    public IType<?> getTypeDenotedByFacet(String string, IType<?> iType) {
        if (!this.hasFacets()) {
            return iType;
        }
        return this.facets.getTypeDenotedBy(string, this, iType);
    }

    public Facets getFacetsCopy() {
        return !this.hasFacets() ? null : this.facets.cleanCopy();
    }

    protected SymbolSerializer<? extends SymbolDescription> createSerializer() {
        return SYMBOL_SERIALIZER;
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return this.getSerializer().serialize(this, bl);
    }

    @Override
    public void collectMetaInformation(GamlProperties gamlProperties) {
        this.getSerializer().collectMetaInformation(this, gamlProperties);
    }

    @Override
    public int getKind() {
        return this.getMeta().getKind();
    }

    protected void compileTypeProviderFacets() {
        this.visitFacets((string, iExpressionDescription) -> {
            if (typeProviderFacets.contains(string)) {
                iExpressionDescription.compile(this);
            }
            return true;
        });
    }

    protected void compileTypeProviderFacets(String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            IExpressionDescription iExpressionDescription = this.getFacet(string);
            if (iExpressionDescription != null) {
                iExpressionDescription.compile(this);
            }
            ++n2;
        }
    }

    @Override
    public final SymbolProto getMeta() {
        return this.proto;
    }

    protected void flagError(String string, String string2, GamlCompilationError.GamlCompilationErrorType gamlCompilationErrorType, EObject eObject, String ... stringArray) throws GamaRuntimeException {
        if (gamlCompilationErrorType == GamlCompilationError.GamlCompilationErrorType.Warning && !GamaPreferences.Modeling.WARNINGS_ENABLED.getValue().booleanValue() || gamlCompilationErrorType == GamlCompilationError.GamlCompilationErrorType.Info && !GamaPreferences.Modeling.INFO_ENABLED.getValue().booleanValue()) {
            return;
        }
        IDescription iDescription = this;
        EObject eObject2 = eObject;
        if (eObject2 == null) {
            eObject2 = this.getUnderlyingElement();
        }
        while (eObject2 == null && iDescription != null) {
            if ((iDescription = iDescription.getEnclosingDescription()) == null) continue;
            eObject2 = iDescription.getUnderlyingElement();
        }
        if (eObject2 == null || eObject2.eResource() == null || eObject2.eResource().getURI().path().contains("__synthetic__")) {
            if (gamlCompilationErrorType == GamlCompilationError.GamlCompilationErrorType.Error) {
                throw GamaRuntimeException.error(string, GAMA.getRuntimeScope());
            }
            return;
        }
        ValidationContext validationContext = this.getValidationContext();
        if (validationContext == null) {
            DEBUG.ERR((Object)((gamlCompilationErrorType == GamlCompilationError.GamlCompilationErrorType.Warning ? "Warning" : "Error") + ": " + string));
            return;
        }
        validationContext.add(new GamlCompilationError(string, string2, eObject2, gamlCompilationErrorType, stringArray));
    }

    private boolean isSynthetic(EObject eObject) {
        return eObject == null || eObject.eResource() == null || eObject.eResource().getURI().path().contains("__synthetic__");
    }

    @Override
    public void document(EObject eObject, IGamlDescription iGamlDescription) {
        ValidationContext validationContext = this.getValidationContext();
        if (validationContext != null) {
            validationContext.setGamlDocumentation(eObject, iGamlDescription);
        }
    }

    @Override
    public void error(String string) {
        this.error(string, "gaml.general.issue");
    }

    @Override
    public void error(String string, String string2) {
        this.flagError(string, string2, GamlCompilationError.GamlCompilationErrorType.Error, this.getUnderlyingElement(), EMPTY_DATA);
    }

    @Override
    public void error(String string, String string2, EObject eObject, String ... stringArray) {
        this.flagError(string, string2, GamlCompilationError.GamlCompilationErrorType.Error, eObject, stringArray);
    }

    @Override
    public void error(String string, String string2, String string3, String ... stringArray) {
        String[] stringArray2;
        EObject eObject = this.getUnderlyingElement(string3, "gaml.unknown.facet.issue".equals(string2));
        if (stringArray == null || stringArray.length == 0) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = string3;
        } else {
            stringArray2 = stringArray;
        }
        this.flagError(string, string2, GamlCompilationError.GamlCompilationErrorType.Error, eObject, stringArray2);
    }

    @Override
    public void info(String string, String string2) {
        this.flagError(string, string2, GamlCompilationError.GamlCompilationErrorType.Info, this.getUnderlyingElement(), EMPTY_DATA);
    }

    @Override
    public void info(String string, String string2, EObject eObject, String ... stringArray) {
        this.flagError(string, string2, GamlCompilationError.GamlCompilationErrorType.Info, eObject, stringArray);
    }

    @Override
    public void info(String string, String string2, String string3, String ... stringArray) {
        String[] stringArray2;
        EObject eObject = this.getUnderlyingElement(string3, false);
        if (stringArray == null || stringArray.length == 0) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = string3;
        } else {
            stringArray2 = stringArray;
        }
        this.flagError(string, string2, GamlCompilationError.GamlCompilationErrorType.Info, eObject, stringArray2);
    }

    @Override
    public void warning(String string, String string2) {
        this.flagError(string, string2, GamlCompilationError.GamlCompilationErrorType.Warning, null, EMPTY_DATA);
    }

    @Override
    public void warning(String string, String string2, EObject eObject, String ... stringArray) {
        this.flagError(string, string2, GamlCompilationError.GamlCompilationErrorType.Warning, eObject, stringArray);
    }

    @Override
    public void warning(String string, String string2, String string3, String ... stringArray) {
        String[] stringArray2;
        EObject eObject = this.getUnderlyingElement(string3, "gaml.unknown.facet.issue".equals(string2));
        if (stringArray == null || stringArray.length == 0) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = string3;
        } else {
            stringArray2 = stringArray;
        }
        this.flagError(string, string2, GamlCompilationError.GamlCompilationErrorType.Warning, eObject, stringArray2);
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.getLitteral("name");
        }
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
        if (this.getMeta().getPossibleFacets().containsKey("name")) {
            this.setFacetExprDescription("name", LabelExpressionDescription.create(string));
        }
    }

    @Override
    public void dispose() {
        if (this.isBuiltIn()) {
            return;
        }
        this.visitOwnChildren(DISPOSING_VISITOR);
        if (this.hasFacets()) {
            this.facets.dispose();
        }
        this.facets = null;
        this.enclosingDescription = null;
        this.modelDescription = null;
        this.setType(null);
    }

    @Override
    public ModelDescription getModelDescription() {
        return this.modelDescription;
    }

    public final void addChildren(Iterable<? extends IDescription> iterable) {
        if (iterable == null) {
            return;
        }
        for (IDescription iDescription : iterable) {
            this.addChild(iDescription);
        }
    }

    public IDescription addChild(IDescription iDescription) {
        if (iDescription == null) {
            return null;
        }
        iDescription.setEnclosingDescription(this);
        return iDescription;
    }

    @Override
    public void setEnclosingDescription(IDescription iDescription) {
        this.enclosingDescription = iDescription;
        if (this.enclosingDescription == null) {
            return;
        }
        this.modelDescription = this.enclosingDescription.getModelDescription();
        if (this.modelDescription != null && this.modelDescription.isBuiltIn() && !this.isBuiltIn()) {
            this.modelDescription = null;
        }
    }

    @Override
    public EObject getUnderlyingElement(Object object, boolean bl) {
        IExpressionDescription iExpressionDescription;
        Object object2;
        if (object == null) {
            return this.element;
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            return eObject;
        }
        if (object instanceof IExpressionDescription && (object2 = (iExpressionDescription = (IExpressionDescription)object).getTarget()) != null) {
            return object2;
        }
        if (object instanceof String) {
            EObject eObject;
            if (this.getMeta() != null && !bl && object.equals(this.getMeta().getOmissible()) && (object2 = GAML.getEcoreUtils().getExprOf(this.element)) != null) {
                return object2;
            }
            if (bl && (object2 = GAML.getEcoreUtils().getFacetsMapOf(this.element).get(object)) != null) {
                return object2;
            }
            object2 = this.getFacet((String)object);
            if (object2 != null) {
                eObject = GAML.getEcoreUtils().getFacetsMapOf(this.element).get(object);
                if (eObject != null) {
                    return eObject;
                }
                EObject eObject2 = object2.getTarget();
                if (eObject2 != null) {
                    return eObject2;
                }
            }
            if ((eObject = GAML.getEcoreUtils().getExpressionAtKey(this.element, (String)object)) != null) {
                return eObject;
            }
        }
        return null;
    }

    @Override
    public IDescription copy(IDescription iDescription) {
        return this;
    }

    @Override
    public boolean visitOwnChildrenRecursively(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        return true;
    }

    @Override
    public IDescription getEnclosingDescription() {
        return this.enclosingDescription;
    }

    @Override
    public boolean hasAttribute(String string) {
        return false;
    }

    @Override
    public boolean manipulatesVar(String string) {
        return false;
    }

    protected boolean hasAction(String string, boolean bl) {
        return false;
    }

    @Override
    public IVarDescriptionProvider getDescriptionDeclaringVar(String string) {
        IDescription iDescription = this.getEnclosingDescription();
        return iDescription == null ? null : iDescription.getDescriptionDeclaringVar(string);
    }

    @Override
    public IDescription getDescriptionDeclaringAction(String string, boolean bl) {
        IDescription iDescription = this.getEnclosingDescription();
        return iDescription == null ? null : iDescription.getDescriptionDeclaringAction(string, bl);
    }

    @Override
    public IExpression getVarExpr(String string, boolean bl) {
        return null;
    }

    @Override
    public IType<?> getTypeNamed(String string) {
        ModelDescription modelDescription = this.getModelDescription();
        if (modelDescription == null) {
            return Types.get(string);
        }
        return modelDescription.getTypeNamed(string);
    }

    @Override
    public IType<?> getGamlType() {
        if (this.type == null) {
            this.setType(this.computeType());
        }
        return this.type;
    }

    protected IType<?> computeType() {
        return this.computeType(!this.isSet(IDescription.Flag.NoTypeInference));
    }

    protected IType<?> computeType(boolean bl) {
        IType<?> iType = this.getTypeDenotedByFacet(staticTypeProviders);
        IType<?> iType2 = this.getTypeDenotedByFacet("index", iType.getKeyType());
        IType<?> iType3 = this.getTypeDenotedByFacet("of", iType.getContentType());
        return bl ? this.inferTypesOf(iType, iType2, iType3) : GamaType.from(iType, iType2, iType3);
    }

    protected IType<?> inferTypesOf(IType<?> iType, IType<?> iType2, IType<?> iType3) {
        IExpressionDescription iExpressionDescription;
        if (iType == Types.NO_TYPE) {
            iType = this.findInDynamicTypeProviders(iType);
        }
        if (!iType.isContainer()) {
            return iType;
        }
        if ((iType3 == Types.NO_TYPE || iType2 == Types.NO_TYPE) && (iExpressionDescription = this.getFacet(dynamicTypeProviders)) != null) {
            IType<?> iType4;
            IExpression iExpression = iExpressionDescription.compile(this);
            IType<?> iType5 = iType4 = iExpression == null ? Types.NO_TYPE : iExpression.getGamlType();
            if (iType.isAssignableFrom(iType4)) {
                iType = iType4;
            } else {
                if (iType2 == Types.NO_TYPE) {
                    iType2 = iType4.getKeyType();
                }
                if (iType3 == Types.NO_TYPE) {
                    iType3 = iType4.getContentType();
                }
            }
        }
        return GamaType.from(iType, iType2, iType3);
    }

    private IType<?> findInDynamicTypeProviders(IType<?> iType) {
        IExpression iExpression;
        IExpressionDescription iExpressionDescription = this.getFacet(dynamicTypeProviders);
        if (iExpressionDescription != null && (iExpression = iExpressionDescription.compile(this)) != null) {
            return iExpression.getGamlType();
        }
        return iType;
    }

    @Override
    public SpeciesDescription getSpeciesContext() {
        IDescription iDescription = this.getEnclosingDescription();
        if (iDescription == null) {
            return null;
        }
        return iDescription.getSpeciesContext();
    }

    @Override
    public SpeciesDescription getSpeciesDescription(String string) {
        ModelDescription modelDescription = this.getModelDescription();
        if (modelDescription == null) {
            return null;
        }
        return modelDescription.getSpeciesDescription(string);
    }

    @Override
    public ActionDescription getAction(String string) {
        return null;
    }

    @Override
    public String getTitle() {
        return "Statement " + this.getKeyword();
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        return this.getMeta().getDocumentation();
    }

    @Override
    public String getDefiningPlugin() {
        return this.getMeta().getDefiningPlugin();
    }

    @Override
    public void setDefiningPlugin(String string) {
    }

    @Override
    public ValidationContext getValidationContext() {
        ModelDescription modelDescription = this.getModelDescription();
        if (modelDescription == null) {
            return null;
        }
        return modelDescription.getValidationContext();
    }

    @Override
    public boolean isBuiltIn() {
        return this.state.contains((Object)IDescription.Flag.BuiltIn);
    }

    protected boolean isSynthetic() {
        return this.state.contains((Object)IDescription.Flag.Synthetic);
    }

    @Override
    public String getOriginName() {
        return this.originName;
    }

    @Override
    public void setOriginName(String string) {
        if (this.originName == null) {
            this.originName = string;
        }
    }

    @Override
    public void resetOriginName() {
        this.originName = null;
    }

    @Override
    public IDescription validate() {
        if (this.isSet(IDescription.Flag.Validated)) {
            return this;
        }
        this.set(IDescription.Flag.Validated);
        if (this.isBuiltIn()) {
            this.validateFacets();
            return this;
        }
        IDescription iDescription2 = this.getEnclosingDescription();
        if (iDescription2 != null) {
            String string = this.getKeyword();
            String string2 = iDescription2.getKeyword();
            if (!this.proto.canBeDefinedIn(iDescription2)) {
                this.error(string + " cannot be defined in " + string2, "gaml.wrong.context.issue");
                return null;
            }
            if (this.proto.isUniqueInContext()) {
                boolean bl;
                boolean bl2 = bl = !iDescription2.visitOwnChildren(iDescription -> {
                    if (iDescription != this && iDescription.getKeyword().equals(string)) {
                        String string3 = string + " is defined twice. Only one definition is allowed in " + string2;
                        iDescription.error(string3, "gaml.duplicate.keyword.issue", iDescription.getUnderlyingElement(), string);
                        this.error(string3, "gaml.duplicate.keyword.issue", this.getUnderlyingElement(), string);
                        return false;
                    }
                    return true;
                });
                if (bl) {
                    return null;
                }
            }
        }
        if (!this.validateFacets() || !this.validateChildren()) {
            return null;
        }
        if (this.proto.getDeprecated() != null) {
            this.warning("'" + this.getKeyword() + "' is deprecated. " + this.proto.getDeprecated(), "gaml.deprecated.code.issue");
        }
        if (!this.proto.getValidator().validate(this, this.element, new IExpression[0])) {
            return null;
        }
        return this;
    }

    private final boolean validateFacets() {
        boolean bl = this.isSet(IDescription.Flag.IsInvocation);
        boolean bl2 = this.isBuiltIn();
        ImmutableList<String> immutableList = this.proto.getMandatoryFacets();
        if (immutableList != null) {
            for (String string2 : immutableList) {
                if (this.facets.containsKey(string2)) continue;
                this.error("Missing facet " + string2, "gaml.missing.facet.issue", this.getUnderlyingElement(), string2, "nil");
                return false;
            }
        }
        return this.visitFacets((string, iExpressionDescription) -> {
            FacetProto facetProto = this.proto.getFacet((String)string);
            if (facetProto == null) {
                return this.processUnknowFacet(bl, (String)string);
            }
            if (facetProto.getDeprecated() != null) {
                this.warning("Facet '" + string + "' is deprecated: " + facetProto.getDeprecated(), "gaml.deprecated.code.issue", (String)string, new String[0]);
            }
            if (facetProto.values != null) {
                if (!this.processMultiValuedFacet((String)string, (IExpressionDescription)iExpressionDescription, facetProto)) {
                    return false;
                }
            } else {
                IExpression iExpression = this.compileExpression((String)string, (IExpressionDescription)iExpressionDescription, facetProto);
                if (iExpression != null && !bl2) {
                    IType<?> iType;
                    IType<?> iType2 = iExpression.getGamlType();
                    if ("init".equals(facetProto.name) && (Types.POINT == (iType = this.getGamlType()) || Types.DATE == iType) && iType2 == Types.NO_TYPE) {
                        return true;
                    }
                    iType = facetProto.contentType;
                    IType<?> iType3 = facetProto.keyType;
                    boolean bl3 = this.verifyFacetTypesCompatibility(facetProto, iExpression, iType2, iType, iType3);
                    if (!bl3) {
                        this.emitFacetTypesIncompatibilityWarning((String)string, facetProto, iType2, iType, iType3);
                    }
                }
            }
            return true;
        });
    }

    private IExpression compileExpression(String string, IExpressionDescription iExpressionDescription, FacetProto facetProto) {
        IExpression iExpression;
        if (facetProto.isNewTemp) {
            iExpression = this.createVarWithTypes(string);
            iExpressionDescription.setExpression(iExpression);
        } else if (!facetProto.isLabel()) {
            SymbolDescription symbolDescription;
            if (facetProto.isRemote && (symbolDescription = this) instanceof StatementRemoteWithChildrenDescription) {
                StatementRemoteWithChildrenDescription statementRemoteWithChildrenDescription = (StatementRemoteWithChildrenDescription)symbolDescription;
                IDescription iDescription = statementRemoteWithChildrenDescription.pushRemoteContext();
                iExpression = iExpressionDescription.compile(this);
                statementRemoteWithChildrenDescription.popRemoteContext(iDescription);
            } else {
                iExpression = iExpressionDescription.compile(this);
            }
        } else {
            iExpression = iExpressionDescription.getExpression();
        }
        return iExpression;
    }

    private void emitFacetTypesIncompatibilityWarning(String string, FacetProto facetProto, IType<?> iType, IType<?> iType2, IType<?> iType3) {
        Object[] objectArray = new String[facetProto.types.length];
        int n = 0;
        while (n < facetProto.types.length) {
            IType<?> iType4 = facetProto.types[n];
            if (iType4.isContainer()) {
                iType4 = GamaType.from(iType4, iType3, iType2);
            }
            objectArray[n] = iType4.toString();
            ++n;
        }
        this.warning("Facet '" + string + "' is expecting " + Arrays.toString(objectArray) + " instead of " + String.valueOf(iType), "gaml.casting.issue", string, facetProto.types[0].toString());
    }

    private boolean verifyFacetTypesCompatibility(FacetProto facetProto, IExpression iExpression, IType<?> iType, IType<?> iType2, IType<?> iType3) {
        boolean bl = false;
        IType<?>[] iTypeArray = facetProto.types;
        int n = facetProto.types.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl2;
            IType<?> iType4 = iTypeArray[n2];
            if (iType4 == Types.NO_TYPE) {
                return true;
            }
            boolean bl3 = bl2 = iType == Types.NO_TYPE;
            if (iType4.isContainer()) {
                bl = iType.equals(iType4) && iType.getKeyType().equals(iType3) && iType.getContentType().equals(iType2) || !bl2 && iType.isTranslatableInto(iType4) && iType.getKeyType().isTranslatableInto(iType3) && iType.getContentType().isTranslatableInto(iType2);
            } else {
                boolean bl4 = bl = iType.equals(iType4) || !bl2 && iType.isTranslatableInto(iType4);
            }
            if (bl |= Types.isEmptyContainerCase(iType4, iExpression)) break;
            ++n2;
        }
        return bl;
    }

    private boolean processMultiValuedFacet(String string, IExpressionDescription iExpressionDescription, FacetProto facetProto) {
        String string2 = iExpressionDescription.getExpression().literalValue();
        if (!facetProto.values.contains(string2)) {
            this.error("Facet '" + string + "' is expecting a value among " + String.valueOf(facetProto.values) + " instead of " + string2, string);
            return false;
        }
        return true;
    }

    private boolean processUnknowFacet(boolean bl, String string) {
        if (string.contains("***DOUBLED***")) {
            String string2 = string.replace("***DOUBLED***", "");
            String string3 = "Facet " + string2 + " is declared twice. Please correct.";
            this.error(string3, "gaml.duplicate.definition.issue", string, "1");
            this.error(string3, "gaml.duplicate.definition.issue", string2, "2");
            return false;
        }
        if (!bl) {
            this.error("Unknown facet " + string, "gaml.unknown.facet.issue", string, new String[0]);
            return false;
        }
        return true;
    }

    protected IExpression createVarWithTypes(String string) {
        return null;
    }

    protected boolean validateChildren() {
        return this.visitOwnChildren(VALIDATING_VISITOR);
    }

    @Override
    public final ISymbol compile() {
        this.validate();
        ISymbol iSymbol = this.proto.create(this);
        if (iSymbol == null) {
            return null;
        }
        if (this.proto.hasArgs()) {
            ((IStatement.WithArgs)iSymbol).setFormalArgs(((StatementDescription)this).createCompiledArgs());
        }
        if (this.proto.hasSequence() && !this.proto.isPrimitive()) {
            iSymbol.setChildren(this.compileChildren());
        }
        return iSymbol;
    }

    protected Iterable<? extends ISymbol> compileChildren() {
        ArrayList arrayList = new ArrayList();
        this.visitChildren(iDescription -> {
            ISymbol iSymbol = iDescription.compile();
            if (iSymbol != null) {
                arrayList.add(iSymbol);
            }
            return true;
        });
        return arrayList;
    }

    @Override
    public Iterable<IDescription> getChildrenWithKeyword(String string) {
        return StreamSupport.stream(this.getOwnChildren().spliterator(), false).filter(iDescription -> iDescription.getKeyword().equals(string)).toList();
    }

    @Override
    public IDescription getChildWithKeyword(String string) {
        IDescription[] iDescriptionArray = new IDescription[1];
        this.visitChildren(iDescription -> {
            if (iDescription.getKeyword().equals(string)) {
                iDescriptionArray[0] = iDescription;
                return false;
            }
            return true;
        });
        return iDescriptionArray[0];
    }

    @Override
    public Facets getFacets() {
        return this.facets == null ? Facets.NULL : this.facets;
    }

    @Override
    public void attachAlternateVarDescriptionProvider(IVarDescriptionProvider iVarDescriptionProvider) {
    }

    public static IDescription getSimilarChild(IDescription iDescription, IDescription iDescription3) {
        IDescription[] iDescriptionArray = new IDescription[1];
        iDescription.visitChildren(iDescription2 -> {
            if (iDescription2 != null && iDescription2.getKeyword().equals(iDescription3.getKeyword()) && iDescription2.getName().equals(iDescription3.getName())) {
                iDescriptionArray[0] = iDescription2;
                return false;
            }
            return true;
        });
        return iDescriptionArray[0];
    }

    @Override
    public void replaceChildrenWith(Iterable<IDescription> iterable) {
    }

    private void setType(IType<?> iType) {
        this.type = iType;
    }

    @Override
    public boolean isInvocation() {
        return this.isSet(IDescription.Flag.IsInvocation);
    }

    public boolean isCreate() {
        return this.isSet(IDescription.Flag.IsCreate);
    }
}

