/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.multi_criteria;

import gama.gaml.multi_criteria.Candidate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Electre {
    private Map<String, Double> poids = new HashMap<String, Double>();
    private double seuilCoupe = 0.7;
    private Map<String, Double> preference = new HashMap<String, Double>();
    private Map<String, Double> indifference = new HashMap<String, Double>();
    private Map<String, Double> veto = new HashMap<String, Double>();
    private final List<String> critereOrdonnes;

    public Electre(List<String> list) {
        this.critereOrdonnes = list;
        for (String string : list) {
            this.poids.put(string, 5.0);
            this.preference.put(string, 0.3);
            this.indifference.put(string, 0.1);
            this.veto.put(string, 0.0);
        }
    }

    public Map<String, Double> getPoids() {
        return this.poids;
    }

    public void setPoids(Map<String, Double> map) {
        this.poids = map;
        this.critereOrdonnes.clear();
        this.critereOrdonnes.addAll(map.keySet());
        Collections.sort(this.critereOrdonnes);
    }

    public Candidate decision(List<Candidate> list) {
        int n;
        Candidate candidate;
        int[][] nArray = new int[list.size()][list.size()];
        int n2 = 0;
        while (n2 < list.size() - 1) {
            candidate = list.get(n2);
            n = n2 + 1;
            while (n < list.size()) {
                Candidate candidate2 = list.get(n);
                nArray[n2][n] = 0;
                nArray[n][n2] = 0;
                String string = this.relation(candidate, candidate2);
                if ("A1_P_A2".equals(string)) {
                    nArray[n2][n] = 1;
                    nArray[n][n2] = -1;
                } else if ("A2_P_A1".equals(string)) {
                    nArray[n2][n] = -1;
                    nArray[n][n2] = 1;
                }
                ++n;
            }
            ++n2;
        }
        n2 = -999999;
        candidate = null;
        n = 0;
        while (n < list.size()) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < list.size()) {
                n3 += nArray[n][n4];
                ++n4;
            }
            if (n3 > n2) {
                n2 = n3;
                candidate = list.get(n);
            }
            ++n;
        }
        return candidate;
    }

    private double concordance(double d, double d2, String string) {
        double d3 = 0.0;
        double d4 = this.preference.get(string);
        double d5 = d - d2;
        double d6 = this.indifference.get(string);
        if (d5 > -d6) {
            d3 = 1.0;
        } else if (d5 > -d4) {
            d3 = (d5 + d4) / (d4 - d6);
        }
        return d3;
    }

    private double discordance(double d, double d2, String string) {
        double d3 = this.preference.get(string);
        double d4 = this.veto.get(string);
        double d5 = d - d2;
        double d6 = 0.0;
        if (d5 < -d4) {
            d6 = 1.0;
        } else if (d5 < -d3) {
            d6 += (d5 + d3) / (d3 - d4);
        }
        return d6;
    }

    private String relation(Candidate candidate, Candidate candidate2) {
        double d;
        double d2;
        double d3;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (String string : this.poids.keySet()) {
            d3 = this.poids.get(string);
            d2 = candidate.getValCriteria().get(string);
            d = candidate2.getValCriteria().get(string);
            d6 += d3;
            d4 += d3 * this.concordance(d2, d, string);
            d5 += d3 * this.concordance(d, d2, string);
        }
        d4 /= d6;
        d5 /= d6;
        double d7 = 1.0;
        d3 = 1.0;
        for (String string : this.poids.keySet()) {
            d = candidate.getValCriteria().get(string);
            double d8 = candidate2.getValCriteria().get(string);
            double d9 = this.discordance(d, d8, string);
            double d10 = this.discordance(d8, d, string);
            if (d9 > d4) {
                d7 *= (1.0 - d9) / (1.0 - d4);
            }
            if (!(d10 > d5)) continue;
            d3 *= (1.0 - d10) / (1.0 - d5);
        }
        d2 = d4 * d7;
        d = d5 * d3;
        if (d2 < this.seuilCoupe) {
            if (d < this.seuilCoupe) {
                return "A1_R_A2";
            }
            return "A2_P_A1";
        }
        if (d < this.seuilCoupe) {
            return "A1_P_A2";
        }
        return "A1_I_A2";
    }

    public String toString() {
        String string = this.seuilCoupe + ",";
        for (String string2 : this.critereOrdonnes) {
            string = string + string2 + ":" + String.valueOf(this.poids.get(string2)) + "," + String.valueOf(this.preference.get(string2)) + "," + String.valueOf(this.indifference.get(string2)) + "," + String.valueOf(this.veto.get(string2));
        }
        return string;
    }

    public double getSeuilCoupe() {
        return this.seuilCoupe;
    }

    public void setSeuilCoupe(double d) {
        this.seuilCoupe = d;
    }

    public Map<String, Double> getPreference() {
        return this.preference;
    }

    public void setPreference(Map<String, Double> map) {
        this.preference = map;
    }

    public Map<String, Double> getIndifference() {
        return this.indifference;
    }

    public void setIndifference(Map<String, Double> map) {
        this.indifference = map;
    }

    public Map<String, Double> getVeto() {
        return this.veto;
    }

    public void setVeto(Map<String, Double> map) {
        this.veto = map;
    }

    public List<String> getCritereOrdonnes() {
        return this.critereOrdonnes;
    }
}

