/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import com.google.common.collect.Iterables;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Strings;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.ElseStatement;
import gama.gaml.statements.IStatement;

@GamlAnnotations.inside(kinds={3, 11, 6, 5})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="condition", type={3}, optional=false, doc={@GamlAnnotations.doc(value="A boolean expression: the condition that is evaluated.")})}, omissible="condition")
@GamlAnnotations.doc(value="Allows the agent to execute a sequence of statements if and only if the condition evaluates to true.", usages={@GamlAnnotations.usage(value="The generic syntax is:", examples={@GamlAnnotations.example(value="if bool_expr {", isExecutable=false), @GamlAnnotations.example(value="    [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="Optionally, the statements to execute when the condition evaluates to false can be defined in a following statement else. The syntax then becomes:", examples={@GamlAnnotations.example(value="if bool_expr {", isExecutable=false), @GamlAnnotations.example(value="    [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="else {", isExecutable=false), @GamlAnnotations.example(value="    [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="string valTrue <- \"\";"), @GamlAnnotations.example(value="if true {"), @GamlAnnotations.example(value="\tvalTrue <- \"true\";"), @GamlAnnotations.example(value="}"), @GamlAnnotations.example(value="else {"), @GamlAnnotations.example(value="\tvalTrue <- \"false\";"), @GamlAnnotations.example(value="}"), @GamlAnnotations.example(var="valTrue", equals="\"true\""), @GamlAnnotations.example(value="string valFalse <- \"\";"), @GamlAnnotations.example(value="if false {"), @GamlAnnotations.example(value="\tvalFalse <- \"true\";"), @GamlAnnotations.example(value="}"), @GamlAnnotations.example(value="else {"), @GamlAnnotations.example(value="\tvalFalse <- \"false\";"), @GamlAnnotations.example(value="}"), @GamlAnnotations.example(var="valFalse", equals="\"false\"")}), @GamlAnnotations.usage(value="ifs and elses can be imbricated as needed. For instance:", examples={@GamlAnnotations.example(value="if bool_expr {", isExecutable=false), @GamlAnnotations.example(value="    [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="else if bool_expr2 {", isExecutable=false), @GamlAnnotations.example(value="    [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="else {", isExecutable=false), @GamlAnnotations.example(value="    [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})})
@serializer(value=IfSerializer.class)
public class IfStatement
extends AbstractStatementSequence {
    public IStatement alt;
    final IExpression cond = this.getFacet("condition");

    public IfStatement(IDescription iDescription) {
        super(iDescription);
        if (this.cond != null) {
            this.setName("if " + this.cond.serializeToGaml(false));
        }
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        for (ISymbol iSymbol2 : iterable) {
            if (!(iSymbol2 instanceof ElseStatement)) continue;
            this.alt = (IStatement)iSymbol2;
        }
        super.setChildren(Iterables.filter(iterable, iSymbol -> iSymbol != this.alt));
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Object object = this.cond.value(iScope);
        if (!(object instanceof Boolean)) {
            throw GamaRuntimeException.error("Impossible to evaluate condition " + this.cond.serializeToGaml(true), iScope);
        }
        return (Boolean)object != false ? super.privateExecuteIn(iScope) : (this.alt != null ? iScope.execute(this.alt).getValue() : null);
    }

    @Override
    public void dispose() {
        if (this.alt != null) {
            this.alt.dispose();
        }
        this.alt = null;
        super.dispose();
    }

    public static class IfSerializer
    extends SymbolSerializer.StatementSerializer {
        @Override
        protected void serializeChildren(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            stringBuilder.append(' ').append('{').append(Strings.LN);
            String[] stringArray = new String[1];
            symbolDescription.visitChildren(iDescription -> {
                if ("else".equals(iDescription.getKeyword())) {
                    stringArray[0] = iDescription.serializeToGaml(false) + Strings.LN;
                } else {
                    this.serializeChild((IDescription)iDescription, stringBuilder, bl);
                }
                return true;
            });
            stringBuilder.append('}');
            if (stringArray[0] != null) {
                stringBuilder.append(stringArray[0]);
            } else {
                stringBuilder.append(Strings.LN);
            }
        }
    }
}

