/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.agent.ISerialisedAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.runtime.FlowStatus;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.RemoteSequence;
import gama.gaml.types.Types;
import java.util.List;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="target", type={11, 5}, of=11, optional=false, doc={@GamlAnnotations.doc(value="an expression that is evaluated as an agent/a list of the agents to be released")}), @GamlAnnotations.facet(name="as", type={14}, optional=true, doc={@GamlAnnotations.doc(value="an expression that is evaluated as a species in which the micro-agent will be released")}), @GamlAnnotations.facet(name="in", type={11}, optional=true, doc={@GamlAnnotations.doc(value="an expression that is evaluated as an agent that will be the macro-agent in which micro-agent will be released, i.e. their new host")}), @GamlAnnotations.facet(name="returns", type={-204}, optional=true, doc={@GamlAnnotations.doc(value="a new variable containing a list of the newly released agent(s)")})}, omissible="target")
@GamlAnnotations.doc(value="Allows an agent to release its micro-agent(s). The preliminary for an agent to release its micro-agents is that species of these micro-agents are sub-species of other species (cf. [Species161#Nesting_species Nesting species]). The released agents won't be micro-agents of the calling agent anymore. Being released from a macro-agent, the micro-agents will change their species and host (macro-agent).", usages={@GamlAnnotations.usage(value="We consider the following species. Agents of \"C\" species can be released from a \"B\" agent to become agents of \"A\" species. Agents of \"D\" species cannot be released from the \"A\" agent because species \"D\" has no parent species.", examples={@GamlAnnotations.example(value="species A {", isExecutable=false), @GamlAnnotations.example(value="...", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="species B {", isExecutable=false), @GamlAnnotations.example(value="...", isExecutable=false), @GamlAnnotations.example(value="   species C parent: A {", isExecutable=false), @GamlAnnotations.example(value="   ...", isExecutable=false), @GamlAnnotations.example(value="   }", isExecutable=false), @GamlAnnotations.example(value="   species D {", isExecutable=false), @GamlAnnotations.example(value="   ...", isExecutable=false), @GamlAnnotations.example(value="   }", isExecutable=false), @GamlAnnotations.example(value="...", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="To release all \"C\" agents from a \"B\" agent, agent \"C\" has to execute the following statement. The \"C\" agent will change to \"A\" agent. The won't consider \"B\" agent as their macro-agent (host) anymore. Their host (macro-agent) will the be the host (macro-agent) of the \"B\" agent.", examples={@GamlAnnotations.example(value="release list(C);", isExecutable=false)}), @GamlAnnotations.usage(value="The modeler can specify the new host and the new species of the released agents:", examples={@GamlAnnotations.example(value="release list (C) as: new_species in: new host;", isExecutable=false)})}, see={"capture"})
public class ReleaseStatement
extends AbstractStatementSequence {
    private final IExpression target = this.getFacet("target");
    private final IExpression asExpr = this.getFacet("as");
    private final IExpression inExpr = this.getFacet("in");
    private final String returnString = this.getLiteral("returns");
    private RemoteSequence sequence = null;

    public ReleaseStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public void enterScope(IScope iScope) {
        if (this.returnString != null) {
            iScope.addVarWithValue(this.returnString, null);
        }
        super.enterScope(iScope);
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.sequence = new RemoteSequence(this.description);
        this.sequence.setName("commands of " + this.getName());
        this.sequence.setChildren(iterable);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        List<IAgent> list;
        Object object = this.target.value(iScope);
        IAgent iAgent = iScope.getAgent();
        if (object instanceof ISerialisedAgent) {
            ISerialisedAgent iSerialisedAgent = (ISerialisedAgent)object;
            list = this.releaseAgentPrototype(iScope, iAgent, iSerialisedAgent);
        } else {
            IList<IAgent> addressable = GamaListFactory.create(Types.AGENT);
            if (object instanceof IContainer) {
                for (Object object2 : ((IContainer)object).iterable(iScope)) {
                    if (!(object2 instanceof IAgent)) continue;
                    addressable.add((IAgent)object2);
                }
            } else if (object instanceof IAgent) {
                addressable.add((IAgent)object);
            }
            addressable.removeIf(iAgent2 -> !iAgent2.getHost().equals(iAgent));
            list = this.releaseExistingAgents(iScope, iAgent, addressable);
        }
        if (!list.isEmpty() && !this.sequence.isEmpty()) {
            for (IAgent iAgent3 : list) {
                if (!iScope.execute(this.sequence, iAgent3, null).passed() || iScope.interrupted() || iScope.getAndClearBreakStatus() == FlowStatus.BREAK) break;
            }
        }
        if (this.returnString != null) {
            iScope.setVarValue(this.returnString, list);
        }
        return list;
    }

    private List<IAgent> releaseAgentPrototype(IScope iScope, IAgent iAgent, ISerialisedAgent iSerialisedAgent) {
        Object object;
        if (this.asExpr == null) {
            throw GamaRuntimeException.error("Cannot release agent as its destination species is not specified", iScope);
        }
        IMacroAgent iMacroAgent = null;
        ISpecies iSpecies = null;
        if (this.inExpr == null) {
            object = this.asExpr.literalValue();
            iMacroAgent = iAgent.getHost();
            while (iMacroAgent != null) {
                iSpecies = iMacroAgent.getSpecies().getMicroSpecies((String)object);
                if (iSpecies == null) {
                    iMacroAgent = iMacroAgent.getHost();
                    continue;
                }
                break;
            }
        } else {
            iMacroAgent = (IMacroAgent)this.inExpr.value(iScope);
            iSpecies = (ISpecies)iScope.evaluate(this.asExpr, iMacroAgent).getValue();
        }
        if (iSpecies == null) {
            throw GamaRuntimeException.error("Cannot release agent as " + String.valueOf(this.asExpr) + " cannot be interpreted as a destination population", iScope);
        }
        if (iMacroAgent == null) {
            throw GamaRuntimeException.error("Cannot release agent as the host of its destination population is nil", iScope);
        }
        object = iAgent.getPopulationFor(iSpecies);
        IAgent iAgent2 = iSerialisedAgent.restoreInto(iScope, (IPopulation<? extends IAgent>)object);
        return GamaListFactory.create(iScope, Types.AGENT, iAgent2);
    }

    public List<IAgent> releaseExistingAgents(IScope iScope, IAgent iAgent, IList<IAgent> iList) {
        IList<IAgent> iList2;
        block6: {
            ISpecies iSpecies;
            block8: {
                block7: {
                    block5: {
                        iList2 = GamaListFactory.create();
                        iSpecies = null;
                        if (this.asExpr == null || this.inExpr == null) break block5;
                        IMacroAgent iMacroAgent = (IMacroAgent)this.inExpr.value(iScope);
                        if (iMacroAgent == null || iMacroAgent.equals(iAgent)) break block6;
                        iSpecies = (ISpecies)iScope.evaluate(this.asExpr, iMacroAgent).getValue();
                        iList2 = iMacroAgent.captureMicroAgents(iScope, iSpecies, iList);
                        break block6;
                    }
                    if (this.asExpr == null || this.inExpr != null) break block7;
                    String string = this.asExpr.literalValue();
                    IMacroAgent iMacroAgent = iAgent.getHost();
                    while (iMacroAgent != null) {
                        iSpecies = iMacroAgent.getSpecies().getMicroSpecies(string);
                        if (iSpecies != null) break;
                        iMacroAgent = iMacroAgent.getHost();
                    }
                    if (iSpecies == null || iMacroAgent == null) break block6;
                    iList2 = iMacroAgent.captureMicroAgents(iScope, iSpecies, iList);
                    break block6;
                }
                if (this.asExpr != null || this.inExpr == null) break block8;
                IMacroAgent iMacroAgent = (IMacroAgent)this.inExpr.value(iScope);
                if (iMacroAgent == null || iMacroAgent.equals(iAgent)) break block6;
                iList2 = GamaListFactory.create(Types.AGENT);
                for (IAgent iAgent2 : iList) {
                    iSpecies = iMacroAgent.getSpecies().getMicroSpecies(iAgent2.getSpeciesName());
                    if (iSpecies == null) continue;
                    iList2.add(iMacroAgent.captureMicroAgent(iScope, iSpecies, iAgent2));
                }
                break block6;
            }
            if (this.asExpr == null && this.inExpr == null) {
                iList2 = GamaListFactory.create(Types.AGENT);
                for (IAgent iAgent3 : iList) {
                    ISpecies iSpecies2 = iAgent3.getSpecies();
                    IMacroAgent iMacroAgent = iAgent.getHost();
                    while (iMacroAgent != null) {
                        iSpecies = iMacroAgent.getSpecies().getMicroSpecies(iSpecies2.getName());
                        if (iSpecies != null) break;
                        iMacroAgent = iMacroAgent.getHost();
                    }
                    if (iMacroAgent == null || iSpecies == null) continue;
                    iList2.add(iMacroAgent.captureMicroAgent(iScope, iSpecies, iAgent3));
                }
            }
        }
        return iList2;
    }

    @Override
    public void dispose() {
        if (this.sequence != null) {
            this.sequence.dispose();
        }
        this.sequence = null;
        super.dispose();
    }
}

