/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.experiment;

import gama.core.common.interfaces.GeneralSynchronizer;
import gama.core.kernel.experiment.IExperimentController;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.server.GamaServerExperimentConfiguration;
import java.util.concurrent.ArrayBlockingQueue;

public abstract class AbstractExperimentController
implements IExperimentController {
    protected IScope scope;
    protected boolean disposing;
    protected GamaServerExperimentConfiguration serverConfiguration;
    protected volatile boolean experimentAlive = true;
    protected volatile boolean paused = true;
    protected volatile boolean acceptingCommands = true;
    protected final GeneralSynchronizer lock = GeneralSynchronizer.withInitialAndMaxPermits(1, 1);
    protected IExperimentPlan experiment;
    protected volatile ArrayBlockingQueue<IExperimentController.ExperimentCommand> commands = new ArrayBlockingQueue(50);
    protected Thread commandThread = new Thread(() -> {
        while (this.acceptingCommands) {
            try {
                this.processUserCommand(this.commands.take());
            }
            catch (Exception exception) {}
        }
    }, "Front end controller");

    @Override
    public IExperimentPlan getExperiment() {
        return this.experiment;
    }

    public void setExperiment(IExperimentPlan iExperimentPlan) {
        this.experiment = iExperimentPlan;
    }

    private boolean offer(IExperimentController.ExperimentCommand experimentCommand) {
        if (this.experiment == null || this.isDisposing()) {
            return false;
        }
        return this.commands.offer(experimentCommand);
    }

    protected abstract boolean processUserCommand(IExperimentController.ExperimentCommand var1);

    protected boolean synchronousStep() {
        return this.processUserCommand(IExperimentController.ExperimentCommand._STEP);
    }

    protected boolean synchronousStepBack() {
        return this.processUserCommand(IExperimentController.ExperimentCommand._BACK);
    }

    protected boolean synchronousStart() {
        return this.processUserCommand(IExperimentController.ExperimentCommand._START);
    }

    protected boolean synchronousReload() {
        return this.processUserCommand(IExperimentController.ExperimentCommand._RELOAD);
    }

    protected boolean asynchronousPause() {
        return this.offer(IExperimentController.ExperimentCommand._PAUSE);
    }

    protected boolean synchronousPause() {
        return this.processUserCommand(IExperimentController.ExperimentCommand._PAUSE);
    }

    protected boolean asynchronousStep() {
        return this.offer(IExperimentController.ExperimentCommand._STEP);
    }

    protected boolean asynchronousStepBack() {
        return this.offer(IExperimentController.ExperimentCommand._BACK);
    }

    protected boolean asynchronousReload() {
        return this.offer(IExperimentController.ExperimentCommand._RELOAD);
    }

    protected boolean synchronousOpen() {
        return this.processUserCommand(IExperimentController.ExperimentCommand._OPEN);
    }

    protected boolean asynchronousStart() {
        return this.offer(IExperimentController.ExperimentCommand._START);
    }

    protected boolean asynchronousOpen() {
        return this.offer(IExperimentController.ExperimentCommand._OPEN);
    }

    @Override
    public boolean isDisposing() {
        return this.disposing;
    }

    protected IScope getScope() {
        return this.scope == null ? this.experiment.getExperimentScope() : this.scope;
    }

    @Override
    public boolean processOpen(boolean bl) {
        return bl ? this.synchronousOpen() : this.asynchronousOpen();
    }

    @Override
    public boolean processPause(boolean bl) {
        return !GAMA.getGui().isInDisplayThread() && bl ? this.synchronousPause() : this.asynchronousPause();
    }

    @Override
    public boolean processReload(boolean bl) {
        return bl ? this.synchronousReload() : this.asynchronousReload();
    }

    @Override
    public boolean processStep(boolean bl) {
        return bl ? this.synchronousStep() : this.asynchronousStep();
    }

    @Override
    public boolean processBack(boolean bl) {
        return bl ? this.synchronousStepBack() : this.asynchronousStepBack();
    }

    @Override
    public boolean processStart(boolean bl) {
        return bl ? this.synchronousStart() : this.asynchronousStart();
    }
}

