/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.experiment;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.batch.exploration.AExplorationAlgorithm;
import gama.core.kernel.batch.optimization.AOptimizationAlgorithm;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.ExperimentParameter;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.kernel.simulation.SimulationPopulation;
import gama.core.metamodel.agent.AbstractAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.runtime.GAMA;
import gama.core.runtime.IExperimentStateListener;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.dev.THREADS;
import gama.gaml.expressions.IExpression;
import gama.gaml.interfaces.INamed;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.gaml.variables.IVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.DoubleStream;
import org.jfree.data.statistics.Statistics;

@GamlAnnotations.experiment(value="batch")
@GamlAnnotations.doc(value="Experiments supporting the execution of several simulations in order to explore parameters or reach a specific state. They can be used in GUI or headless mode")
public class BatchAgent
extends ExperimentAgent {
    public static final String BATCH_EXPERIMENT = "Batch experiment";
    public static final String EXPLORATION_EXPERIMENT = "Exploration experiment";
    public static final String CALIBRATION_EXPERIMENT = "Calibration experiment";
    private int runNumber;
    ParametersSet currentSolution;
    ParametersSet lastSolution;
    Double lastFitness;
    private Double[] seeds;
    final List<Double> fitnessValues = new ArrayList<Double>();
    final Map<String, Object> trackedValues = new HashMap<String, Object>();
    private boolean simDispose;

    public BatchAgent(IPopulation iPopulation, int n) throws GamaRuntimeException {
        super(iPopulation, n);
        IScope iScope = this.getSpecies().getExperimentScope();
        IExpression iExpression = this.getSpecies().getFacet("repeat");
        int n2 = 1;
        if (iExpression != null && iExpression.isConst()) {
            n2 = Cast.asInt(iScope, iExpression.value(iScope));
        }
        this.setSeeds(new Double[n2]);
        this.setKeepSimulations(this.getSpecies().keepsSimulations());
    }

    @Override
    public void schedule(IScope iScope) {
        super.schedule(iScope);
        if (this.getSpecies().keepsSeed()) {
            int n = 0;
            while (n < this.seeds.length) {
                this.getSeeds()[n] = this.getScope().getRandom().between(0.0, 9.223372036854776E18);
                ++n;
            }
        }
    }

    @Override
    public Object _init_(IScope iScope) {
        this.getSpecies().getExplorationAlgorithm().initializeFor(iScope, this);
        super._init_(iScope);
        return this;
    }

    @Override
    protected boolean automaticallyCreateFirstSimulation() {
        return false;
    }

    @Override
    public void reset() {
        SimulationPopulation simulationPopulation = this.getSimulationPopulation();
        boolean bl = simulationPopulation != null && !simulationPopulation.isEmpty();
        try {
            if (bl) {
                IAgent[] iAgentArray = simulationPopulation.toArray();
                int n = iAgentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAgent iAgent = iAgentArray[n2];
                    this.manageOutputAndCloseSimulation(iAgent, null, true, true);
                    ++n2;
                }
                simulationPopulation.clear();
            }
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            gamaRuntimeException.addContext("in saving the results of the batch");
            GAMA.reportError(this.getScope(), gamaRuntimeException, true);
        }
        int n = this.ownClock.getCycle();
        long l = this.ownClock.getTotalDuration();
        long l2 = this.ownClock.getDuration();
        super.reset();
        this.ownClock.setCycle(n);
        this.ownClock.setTotalDuration(l);
        this.ownClock.setLastDuration(l2);
    }

    private IMap<String, Object> manageOutputAndCloseSimulation(IAgent iAgent, ParametersSet parametersSet, boolean bl, boolean bl2) {
        INamed iNamed;
        IMap iMap = GamaMapFactory.create();
        if (this.getSpecies().getExplorationAlgorithm().isFitnessBased()) {
            iNamed = ((AOptimizationAlgorithm)this.getSpecies().getExplorationAlgorithm()).getFitnessExpression();
            double d = 0.0;
            if (iNamed != null) {
                d = Cast.asFloat(iAgent.getScope(), iNamed.value(iAgent.getScope()));
                if (bl) {
                    this.fitnessValues.add(d);
                }
            }
            iMap.put("fitness", d);
        } else {
            iNamed = (AExplorationAlgorithm)this.getSpecies().getExplorationAlgorithm();
            IExpression iExpression = ((AExplorationAlgorithm)iNamed).getOutputs();
            if (iExpression != null) {
                IList<String> iList = GamaListFactory.create(iAgent.getScope(), (IType)Types.STRING, Cast.asList(iAgent.getScope(), iExpression.value(iAgent.getScope())));
                for (String string : iList) {
                    Object object = iAgent.hasAttribute(string) ? iAgent.getDirectVarValue(this.getScope(), string) : null;
                    this.trackedValues.put(string, object);
                    iMap.put(string, object);
                }
            }
        }
        if (bl2 && iAgent instanceof AbstractAgent) {
            iNamed = (AbstractAgent)iAgent;
            ((AbstractAgent)iNamed).primDie(iAgent.getScope());
        }
        return iMap;
    }

    @Override
    public boolean step(IScope iScope) {
        this.getSpecies().getExplorationAlgorithm().run(iScope);
        iScope.getGui().getStatus().informStatus(this.endStatus(), "status/status.simulation");
        this.getScope().setDisposeStatus();
        GAMA.updateExperimentState(this.getSpecies(), IExperimentStateListener.State.FINISHED);
        return true;
    }

    protected String endStatus() {
        return "Batch over. " + this.runNumber + " runs, " + this.seeds.length + " simulations.";
    }

    public int getRunNumber() {
        return this.runNumber;
    }

    private SimulationAgent createSimulation(Map<String, Object> map, Map<IAgent, ParametersSet> map2) {
        ParametersSet parametersSet = (ParametersSet)map.get("parameters");
        SimulationAgent simulationAgent = this.createSimulation(parametersSet, true);
        simulationAgent.setSeed((Double)map.get("seed"));
        map2.put(simulationAgent, parametersSet);
        return simulationAgent;
    }

    public IMap<ParametersSet, Map<String, List<Object>>> runSimulationsAndReturnResults(List<ParametersSet> list) {
        IMap<ParametersSet, Map<String, List<Object>>> iMap;
        if (GamaExecutorService.shouldRunAllSimulationsInParallel(this)) {
            iMap = this.launchSimulationsInParallelWithParametersSets(list);
        } else {
            iMap = GamaMapFactory.create();
            for (ParametersSet parametersSet : list) {
                iMap.put(parametersSet, this.launchSimulationsWithSingleParametersSet(parametersSet));
            }
        }
        return iMap;
    }

    private IMap<ParametersSet, Map<String, List<Object>>> launchSimulationsInParallelWithParametersSets(List<ParametersSet> list) throws GamaRuntimeException {
        Object object2;
        int n;
        SimulationPopulation simulationPopulation = this.getSimulationPopulation();
        IMap iMap = GamaMapFactory.create();
        if (simulationPopulation == null) {
            return iMap;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = simulationPopulation.getMaxNumberOfConcurrentSimulations();
        if (n2 == 0) {
            n2 = 1;
        }
        for (ParametersSet parametersSet2 : list) {
            n = 0;
            while (n < this.getSeeds().length) {
                ++this.runNumber;
                object2 = new HashMap();
                object2.put("parameters", parametersSet2);
                object2.put("seed", this.getSeeds()[n]);
                arrayList.add(object2);
                ++n;
            }
        }
        int n3 = Math.min(arrayList.size(), n2);
        Vector vector = new Vector();
        n = 0;
        while (n < n3) {
            vector.add((Map)arrayList.remove(0));
            ++n;
        }
        IMap iMap2 = GamaMapFactory.create();
        object2 = vector.iterator();
        while (object2.hasNext()) {
            this.createSimulation((Map)object2.next(), iMap2);
        }
        while (simulationPopulation.hasScheduledSimulations() && !this.dead) {
            simulationPopulation.step(this.getScope());
            for (SimulationAgent iNamed : new ArrayList<SimulationAgent>(simulationPopulation.getRunningSimulations())) {
                boolean bl;
                ParametersSet parametersSet3 = (ParametersSet)iMap2.get(iNamed);
                this.currentSolution = new ParametersSet(parametersSet3);
                boolean bl2 = this.dead || Cast.asBool(iNamed.getScope(), iNamed.getScope().evaluate(this.stopCondition, iNamed).getValue()) != false;
                boolean bl3 = bl = bl2 || iNamed.dead();
                if (!bl) continue;
                simulationPopulation.unscheduleSimulation(iNamed);
                IMap<String, Object> iMap3 = this.manageOutputAndCloseSimulation(iNamed, parametersSet3, false, this.simDispose);
                if (!iMap.containsKey(parametersSet3)) {
                    iMap.put(parametersSet3, GamaMapFactory.create());
                }
                iMap3.forEach((string, object) -> {
                    if (!((Map)iMap.get(parametersSet)).containsKey(string)) {
                        ((Map)iMap.get(parametersSet)).put(string, GamaListFactory.create());
                    }
                    ((List)((Map)iMap.get(parametersSet)).get(string)).add(object);
                });
                if (arrayList.isEmpty()) continue;
                this.createSimulation((Map)arrayList.remove(0), iMap2);
            }
            if (!this.dead) {
                this.informStatus(simulationPopulation, arrayList.size());
            }
            while (this.getSpecies().getController().isPaused() && !this.dead) {
                THREADS.WAIT((long)100L, (String[])new String[0]);
            }
        }
        super.step(this.getScope());
        if (this.dead) {
            return iMap;
        }
        this.reset();
        if (this.getSpecies().getExplorationAlgorithm().isFitnessBased()) {
            AOptimizationAlgorithm aOptimizationAlgorithm = (AOptimizationAlgorithm)this.getSpecies().getExplorationAlgorithm();
            short s = aOptimizationAlgorithm.getCombination();
            iMap.forEach((parametersSet, map) -> {
                this.lastSolution = parametersSet;
                Throwable throwable = null;
                Object var6_7 = null;
                try (DoubleStream doubleStream = ((List)map.get("fitness")).stream().mapToDouble(object -> Double.parseDouble(object.toString()));){
                    this.lastFitness = s == 0 ? doubleStream.max().getAsDouble() : (s == 1 ? doubleStream.min().getAsDouble() : doubleStream.average().getAsDouble());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                map.put("fitness", Collections.singletonList(this.lastFitness));
                aOptimizationAlgorithm.updateBestFitness(this.lastSolution, this.lastFitness);
            });
        }
        this.getScope().getGui().updateParameters();
        return iMap;
    }

    public Map<String, List<Object>> launchSimulationsWithSingleParametersSet(ParametersSet parametersSet) throws GamaRuntimeException {
        int n;
        INamed iNamed;
        SimulationPopulation simulationPopulation = this.getSimulationPopulation();
        IMap iMap = GamaMapFactory.create();
        if (simulationPopulation == null) {
            return iMap;
        }
        this.currentSolution = new ParametersSet(parametersSet);
        this.fitnessValues.clear();
        for (Map.Entry entry : parametersSet.entrySet()) {
            iNamed = this.getSpecies().getExplorableParameters().get(entry.getKey());
            if (iNamed == null) continue;
            iNamed.setValue(this.getScope(), entry.getValue());
        }
        this.getScope().getGui().updateParameters();
        int n2 = simulationPopulation.getMaxNumberOfConcurrentSimulations();
        if (n2 == 0) {
            n2 = 1;
        }
        int n3 = 0;
        while (n3 < this.getSeeds().length && !this.dead) {
            int n4 = 0;
            while (n4 < n2) {
                ++this.runNumber;
                this.setSeed(this.getSeeds()[n3]);
                this.createSimulation(this.currentSolution, true);
                if (++n3 == this.getSeeds().length || this.dead) break;
                ++n4;
            }
            while (simulationPopulation.hasScheduledSimulations() && !this.dead) {
                simulationPopulation.step(this.getScope());
                IAgent[] iAgentArray = simulationPopulation.toArray();
                int n5 = iAgentArray.length;
                n = 0;
                while (n < n5) {
                    boolean bl;
                    IAgent iAgent = iAgentArray[n];
                    SimulationAgent simulationAgent = (SimulationAgent)iAgent;
                    boolean bl2 = this.dead || Cast.asBool(iAgent.getScope(), iAgent.getScope().evaluate(this.stopCondition, iAgent).getValue()) != false;
                    boolean bl3 = bl = bl2 || simulationAgent.dead();
                    if (bl) {
                        simulationPopulation.unscheduleSimulation(simulationAgent);
                        IMap<String, Object> iMap2 = this.manageOutputAndCloseSimulation(simulationAgent, this.currentSolution, true, this.simDispose);
                        iMap2.forEach((string, object) -> {
                            if (!iMap.containsKey(string)) {
                                iMap.put(string, GamaListFactory.create());
                            }
                            ((List)iMap.get(string)).add(object);
                        });
                    }
                    ++n;
                }
                if (!this.dead) {
                    this.informStatus(simulationPopulation, n3);
                }
                while (this.getSpecies().getController().isPaused() && !this.dead) {
                    THREADS.WAIT((long)10L, (String[])new String[0]);
                }
            }
        }
        super.step(this.getScope());
        if (this.dead) {
            return iMap;
        }
        this.reset();
        if (this.getSpecies().getExplorationAlgorithm().isFitnessBased()) {
            iNamed = (AOptimizationAlgorithm)this.getSpecies().getExplorationAlgorithm();
            n = ((AOptimizationAlgorithm)iNamed).getCombination();
            this.lastSolution = this.currentSolution;
            this.lastFitness = n == 0 ? Collections.max(this.fitnessValues) : (n == 1 ? Collections.min(this.fitnessValues) : Double.valueOf(Statistics.calculateMean(this.fitnessValues)));
            iMap.put("fitness", GamaListFactory.createWithoutCasting((IType)Types.FLOAT, this.lastFitness));
            ((AOptimizationAlgorithm)iNamed).updateBestFitness(this.lastSolution, this.lastFitness);
        }
        this.getScope().getGui().updateParameters();
        return iMap;
    }

    private void informStatus(SimulationPopulation simulationPopulation, int n) {
        this.getScope().getGui().getStatus().setStatus("Run " + this.runNumber + " | " + n + "/" + this.seeds.length + " simulations (using " + simulationPopulation.getNumberOfActiveThreads() + " threads)", "status/status.simulation", null);
        this.getScope().getGui().getStatus().updateExperimentStatus();
    }

    public List<IParameter.Batch> getParametersToExplore() {
        return new ArrayList<IParameter.Batch>(this.getSpecies().getExplorableParameters().values());
    }

    @Override
    public List<? extends IParameter.Batch> getDefaultParameters() {
        List<IParameter.Batch> list = super.getDefaultParameters();
        for (IVariable iVariable : this.getModel().getVars()) {
            ExperimentParameter experimentParameter;
            if (!iVariable.isParameter() || this.getSpecies().getExplorableParameters().containsKey(iVariable.getName()) || !(experimentParameter = new ExperimentParameter(this.getScope(), iVariable)).canBeExplored()) continue;
            experimentParameter.setEditable(false);
            experimentParameter.setCategory("Parameters to explore");
            list.add(experimentParameter);
        }
        this.addSpecificParameters(list);
        return list;
    }

    public void addSpecificParameters(List<IParameter.Batch> list) {
        list.add(new ParameterAdapter("Stop condition", BATCH_EXPERIMENT, 4){

            @Override
            public Object value() {
                return BatchAgent.this.stopCondition != null ? BatchAgent.this.stopCondition.serializeToGaml(false) : "none";
            }
        });
        this.getSpecies().getExplorationAlgorithm().addParametersTo(list, this);
    }

    public Double[] getSeeds() {
        return this.seeds;
    }

    public void setSeeds(Double[] doubleArray) {
        this.seeds = doubleArray;
    }

    public ParametersSet getLatestSolution() {
        return this.lastSolution;
    }

    public void setKeepSimulations(boolean bl) {
        this.simDispose = !bl;
    }

    @Override
    public void closeSimulations(boolean bl) {
        if (this.getSimulation() != null) {
            this.getSimulation().getScope().setDisposeStatus();
        }
    }
}

