/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.display;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.ILayer;
import gama.core.common.util.RandomUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.LayeredDisplayData;
import gama.core.outputs.layers.OverlayLayer;
import gama.core.runtime.GAMA;
import gama.dev.DEBUG;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.locationtech.jts.geom.Envelope;

public abstract class AbstractDisplayGraphics
implements IGraphics {
    private static GraphicsConfiguration cachedGC;
    protected final Rectangle2D rect = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    protected static final GamaPoint origin;
    protected double currentLayerAlpha = 1.0;
    public LayeredDisplayData data;
    protected IDisplaySurface surface;
    public boolean highlight = false;
    private final RandomUtils random = new RandomUtils();
    protected ILayer currentLayer;

    static {
        origin = new GamaPoint(0.0, 0.0);
    }

    public static GraphicsConfiguration getCachedGC() {
        if (cachedGC == null) {
            DEBUG.OUT((Object)"Creating cached Graphics Configuration");
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            DEBUG.OUT((Object)"Local Graphics Environment selected");
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            DEBUG.OUT((Object)"Default Graphics Device selected");
            cachedGC = graphicsDevice.getDefaultConfiguration();
            DEBUG.OUT((Object)"Default Graphics Configuration selected");
        }
        return cachedGC;
    }

    public static BufferedImage createCompatibleImage(int n, int n2) {
        BufferedImage bufferedImage = null;
        bufferedImage = GAMA.isInHeadLessMode() || GraphicsEnvironment.isHeadless() ? new BufferedImage(n > 0 ? n : 1024, n2 > 0 ? n2 : 1024, 2) : AbstractDisplayGraphics.getCachedGC().createCompatibleImage(n, n2);
        return bufferedImage;
    }

    public static BufferedImage toCompatibleImage(BufferedImage bufferedImage) {
        if (GAMA.isInHeadLessMode() || GraphicsEnvironment.isHeadless() || bufferedImage.getColorModel().equals(AbstractDisplayGraphics.getCachedGC().getColorModel())) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = AbstractDisplayGraphics.getCachedGC().createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getTransparency());
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    @Override
    public void setDisplaySurface(IDisplaySurface iDisplaySurface) {
        this.surface = iDisplaySurface;
        this.data = iDisplaySurface.getData();
    }

    @Override
    public boolean isNotReadyToUpdate() {
        return this.surface.isDisposed();
    }

    @Override
    public void dispose() {
        this.currentLayer = null;
    }

    @Override
    public void beginHighlight() {
        this.highlight = true;
    }

    @Override
    public void endHighlight() {
        this.highlight = false;
    }

    @Override
    public void setAlpha(double d) {
        this.currentLayerAlpha = d;
    }

    protected final double xFromModelUnitsToPixels(double d) {
        return this.getXOffsetInPixels() + this.getxRatioBetweenPixelsAndModelUnits() * d;
    }

    protected final double yFromModelUnitsToPixels(double d) {
        return this.getYOffsetInPixels() + this.getyRatioBetweenPixelsAndModelUnits() * d;
    }

    @Override
    public double getAbsoluteRatioBetweenPixelsAndModelsUnits() {
        return Math.min(this.getyRatioBetweenPixelsAndModelUnits(), this.getxRatioBetweenPixelsAndModelUnits());
    }

    protected final double wFromModelUnitsToPixels(double d) {
        return this.getxRatioBetweenPixelsAndModelUnits() * d;
    }

    protected final double hFromModelUnitsToPixels(double d) {
        return this.getyRatioBetweenPixelsAndModelUnits() * d;
    }

    @Override
    public double getxRatioBetweenPixelsAndModelUnits() {
        if (this.currentLayer == null) {
            return (double)this.getDisplayWidth() / this.data.getEnvWidth();
        }
        return (double)this.currentLayer.getData().getSizeInPixels().x / this.data.getEnvWidth();
    }

    @Override
    public double getyRatioBetweenPixelsAndModelUnits() {
        if (this.currentLayer == null) {
            return (double)this.getDisplayHeight() / this.data.getEnvHeight();
        }
        if (this.currentLayer instanceof OverlayLayer) {
            return this.getxRatioBetweenPixelsAndModelUnits();
        }
        return (double)this.currentLayer.getData().getSizeInPixels().y / this.data.getEnvHeight();
    }

    @Override
    public double getXOffsetInPixels() {
        return this.currentLayer == null ? AbstractDisplayGraphics.origin.x : this.currentLayer.getData().getPositionInPixels().getX();
    }

    @Override
    public double getYOffsetInPixels() {
        return this.currentLayer == null ? AbstractDisplayGraphics.origin.y : this.currentLayer.getData().getPositionInPixels().getY();
    }

    @Override
    public boolean beginDrawingLayers() {
        return true;
    }

    @Override
    public void beginOverlay(OverlayLayer overlayLayer) {
    }

    @Override
    public void endOverlay() {
    }

    @Override
    public void beginDrawingLayer(ILayer iLayer) {
        this.currentLayer = iLayer;
    }

    @Override
    public void endDrawingLayer(ILayer iLayer) {
        this.currentLayer = null;
    }

    @Override
    public void endDrawingLayers() {
    }

    @Override
    public Double getZoomLevel() {
        return this.data.getZoomLevel();
    }

    @Override
    public IDisplaySurface getSurface() {
        return this.surface;
    }

    @Override
    public int getViewWidth() {
        return this.surface.getWidth();
    }

    @Override
    public int getViewHeight() {
        return this.surface.getHeight();
    }

    @Override
    public int getDisplayWidth() {
        return (int)this.surface.getDisplayWidth();
    }

    @Override
    public int getDisplayHeight() {
        return (int)this.surface.getDisplayHeight();
    }

    public int getLayerWidth() {
        return this.currentLayer == null ? this.getDisplayWidth() : this.currentLayer.getData().getSizeInPixels().x;
    }

    public int getLayerHeight() {
        return this.currentLayer == null ? this.getDisplayHeight() : this.currentLayer.getData().getSizeInPixels().y;
    }

    @Override
    public Envelope getVisibleRegion() {
        return this.surface.getVisibleRegionForLayer(this.currentLayer);
    }

    @Override
    public RandomUtils getRandom() {
        return this.random;
    }
}

