/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.ILayer;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.layers.AgentLayer;
import gama.core.outputs.layers.GridLayerData;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.gaml.operators.Cast;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.draw.ShapeDrawingAttributes;
import java.awt.geom.Rectangle2D;

public class GridAgentLayer
extends AgentLayer
implements ILayer.IGridLayer {
    public GridAgentLayer(ILayerStatement iLayerStatement) {
        super(iLayerStatement);
    }

    @Override
    public GridLayerData createData() {
        return new GridLayerData(this.definition);
    }

    @Override
    public GridLayerData getData() {
        return (GridLayerData)super.getData();
    }

    @Override
    public void privateDraw(IScope.IGraphicsScope iGraphicsScope, IGraphics iGraphics) throws GamaRuntimeException {
        GamaColor gamaColor = this.getData().drawLines() ? this.getData().getLineColor() : null;
        IExecutable iExecutable = iScope -> {
            IScope.IGraphicsScope iGraphicsScope = (IScope.IGraphicsScope)iScope;
            IAgent iAgent = iGraphicsScope.getAgent();
            IGraphics iGraphics = iGraphicsScope.getGraphics();
            try {
                if (iAgent == iGraphicsScope.getGui().getHighlightedAgent()) {
                    iGraphics.beginHighlight();
                }
                GamaColor gamaColor2 = Cast.asColor(iGraphicsScope, iAgent.getDirectVarValue(iGraphicsScope, "color"));
                IShape iShape = iAgent.getGeometry();
                IShape iShape2 = iShape.copy(iGraphicsScope);
                ShapeDrawingAttributes shapeDrawingAttributes = new ShapeDrawingAttributes(iShape2, iAgent, gamaColor2, gamaColor);
                Rectangle2D rectangle2D = iGraphics.drawShape(iShape2.getInnerGeometry(), shapeDrawingAttributes);
                return rectangle2D;
            }
            catch (GamaRuntimeException gamaRuntimeException) {
                gamaRuntimeException.printStackTrace();
            }
            finally {
                iGraphics.endHighlight();
            }
            return null;
        };
        for (IAgent iAgent : this.getData().getGrid().getAgents()) {
            ExecutionResult executionResult;
            Object object;
            if (iAgent == null || !((object = (executionResult = iGraphicsScope.execute(iExecutable, iAgent, null)).getValue()) instanceof Rectangle2D)) continue;
            this.shapes.put(iAgent, (Rectangle2D)object);
        }
    }

    @Override
    public String getType() {
        return "Grid layer";
    }
}

