/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.charts;

import gama.dev.DEBUG;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ChartHistory {
    static final int MAX = 5000000;
    public StringBuilder current = new StringBuilder(5000000);
    List<byte[]> older = new ArrayList<byte[]>();
    final char[] buffer = new char[4096];

    public void append(String string) {
        this.current.append(string);
        this.verifyOverflow();
    }

    private void verifyOverflow() {
        if (this.current.length() > 5000000) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                    gZIPOutputStream.write(this.current.toString().getBytes(StandardCharsets.US_ASCII));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            this.older.add(byteArrayOutputStream.toByteArray());
            DEBUG.ERR((Object)("Chart history limit reached (compressing " + this.current.toString().getBytes().length + " bytes into " + this.older.get(this.older.size() - 1).length + " bytes)"));
            this.current.setLength(0);
        }
    }

    public void writeTo(BufferedWriter bufferedWriter) throws IOException {
        for (byte[] byArray : this.older) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStreamReader inputStreamReader = new InputStreamReader(new GZIPInputStream(new ByteArrayInputStream(byArray)));){
                int n = 0;
                while (-1 != (n = inputStreamReader.read(this.buffer))) {
                    bufferedWriter.write(this.buffer, 0, n);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        bufferedWriter.append(this.current);
    }
}

