/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.charts;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.outputs.layers.charts.ChartDataSeries;
import gama.core.outputs.layers.charts.ChartDataSource;
import gama.core.outputs.layers.charts.ChartJFreeChartOutput;
import gama.core.runtime.IScope;
import gama.gaml.expressions.IExpression;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.MatrixSeries;
import org.jfree.data.xy.MatrixSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class ChartJFreeChartOutputHeatmap
extends ChartJFreeChartOutput {
    public ChartJFreeChartOutputHeatmap(IScope iScope, String string, IExpression iExpression) {
        super(iScope, string, iExpression);
    }

    @Override
    public void createChart(IScope iScope) {
        super.createChart(iScope);
        this.jfreedataset.add(0, new MatrixSeriesCollection());
        PlotOrientation plotOrientation = PlotOrientation.VERTICAL;
        if (this.reverse_axes) {
            plotOrientation = PlotOrientation.HORIZONTAL;
        }
        this.chart = ChartFactory.createXYLineChart((String)this.getName(), (String)"", (String)"", (XYDataset)((MatrixSeriesCollection)this.jfreedataset.get(0)), (PlotOrientation)plotOrientation, (boolean)true, (boolean)false, (boolean)false);
    }

    @Override
    public void setDefaultPropertiesFromType(IScope iScope, ChartDataSource chartDataSource, int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                chartDataSource.setCumulative(iScope, false);
                chartDataSource.setCumulativeY(iScope, true);
                chartDataSource.setUseSize(iScope, true);
                break;
            }
            default: {
                chartDataSource.setCumulative(iScope, false);
                chartDataSource.setUseSize(iScope, true);
            }
        }
    }

    @Override
    public void initdataset() {
        super.initdataset();
        this.chartdataset.setCommonXSeries(true);
        this.chartdataset.setCommonYSeries(true);
        this.chartdataset.setByCategory(false);
        this.chartdataset.forceNoXAccumulate = true;
        this.chartdataset.forceNoYAccumulate = true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected AbstractRenderer createRenderer(IScope var1_1, String var2_2) {
        var5_4 = var3_3 = this.getChartdataset().getDataSeries(var1_1, var2_2).getStyle(var1_1);
        tmp = -1;
        switch (var5_4.hashCode()) {
            case -1928911965: {
                if (var5_4.equals("exploded")) {
                    tmp = 1;
                }
                break;
            }
            case -895858735: {
                if (var5_4.equals("spline")) {
                    tmp = 1;
                }
                break;
            }
            case 1681: {
                if (var5_4.equals("3d")) {
                    tmp = 1;
                }
                break;
            }
            case 97299: {
                if (var5_4.equals("bar")) {
                    tmp = 1;
                }
                break;
            }
            case 99657: {
                if (var5_4.equals("dot")) {
                    tmp = 1;
                }
                break;
            }
            case 3002509: {
                if (var5_4.equals("area")) {
                    tmp = 1;
                }
                break;
            }
            case 3500592: {
                if (var5_4.equals("ring")) {
                    tmp = 1;
                }
                break;
            }
            case 3540684: {
                if (var5_4.equals("step")) {
                    tmp = 1;
                }
                break;
            }
            case 109757064: {
                if (var5_4.equals("stack")) {
                    tmp = 1;
                }
                break;
            }
            case 1316689085: {
                if (!var5_4.equals("whisker")) break;
                tmp = 1;
                break;
            }
        }
        ** switch (tmp)
lbl56:
        // 2 sources

        var4_5 = new XYBlockRenderer();
        return var4_5;
    }

    protected static final LookupPaintScale createLUT(int n, float f, float f2, Color color, Color color2, Color color3) {
        float[][] fArrayArray = new float[][]{{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f}, {(float)color2.getRed() / 255.0f, (float)color2.getGreen() / 255.0f, (float)color2.getBlue() / 255.0f, (float)color2.getAlpha() / 255.0f}, {(float)color3.getRed() / 255.0f, (float)color3.getGreen() / 255.0f, (float)color3.getBlue() / 255.0f, (float)color3.getAlpha() / 255.0f}};
        float[] fArray = new float[]{0.0f, 0.5f, 1.0f};
        if (f >= f2) {
            return new LookupPaintScale();
        }
        LookupPaintScale lookupPaintScale = new LookupPaintScale((double)f, (double)f2, (Paint)color2);
        int n2 = 0;
        while (n2 < n) {
            float f3 = (float)n2 / ((float)n - 0.99f);
            int n3 = 0;
            n3 = 0;
            while (n3 < fArray.length) {
                if (f3 < fArray[n3]) break;
                ++n3;
            }
            float f4 = fArrayArray[--n3][0] + (f3 - fArray[n3]) / (fArray[n3 + 1] - fArray[n3]) * (fArrayArray[n3 + 1][0] - fArrayArray[n3][0]);
            float f5 = fArrayArray[n3][1] + (f3 - fArray[n3]) / (fArray[n3 + 1] - fArray[n3]) * (fArrayArray[n3 + 1][1] - fArrayArray[n3][1]);
            float f6 = fArrayArray[n3][2] + (f3 - fArray[n3]) / (fArray[n3 + 1] - fArray[n3]) * (fArrayArray[n3 + 1][2] - fArrayArray[n3][2]);
            float f7 = fArrayArray[n3][3] + (f3 - fArray[n3]) / (fArray[n3 + 1] - fArray[n3]) * (fArrayArray[n3 + 1][3] - fArrayArray[n3][3]);
            lookupPaintScale.add((double)(f3 * (f2 - f) + f), (Paint)new Color(f4, f5, f6, f7));
            ++n2;
        }
        return lookupPaintScale;
    }

    protected static final LookupPaintScale createLUT(int n, float f, float f2, Color color, Color color2) {
        float[][] fArrayArray = new float[][]{{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f}, {(float)color2.getRed() / 255.0f, (float)color2.getGreen() / 255.0f, (float)color2.getBlue() / 255.0f, (float)color2.getAlpha() / 255.0f}};
        float[] fArray = new float[]{0.0f, 1.0f};
        if (f >= f2) {
            return new LookupPaintScale();
        }
        LookupPaintScale lookupPaintScale = new LookupPaintScale((double)f, (double)f2, (Paint)color);
        int n2 = 0;
        while (n2 < n) {
            float f3 = (float)n2 / ((float)n - 0.99f);
            float f4 = fArrayArray[0][0] + (f3 - fArray[0]) / (fArray[1] - fArray[0]) * (fArrayArray[1][0] - fArrayArray[0][0]);
            float f5 = fArrayArray[0][1] + (f3 - fArray[0]) / (fArray[1] - fArray[0]) * (fArrayArray[1][1] - fArrayArray[0][1]);
            float f6 = fArrayArray[0][2] + (f3 - fArray[0]) / (fArray[1] - fArray[0]) * (fArrayArray[1][2] - fArrayArray[0][2]);
            float f7 = fArrayArray[0][3] + (f3 - fArray[0]) / (fArray[1] - fArray[0]) * (fArrayArray[1][3] - fArrayArray[0][3]);
            lookupPaintScale.add((double)(f3 * (f2 - f) + f), (Paint)new Color(f4, f5, f6, f7));
            ++n2;
        }
        return lookupPaintScale;
    }

    protected void resetRenderer(IScope iScope, String string) {
        XYBlockRenderer xYBlockRenderer = (XYBlockRenderer)this.getOrCreateRenderer(iScope, string);
        ChartDataSeries chartDataSeries = this.getChartdataset().getDataSeries(iScope, string);
        if (chartDataSeries.getMycolor() != null) {
            xYBlockRenderer.setSeriesPaint(0, (Paint)chartDataSeries.getMycolor());
        }
        if (chartDataSeries.getSValues(iScope).size() > 0) {
            double d = Collections.max(chartDataSeries.getSValues(iScope));
            double d2 = Collections.min(chartDataSeries.getSValues(iScope));
            Color color = new Color(0, 0, 0, 0);
            if (chartDataSeries.getMyMincolor() != null) {
                color = chartDataSeries.getMyMincolor();
            }
            Color color2 = new Color(0.9f, 0.9f, 0.9f, 1.0f);
            if (chartDataSeries.getMycolor() != null) {
                color2 = chartDataSeries.getMycolor();
            }
            LookupPaintScale lookupPaintScale = ChartJFreeChartOutputHeatmap.createLUT(100, (float)d2, (float)d, color, color2);
            if (chartDataSeries.getMyMedcolor() != null) {
                lookupPaintScale = ChartJFreeChartOutputHeatmap.createLUT(100, (float)d2, (float)d, color, chartDataSeries.getMyMedcolor(), color2);
            }
            xYBlockRenderer.setPaintScale((PaintScale)lookupPaintScale);
            NumberAxis numberAxis = new NumberAxis(chartDataSeries.getName());
            numberAxis.setAxisLinePaint((Paint)this.axesColor);
            numberAxis.setTickMarkPaint((Paint)this.axesColor);
            numberAxis.setTickLabelFont(this.getTickFont());
            numberAxis.setRange(lookupPaintScale.getLowerBound(), lookupPaintScale.getUpperBound());
            numberAxis.setAxisLinePaint((Paint)this.axesColor);
            numberAxis.setLabelFont(this.getLabelFont());
            if (this.textColor != null) {
                numberAxis.setLabelPaint((Paint)this.textColor);
                numberAxis.setTickLabelPaint((Paint)this.textColor);
            }
            if (!this.getXTickValueVisible(iScope)) {
                numberAxis.setTickMarksVisible(false);
                numberAxis.setTickLabelsVisible(false);
            }
            PaintScaleLegend paintScaleLegend = new PaintScaleLegend((PaintScale)lookupPaintScale, (ValueAxis)numberAxis);
            paintScaleLegend.setAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
            paintScaleLegend.setAxisOffset(5.0);
            paintScaleLegend.setPosition(RectangleEdge.RIGHT);
            paintScaleLegend.setBackgroundPaint((Paint)this.backgroundColor);
            if (!"none".equals(this.series_label_position)) {
                this.chart.addSubtitle((Title)paintScaleLegend);
            }
        }
    }

    @Override
    protected void clearDataSet(IScope iScope) {
        super.clearDataSet(iScope);
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        int n = xYPlot.getDatasetCount() - 1;
        while (n >= 1) {
            xYPlot.setDataset(n, null);
            xYPlot.setRenderer(n, null);
            --n;
        }
        ((MatrixSeriesCollection)this.jfreedataset.get(0)).removeAllSeries();
        this.jfreedataset.clear();
        this.jfreedataset.add(0, new MatrixSeriesCollection());
        xYPlot.setDataset((XYDataset)((MatrixSeriesCollection)this.jfreedataset.get(0)));
        xYPlot.setRenderer(0, null);
        this.idPosition.clear();
    }

    @Override
    protected void createNewSerie(IScope iScope, String string) {
        ChartDataSeries chartDataSeries = this.chartdataset.getDataSeries(iScope, string);
        MatrixSeries matrixSeries = new MatrixSeries((String)((Object)chartDataSeries.getSerieLegend(iScope)), Math.max(1, this.getChartdataset().getYSeriesValues().size()), Math.max(1, this.getChartdataset().getXSeriesValues().size()));
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        MatrixSeriesCollection matrixSeriesCollection = (MatrixSeriesCollection)xYPlot.getDataset();
        if (!this.idPosition.containsKey(string)) {
            if (matrixSeriesCollection.getSeriesCount() == 0) {
                matrixSeriesCollection.addSeries(matrixSeries);
                xYPlot.setDataset(0, (XYDataset)matrixSeriesCollection);
            } else {
                MatrixSeriesCollection matrixSeriesCollection2 = new MatrixSeriesCollection();
                matrixSeriesCollection2.addSeries(matrixSeries);
                this.jfreedataset.add(matrixSeriesCollection2);
                xYPlot.setDataset(this.jfreedataset.size() - 1, (XYDataset)matrixSeriesCollection2);
            }
            xYPlot.setRenderer(this.jfreedataset.size() - 1, (XYItemRenderer)this.getOrCreateRenderer(iScope, string));
            this.idPosition.put(string, this.jfreedataset.size() - 1);
        }
    }

    @Override
    public void preResetSeries(IScope iScope) {
        this.clearDataSet(iScope);
        ArrayList arrayList = new ArrayList();
        this.chart.setSubtitles(arrayList);
    }

    @Override
    protected void resetSerie(IScope iScope, String string) {
        this.createNewSerie(iScope, string);
        ChartDataSeries chartDataSeries = this.chartdataset.getDataSeries(iScope, string);
        MatrixSeries matrixSeries = ((MatrixSeriesCollection)this.jfreedataset.get((Integer)this.idPosition.get(chartDataSeries.getSerieId(iScope)))).getSeries(0);
        ArrayList<Double> arrayList = chartDataSeries.getXValues(iScope);
        ArrayList<Double> arrayList2 = chartDataSeries.getYValues(iScope);
        ArrayList<Double> arrayList3 = chartDataSeries.getSValues(iScope);
        NumberAxis numberAxis = (NumberAxis)((XYPlot)this.chart.getPlot()).getDomainAxis();
        if (arrayList.size() == 0 && !this.usexrangeinterval && !this.usexrangeminmax) {
            numberAxis.setAutoRange(false);
            numberAxis.setRange(-0.5, (double)arrayList.size() + 0.5);
        }
        NumberAxis numberAxis2 = (NumberAxis)((XYPlot)this.chart.getPlot()).getRangeAxis();
        if (arrayList2.size() == 0 && !this.useyrangeinterval && !this.useyrangeminmax) {
            numberAxis2.setAutoRange(false);
            numberAxis2.setRange(-0.5, (double)arrayList2.size() + 0.5);
        }
        if (arrayList.size() > 0) {
            numberAxis.setAutoRange(false);
            numberAxis2.setAutoRange(false);
            numberAxis.setTickLabelsVisible(this.getXTickValueVisible(iScope));
            numberAxis.setTickMarksVisible(this.getXTickValueVisible(iScope));
            numberAxis2.setTickLabelsVisible(this.getYTickValueVisible(iScope));
            numberAxis2.setTickMarksVisible(this.getYTickValueVisible(iScope));
            int n = 0;
            while (n < arrayList.size()) {
                if (arrayList.get(n) > numberAxis.getUpperBound() && !this.usexrangeinterval && !this.usexrangeminmax) {
                    numberAxis.setAutoRange(false);
                    numberAxis.setRange(-0.5, arrayList2.get(n) + 0.5);
                }
                if (arrayList2.get(n) > numberAxis2.getUpperBound() && !this.useyrangeinterval && !this.useyrangeminmax) {
                    numberAxis2.setAutoRange(false);
                    numberAxis2.setRange(-0.5, arrayList2.get(n) + 0.5);
                }
                matrixSeries.update(arrayList2.get(n).intValue(), arrayList.get(n).intValue(), arrayList3.get(n).doubleValue());
                ++n;
            }
        }
        this.resetRenderer(iScope, string);
    }

    @Override
    public void resetAxes(IScope iScope) {
        LogarithmicAxis logarithmicAxis;
        NumberAxis numberAxis = (NumberAxis)((XYPlot)this.chart.getPlot()).getDomainAxis();
        NumberAxis numberAxis2 = (NumberAxis)((XYPlot)this.chart.getPlot()).getRangeAxis();
        if (this.getX_LogScale(iScope)) {
            logarithmicAxis = new LogarithmicAxis(numberAxis.getLabel());
            logarithmicAxis.setAllowNegativesFlag(true);
            ((XYPlot)this.chart.getPlot()).setDomainAxis((ValueAxis)logarithmicAxis);
            numberAxis = logarithmicAxis;
        }
        if (this.getY_LogScale(iScope)) {
            logarithmicAxis = new LogarithmicAxis(numberAxis2.getLabel());
            logarithmicAxis.setAllowNegativesFlag(true);
            ((XYPlot)this.chart.getPlot()).setRangeAxis((ValueAxis)logarithmicAxis);
            numberAxis2 = logarithmicAxis;
        }
        if (!this.usexrangeinterval) {
            // empty if block
        }
        if (this.usexrangeinterval) {
            numberAxis.setFixedAutoRange(this.xrangeinterval);
            numberAxis.setAutoRangeMinimumSize(this.xrangeinterval);
            numberAxis.setAutoRange(true);
        }
        if (this.usexrangeminmax) {
            numberAxis.setRange(this.xrangemin, this.xrangemax);
        }
        if (!this.useyrangeinterval) {
            // empty if block
        }
        if (this.useyrangeinterval) {
            numberAxis2.setFixedAutoRange(this.yrangeinterval);
            numberAxis2.setAutoRangeMinimumSize(this.yrangeinterval);
            numberAxis2.setAutoRange(true);
        }
        if (this.useyrangeminmax) {
            numberAxis2.setRange(this.yrangemin, this.yrangemax);
        }
        if ("none".equals(this.series_label_position) && this.chart.getLegend() != null) {
            this.chart.getLegend().setVisible(false);
        }
        if (!this.getXTickLineVisible(iScope)) {
            ((XYPlot)this.chart.getPlot()).setDomainGridlinesVisible(false);
        }
        if (!this.getYTickLineVisible(iScope)) {
            ((XYPlot)this.chart.getPlot()).setRangeGridlinesVisible(false);
        }
    }

    @Override
    protected void initRenderer(IScope iScope) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        this.defaultrenderer = new XYBlockRenderer();
        xYPlot.setRenderer((XYItemRenderer)((XYBlockRenderer)this.defaultrenderer));
    }

    @Override
    public void setUseXSource(IScope iScope, IExpression iExpression) {
    }

    @Override
    public void setUseXLabels(IScope iScope, IExpression iExpression) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        ((NumberAxis)xYPlot.getDomainAxis()).setNumberFormatOverride(new NumberFormat(){

            @Override
            public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                int n = ChartJFreeChartOutputHeatmap.this.chartdataset.XSeriesValues.indexOf(d);
                if (n >= 0) {
                    return new StringBuffer(ChartJFreeChartOutputHeatmap.this.chartdataset.Xcategories.get(n));
                }
                return new StringBuffer();
            }

            @Override
            public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                return new StringBuffer("n" + l);
            }

            @Override
            public Number parse(String string, ParsePosition parsePosition) {
                return null;
            }
        });
    }

    @Override
    public void setUseYLabels(IScope iScope, IExpression iExpression) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        ((NumberAxis)xYPlot.getRangeAxis()).setNumberFormatOverride(new NumberFormat(){

            @Override
            public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                int n = ChartJFreeChartOutputHeatmap.this.chartdataset.YSeriesValues.indexOf(d);
                if (n >= 0) {
                    return new StringBuffer(ChartJFreeChartOutputHeatmap.this.chartdataset.Ycategories.get(n));
                }
                return new StringBuffer();
            }

            @Override
            public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                return new StringBuffer("n" + l);
            }

            @Override
            public Number parse(String string, ParsePosition parsePosition) {
                return null;
            }
        });
    }

    @Override
    public void initChart(IScope iScope, String string) {
        super.initChart(iScope, string);
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        xYPlot.setDomainGridlinePaint((Paint)this.axesColor);
        xYPlot.setRangeGridlinePaint((Paint)this.axesColor);
        xYPlot.setDomainCrosshairPaint((Paint)this.axesColor);
        xYPlot.setRangeCrosshairPaint((Paint)this.axesColor);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xYPlot.setDomainCrosshairVisible(false);
        xYPlot.setRangeCrosshairVisible(false);
        xYPlot.setRangeGridlinesVisible(false);
        xYPlot.setDomainGridlinesVisible(false);
        xYPlot.getDomainAxis().setAxisLinePaint((Paint)this.axesColor);
        xYPlot.getDomainAxis().setTickLabelFont(this.getTickFont());
        xYPlot.getDomainAxis().setLabelFont(this.getLabelFont());
        if (this.textColor != null) {
            xYPlot.getDomainAxis().setLabelPaint((Paint)this.textColor);
            xYPlot.getDomainAxis().setTickLabelPaint((Paint)this.textColor);
        }
        if (this.xtickunit > 0.0) {
            ((NumberAxis)xYPlot.getDomainAxis()).setTickUnit(new NumberTickUnit(this.xtickunit));
        }
        xYPlot.getRangeAxis().setAxisLinePaint((Paint)this.axesColor);
        xYPlot.getRangeAxis().setLabelFont(this.getLabelFont());
        xYPlot.getRangeAxis().setTickLabelFont(this.getTickFont());
        if (this.textColor != null) {
            xYPlot.getRangeAxis().setLabelPaint((Paint)this.textColor);
            xYPlot.getRangeAxis().setTickLabelPaint((Paint)this.textColor);
        }
        if (this.ytickunit > 0.0) {
            ((NumberAxis)xYPlot.getRangeAxis()).setTickUnit(new NumberTickUnit(this.ytickunit));
        }
        if (this.xlabel != null && !this.xlabel.isEmpty()) {
            xYPlot.getDomainAxis().setLabel(this.xlabel);
        }
        if (this.ylabel != null && !this.ylabel.isEmpty()) {
            xYPlot.getRangeAxis().setLabel(this.ylabel);
        }
    }

    @Override
    public void getModelCoordinatesInfo(int n, int n2, IDisplaySurface iDisplaySurface, Point point, StringBuilder stringBuilder) {
        int n3 = n - point.x;
        int n4 = n2 - point.y;
        ChartEntity chartEntity = this.info.getEntityCollection().getEntity((double)n3, (double)n4);
        if (chartEntity instanceof XYItemEntity) {
            String string;
            XYItemEntity xYItemEntity = (XYItemEntity)chartEntity;
            XYDataset xYDataset = xYItemEntity.getDataset();
            int n5 = xYItemEntity.getItem();
            int n6 = xYItemEntity.getSeriesIndex();
            double d = xYDataset.getXValue(n6, n5);
            double d2 = xYDataset.getYValue(n6, n5);
            XYPlot xYPlot = (XYPlot)this.getJFChart().getPlot();
            ValueAxis valueAxis = xYPlot.getDomainAxis(n6);
            ValueAxis valueAxis2 = xYPlot.getRangeAxis(n6);
            boolean bl = d % 1.0 == 0.0;
            boolean bl2 = d2 % 1.0 == 0.0;
            String string2 = valueAxis.getLabel();
            if (StringUtils.isBlank((CharSequence)string2)) {
                string2 = "X";
            }
            if (StringUtils.isBlank((CharSequence)(string = valueAxis2.getLabel()))) {
                string = "Y";
            }
            stringBuilder.append(string2).append(" ").append(bl ? Integer.valueOf((int)d) : String.format("%.2f", d));
            stringBuilder.append(" | ").append(string).append(" ").append(bl2 ? Integer.valueOf((int)d2) : String.format("%.2f", d2));
        } else if (chartEntity instanceof PieSectionEntity) {
            int n7;
            PieSectionEntity pieSectionEntity = (PieSectionEntity)chartEntity;
            String string = pieSectionEntity.getSectionKey().toString();
            PieDataset pieDataset = pieSectionEntity.getDataset();
            double d = pieDataset.getValue(n7 = pieSectionEntity.getSectionIndex()).doubleValue();
            boolean bl = d % 1.0 == 0.0;
            stringBuilder.append(string).append(" ").append(bl ? Integer.valueOf((int)d) : String.format("%.2f", d));
        } else if (chartEntity instanceof CategoryItemEntity) {
            Comparable comparable;
            CategoryItemEntity categoryItemEntity = (CategoryItemEntity)chartEntity;
            Comparable comparable2 = categoryItemEntity.getColumnKey();
            String string = comparable2.toString();
            CategoryDataset categoryDataset = categoryItemEntity.getDataset();
            double d = categoryDataset.getValue(comparable = categoryItemEntity.getRowKey(), comparable2).doubleValue();
            boolean bl = d % 1.0 == 0.0;
            stringBuilder.append(string).append(" ").append(bl ? Integer.valueOf((int)d) : String.format("%.2f", d));
        }
    }
}

