/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.properties;

import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.properties.AbstractDefinition;
import gama.core.outputs.layers.properties.CameraStatement;
import gama.core.outputs.layers.properties.GenericCameraDefinition;
import gama.core.outputs.layers.properties.ICameraDefinition;
import gama.core.runtime.GraphicsScope;
import gama.core.runtime.IScope;
import gama.gaml.operators.Cast;
import gama.gaml.statements.draw.AttributeHolder;
import gama.gaml.types.Types;

public class CameraDefinition
extends AbstractDefinition
implements ICameraDefinition {
    GenericCameraDefinition current;
    AttributeHolder.Attribute<Object> locationAttribute = this.create("location", Types.NO_TYPE, null);
    final AttributeHolder.Attribute<Object> initialLocationAttribute = this.locationAttribute;
    AttributeHolder.Attribute<GamaPoint> targetAttribute = this.create("target", Types.POINT, null);
    final AttributeHolder.Attribute<GamaPoint> initialTargetAttribute = this.targetAttribute;
    AttributeHolder.Attribute<Double> distanceAttribute = this.create("distance", Types.FLOAT, null);
    final AttributeHolder.Attribute<Double> initialDistanceAttribute = this.distanceAttribute;
    AttributeHolder.Attribute<Integer> lens = this.create("lens", Types.INT, 45);
    AttributeHolder.Attribute<Boolean> locked = this.create("locked", Types.BOOL, false);

    public CameraDefinition(CameraStatement cameraStatement) {
        super(cameraStatement);
    }

    @Override
    public void reset() {
        this.locationAttribute = this.initialLocationAttribute;
        this.targetAttribute = this.initialTargetAttribute;
        this.distanceAttribute = this.initialDistanceAttribute;
        this.current.reset();
    }

    @Override
    public void update(IScope iScope) {
        GamaPoint gamaPoint;
        Object object;
        boolean bl;
        GamaPoint gamaPoint2 = this.targetAttribute.get();
        if (gamaPoint2 == null) {
            gamaPoint2 = iScope.getSimulation().getCentroid();
        }
        boolean bl2 = bl = (object = this.locationAttribute.get()) == null;
        if (bl) {
            object = GamaPreferences.Displays.OPENGL_DEFAULT_CAM.getValue();
        }
        gamaPoint2 = gamaPoint2.yNegated();
        if (object instanceof String) {
            GraphicsScope graphicsScope;
            String string = (String)object;
            double d = 1.4;
            if (iScope instanceof GraphicsScope && (graphicsScope = (GraphicsScope)iScope).getGraphics() != null) {
                d = graphicsScope.getGraphics().getSurface().getData().getCameraDistanceCoefficient();
            }
            double d2 = iScope.getSimulation().getWidth();
            double d3 = iScope.getSimulation().getHeight();
            double d4 = Math.max(d2, d3) * d;
            gamaPoint = this.computeLocation(string, gamaPoint2, d2, d3, d4);
        } else {
            gamaPoint = Cast.asPoint(iScope, object);
            gamaPoint = gamaPoint.yNegated();
        }
        Double d = this.distanceAttribute.get();
        if (d != null) {
            GamaPoint gamaPoint3 = gamaPoint.minus(gamaPoint2).normalized().times(d);
            gamaPoint = gamaPoint2.plus(gamaPoint3);
        }
        if (this.current == null) {
            this.current = new GenericCameraDefinition(this.getName(), gamaPoint, gamaPoint2);
        } else {
            this.current.setLocation(gamaPoint);
            this.current.setTarget(gamaPoint2);
        }
        if (d != null) {
            this.current.setDistance(d);
        }
    }

    @Override
    public GamaPoint getLocation() {
        return this.current.getLocation();
    }

    @Override
    public boolean setLocation(GamaPoint gamaPoint) {
        if (this.isLocked().booleanValue() || this.isDynamic().booleanValue() || gamaPoint == null) {
            return false;
        }
        this.locationAttribute = new AttributeHolder.ConstantAttribute<GamaPoint>(gamaPoint.yNegated());
        return this.current.setLocation(gamaPoint);
    }

    @Override
    public boolean setTarget(GamaPoint gamaPoint) {
        if (this.isLocked().booleanValue() || this.isDynamic().booleanValue() || gamaPoint == null) {
            return false;
        }
        this.targetAttribute = new AttributeHolder.ConstantAttribute<GamaPoint>(gamaPoint.yNegated());
        return this.current.setTarget(gamaPoint);
    }

    @Override
    public void setLens(Integer n) {
        this.lens = new AttributeHolder.ConstantAttribute<Integer>(n == null ? 45 : n);
    }

    @Override
    public GamaPoint getTarget() {
        return this.current.getTarget();
    }

    @Override
    public Integer getLens() {
        return this.lens.get();
    }

    @Override
    public Boolean isLocked() {
        return this.locked.get();
    }

    @Override
    public void setLocked(Boolean bl) {
        this.locked = new AttributeHolder.ConstantAttribute<Boolean>(bl == null ? false : bl);
    }

    @Override
    public boolean setDistance(Double d) {
        if (this.isLocked().booleanValue() || this.isDynamic().booleanValue() || d == null) {
            return false;
        }
        this.distanceAttribute = new AttributeHolder.ConstantAttribute<Double>(d);
        return this.current.setDistance(d);
    }

    @Override
    public Double getDistance() {
        return this.current.getDistance();
    }

    @Override
    public String getName() {
        return this.symbol.getName();
    }

    @Override
    protected boolean getDefaultDynamicValue() {
        return false;
    }

    @Override
    protected boolean shouldRefresh() {
        return super.shouldRefresh() || this.current == null;
    }
}

