/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.benchmark;

import gama.core.common.interfaces.IBenchmarkable;
import gama.core.common.util.FileUtils;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.benchmark.Benchmark;
import gama.core.runtime.benchmark.BenchmarkRecord;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.core.util.file.csv.CsvWriter;
import gama.core.util.tree.GamaTree;
import gama.gaml.operators.Files;
import gama.gaml.types.Types;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class BenchmarkCSVExporter {
    private static final String exportFolder = "benchmarks";

    public void save(IExperimentPlan iExperimentPlan, Benchmark benchmark) throws GamaRuntimeException {
        IScope iScope2 = iExperimentPlan.getExperimentScope();
        try {
            Files.newFolder(iScope2, exportFolder);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            gamaRuntimeException.addContext("Impossible to create folder benchmarks");
            GAMA.reportError(iScope2, gamaRuntimeException, false);
            gamaRuntimeException.printStackTrace();
            return;
        }
        IMap<IScope, Benchmark.ScopeRecord> iMap = GamaMapFactory.wrap(Types.NO_TYPE, Types.NO_TYPE, benchmark);
        String string = FileUtils.constructAbsoluteFilePath(iScope2, "benchmarks/" + iExperimentPlan.getModel().getName() + "_benchmark_" + Instant.now().toString().replace(':', '_') + ".csv", false);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        arrayList.add("Execution");
        iMap.forEach((iScope, scopeRecord) -> {
            arrayList.add("Time in ms in " + String.valueOf(iScope));
            arrayList.add("Invocations in " + String.valueOf(iScope));
        });
        arrayList2.add(arrayList);
        benchmark.tree.visit(GamaTree.Order.PRE_ORDER, gamaNode -> {
            IBenchmarkable iBenchmarkable = (IBenchmarkable)gamaNode.getData();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList2.add(arrayList);
            arrayList.add(iBenchmarkable.getNameForBenchmarks());
            iMap.forEach((iScope, scopeRecord) -> {
                BenchmarkRecord benchmarkRecord = scopeRecord.find(iBenchmarkable);
                arrayList.add(benchmarkRecord.isUnrecorded() ? "" : String.valueOf(benchmarkRecord.milliseconds));
                arrayList.add(benchmarkRecord.isUnrecorded() ? "" : String.valueOf(benchmarkRecord.times));
            });
        });
        try {
            Throwable throwable = null;
            Object var9_12 = null;
            try (CsvWriter csvWriter = new CsvWriter(string);){
                csvWriter.setDelimiter(';');
                for (List list : arrayList2) {
                    csvWriter.writeRecord(list.toArray(new String[list.size()]));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.create(iOException, iScope2);
        }
    }
}

