/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.core.common.geometry.Envelope3D;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.GamaFile;
import gama.gaml.statements.Facets;
import gama.gaml.types.IContainerType;
import gama.gaml.types.Types;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class GenericFile
extends GamaFile<IList<String>, String> {
    public GenericFile(String string) throws GamaRuntimeException {
        super(GAMA.getRuntimeScope(), string);
    }

    public GenericFile(String string, boolean bl) {
        super(GAMA.getRuntimeScope(), string, bl);
    }

    public GenericFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string, false);
    }

    @Override
    public IContainerType<?> getGamlType() {
        return Types.FILE;
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        return Envelope3D.EMPTY;
    }

    @Override
    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        block14: {
            if (this.getBuffer() != null) {
                return;
            }
            try {
                if (this.isBinaryFile(iScope)) {
                    GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("Problem identifying the contents of " + this.getFile(iScope).getAbsolutePath(), iScope), false);
                    this.setBuffer(GamaListFactory.EMPTY_LIST);
                    break block14;
                }
                Throwable throwable = null;
                Object var3_5 = null;
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getFile(iScope)));){
                    IList iList = GamaListFactory.create(Types.STRING);
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        iList.add(string);
                        string = bufferedReader.readLine();
                    }
                    this.setBuffer(iList);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                throw GamaRuntimeException.create(iOException, iScope);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isBinaryFile(IScope iScope) throws FileNotFoundException, IOException {
        File file2 = this.getFile(iScope);
        if (file2 == null) return false;
        if (!file2.exists()) {
            return false;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream inputStream = Files.newInputStream(file2.toPath(), new OpenOption[0]);){
            boolean bl;
            int n = 0;
            int n2 = 0;
            byte[] byArray = inputStream.readNBytes(Math.min(1024, inputStream.available()));
            int n3 = byArray.length;
            int n4 = 0;
            while (true) {
                if (n4 >= n3) {
                    if (n2 != 0) break;
                    bl = false;
                    return bl;
                }
                byte by = byArray[n4];
                if (by < 9) {
                    return true;
                }
                if (by == 9 || by == 10 || by == 12 || by == 13 || by >= 32 && by <= 126) {
                    ++n;
                } else {
                    ++n2;
                }
                ++n4;
            }
            if (100 * n2 / (n + n2) > 95) {
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    @Override
    protected void flushBuffer(IScope iScope, Facets facets2) throws GamaRuntimeException {
    }
}

