/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IAsset;
import gama.core.common.interfaces.IEnvelopeProvider;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IAddressableContainer;
import gama.core.util.IList;
import gama.core.util.IModifiableContainer;
import gama.gaml.statements.Facets;
import org.eclipse.emf.common.util.URI;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="name", type=4, doc={@GamlAnnotations.doc(value="Returns the name of the receiver file")}), @GamlAnnotations.variable(name="extension", type=4, doc={@GamlAnnotations.doc(value="Returns the extension of the receiver file")}), @GamlAnnotations.variable(name="path", type=4, doc={@GamlAnnotations.doc(value="Returns the absolute path of the receiver file")}), @GamlAnnotations.variable(name="exists", type=3, doc={@GamlAnnotations.doc(value="Returns whether the receiver file exists or not in the filesystem")}), @GamlAnnotations.variable(name="is_folder", type=3, doc={@GamlAnnotations.doc(value="Returns whether the receiver file is a folder or not")}), @GamlAnnotations.variable(name="readable", type=3, doc={@GamlAnnotations.doc(value="Returns true if the contents of the receiver file can be read")}), @GamlAnnotations.variable(name="writable", type=3, doc={@GamlAnnotations.doc(value="Returns true if the contents of the receiver file can be written")}), @GamlAnnotations.variable(name="attributes", type=5, of=4, doc={@GamlAnnotations.doc(value="Retrieves the list of 'attributes' present in the receiver files that support this concept (and an empty list for the others). For instance, in a CSV file, the attributes represent the headers of the columns (if any); in a shape file, the attributes provided to the objects, etc.")}), @GamlAnnotations.variable(name="contents", type=-30, of=-299, index=-399, doc={@GamlAnnotations.doc(value="Returns the contents of the receiver file in the form of a container")})})
public interface IGamaFile<C extends IModifiableContainer, Contents>
extends IAddressableContainer,
IModifiableContainer,
IEnvelopeProvider,
IAsset {
    public static final String KEY_TEMPORARY_OUTPUT = "key_temporary_output";

    public void setWritable(IScope var1, boolean var2);

    public void setContents(C var1) throws GamaRuntimeException;

    @Override
    public IGamaFile copy(IScope var1);

    public C getBuffer();

    @GamlAnnotations.getter(value="exists", initializer=true)
    public Boolean exists(IScope var1);

    @GamlAnnotations.getter(value="extension", initializer=true)
    public String getExtension(IScope var1);

    @GamlAnnotations.getter(value="name", initializer=true)
    public String getName(IScope var1);

    @GamlAnnotations.getter(value="path", initializer=true)
    public String getPath(IScope var1);

    @GamlAnnotations.getter(value="contents")
    public C getContents(IScope var1) throws GamaRuntimeException;

    @GamlAnnotations.getter(value="attributes")
    public IList<String> getAttributes(IScope var1);

    @GamlAnnotations.getter(value="is_folder", initializer=true)
    public Boolean isFolder(IScope var1);

    @GamlAnnotations.getter(value="readable", initializer=true)
    public Boolean isReadable(IScope var1);

    @GamlAnnotations.getter(value="writable", initializer=true)
    public Boolean isWritable(IScope var1);

    public void save(IScope var1, Facets var2);

    public String getOriginalPath();

    @Override
    default public boolean containsKey(IScope iScope, Object object) {
        C c = this.getContents(iScope);
        return c != null && c.contains(iScope, object);
    }

    @Override
    default public String getId() {
        return this.getOriginalPath();
    }

    public URI getURIRelativeToWorkspace();

    default public boolean hasGeoDataAvailable(IScope iScope) {
        return false;
    }

    default public IModifiableContainer ensureContentsIsCompatible(IModifiableContainer iModifiableContainer) {
        return iModifiableContainer;
    }

    public static interface Drawable {
    }
}

