/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions;

import gama.core.common.util.StringUtils;
import gama.core.runtime.IScope;
import gama.gaml.expressions.AbstractExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;

public class ConstantExpression
extends AbstractExpression {
    protected Object value;

    public ConstantExpression(Object object, IType<?> iType, String string) {
        this.value = object;
        this.type = iType;
        this.setName(string);
    }

    public ConstantExpression(Object object, IType<?> iType) {
        this(object, iType, object == null ? "nil" : object.toString());
    }

    public ConstantExpression(Object object) {
        this(object, GamaType.of(object));
    }

    @Override
    public Object _value(IScope iScope) {
        return this.value;
    }

    @Override
    public boolean isConst() {
        return true;
    }

    public String toString() {
        return this.value == null ? "nil" : this.value.toString();
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return StringUtils.toGaml(this.value, bl);
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        return new IGamlDescription.ConstantDoc("Literal expression of type " + this.getGamlType().getName());
    }

    @Override
    public String getTitle() {
        return this.literalValue();
    }

    @Override
    public boolean shouldBeParenthesized() {
        return false;
    }

    @Override
    public IExpression resolveAgainst(IScope iScope) {
        return this;
    }
}

