/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.IOperatorValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Maths;
import org.eclipse.emf.ecore.EObject;

public class Points {
    @GamlAnnotations.operator(value={"point"}, can_be_const=true, category={"Points-related operators"}, internal=true)
    @validator(value=PointValidator.class)
    public static GamaPoint toPoint(IScope iScope, IExpression iExpression, IExpression iExpression2) {
        double d = Cast.asFloat(iScope, iExpression.value(iScope));
        double d2 = Cast.asFloat(iScope, iExpression2.value(iScope));
        return new GamaPoint(d, d2);
    }

    @GamlAnnotations.operator(value={"point"}, can_be_const=true, category={"Points-related operators"}, internal=true)
    @validator(value=PointValidator.class)
    public static GamaPoint toPoint(IScope iScope, IExpression iExpression, IExpression iExpression2, IExpression iExpression3) {
        double d = Cast.asFloat(iScope, iExpression.value(iScope));
        double d2 = Cast.asFloat(iScope, iExpression2.value(iScope));
        double d3 = Cast.asFloat(iScope, iExpression3.value(iScope));
        return new GamaPoint(d, d2, d3);
    }

    @GamlAnnotations.operator(value={"/"}, can_be_const=true, category={"Points-related operators"}, concept={"point"})
    @GamlAnnotations.doc(value="Returns a point with coordinates divided by the number", usages={@GamlAnnotations.usage(value="if the left operand is a point, returns a new point with coordinates divided by the right operand", examples={@GamlAnnotations.example(value="{5, 7.5} / 2.5", equals="{2, 3}"), @GamlAnnotations.example(value="{2,5} / 4", equals="{0.5,1.25}")})})
    @GamlAnnotations.test(value="{5, 7.5} / 2.5 = {2,3}")
    public static GamaPoint divide(IScope iScope, GamaPoint gamaPoint, Double d) {
        if (d == 0.0) {
            throw GamaRuntimeException.error("Division by zero", iScope);
        }
        return new GamaPoint(gamaPoint.x / d, gamaPoint.y / d, gamaPoint.z / d);
    }

    @GamlAnnotations.operator(value={"/"}, can_be_const=true, category={"Points-related operators"}, concept={})
    @GamlAnnotations.doc(value="Returns a point with coordinates divided by the number")
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="{2,5} / 4 = {0.5,1.25}"), @GamlAnnotations.test(value="is_error({2,5} / 0)")})
    public static GamaPoint divide(IScope iScope, GamaPoint gamaPoint, Integer n) {
        if (n == 0) {
            throw GamaRuntimeException.error("Division by zero", iScope);
        }
        return new GamaPoint(gamaPoint.x / n.doubleValue(), gamaPoint.y / n.doubleValue(), gamaPoint.z / n.doubleValue());
    }

    @GamlAnnotations.operator(value={"*"}, can_be_const=true, category={"Points-related operators"}, concept={"point"})
    @GamlAnnotations.doc(value="Returns a point with coordinates multiplied by a number.")
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="{2,5} * 4.0 = {8.0,20.0}"), @GamlAnnotations.test(value="{2,5} * 0.0 = {0.0,0.0}")})
    public static GamaPoint multiply(GamaPoint gamaPoint, Double d) {
        if (gamaPoint == null) {
            return new GamaPoint();
        }
        return new GamaPoint(gamaPoint.x * d, gamaPoint.y * d, gamaPoint.z * d);
    }

    @GamlAnnotations.operator(value={"*"}, can_be_const=true, category={"Points-related operators"}, concept={})
    @GamlAnnotations.doc(value="Returns a point with coordinates multiplied by a number.", usages={@GamlAnnotations.usage(value="if the left-hand operator is a point and the right-hand a number, returns a point with coordinates multiplied by the number", examples={@GamlAnnotations.example(value="{2,5} * 4", equals="{8.0, 20.0}"), @GamlAnnotations.example(value="{2, 4} * 2.5", equals="{5.0, 10.0}")})})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="{2,5} * 4 = {8,20}"), @GamlAnnotations.test(value="{2,5} * 0 = {0,0}")})
    public static GamaPoint multiply(GamaPoint gamaPoint, Integer n) {
        if (gamaPoint == null) {
            return new GamaPoint();
        }
        return new GamaPoint(gamaPoint.x * n.doubleValue(), gamaPoint.y * n.doubleValue(), gamaPoint.z * n.doubleValue());
    }

    @GamlAnnotations.operator(value={"*"}, can_be_const=true, category={"Points-related operators"}, concept={})
    @GamlAnnotations.doc(value="Returns the scalar product of two points.", usages={@GamlAnnotations.usage(value="if both operands are points, returns their scalar product", examples={@GamlAnnotations.example(value="{2,5} * {4.5, 5}", equals="34.0")})})
    @GamlAnnotations.test(value="{2,5} * {4.5, 5} = 34.0")
    public static Double multiply(GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        if (gamaPoint == null || gamaPoint2 == null) {
            return 0.0;
        }
        return gamaPoint.x * gamaPoint2.x + gamaPoint.y * gamaPoint2.y + gamaPoint.z * gamaPoint2.z;
    }

    @GamlAnnotations.operator(value={"norm"}, can_be_const=true, category={"Points-related operators"}, concept={"point"})
    @GamlAnnotations.doc(value="the norm of the vector with the coordinates of the point operand.", examples={@GamlAnnotations.example(value="norm({3,4})", equals="5.0")})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="norm({3,4}) = 5.0", name="Regular"), @GamlAnnotations.test(value="norm({1,1}) = sqrt(2)", name="Not"), @GamlAnnotations.test(value="norm({0,0}) = 0.0"), @GamlAnnotations.test(value="norm({1,0}) = norm({0,1})")})
    public static Double norm(IScope iScope, GamaPoint gamaPoint) throws GamaRuntimeException {
        if (gamaPoint == null) {
            return 0.0;
        }
        return Maths.sqrt(iScope, gamaPoint.x * gamaPoint.x + gamaPoint.y * gamaPoint.y + gamaPoint.z * gamaPoint.z);
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, category={"Points-related operators"}, concept={"point"})
    @GamlAnnotations.doc(value="Returns a point with coordinate summing of the two operands.", usages={@GamlAnnotations.usage(value="if both operands are points, returns their sum.", examples={@GamlAnnotations.example(value="{1, 2} + {4, 5}", equals="{5.0, 7.0}")})})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="{1, 2} + {4, 5} = {5,7}"), @GamlAnnotations.test(value="point p <- {1, 2}; p + {0, 0} = p", warning=true)})
    public static GamaPoint add(GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        if (gamaPoint == null) {
            return gamaPoint2;
        }
        if (gamaPoint2 == null) {
            return gamaPoint;
        }
        return new GamaPoint(gamaPoint.x + gamaPoint2.x, gamaPoint.y + gamaPoint2.y, gamaPoint.z + gamaPoint2.z);
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, category={"Points-related operators"}, concept={})
    @GamlAnnotations.doc(value="Returns a point with coordinate summing of the two operands.", usages={@GamlAnnotations.usage(value="if the left-hand operand is a point and the right-hand a number, returns a new point with each coordinate as the sum of the operand coordinate with this number.", examples={@GamlAnnotations.example(value="{1, 2} + 4.5", equals="{5.5, 6.5,4.5}")})})
    public static GamaPoint add(GamaPoint gamaPoint, Double d) {
        if (gamaPoint == null) {
            return new GamaPoint(d, d, d);
        }
        return new GamaPoint(gamaPoint.x + d, gamaPoint.y + d, gamaPoint.z + d);
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, category={"Points-related operators"}, concept={})
    @GamlAnnotations.doc(value="Returns a point with coordinate summing of the two operands.", examples={@GamlAnnotations.example(value="{1, 2} + 4", equals="{5.0, 6.0,4.0}")})
    public static GamaPoint add(GamaPoint gamaPoint, Integer n) {
        if (gamaPoint == null) {
            return new GamaPoint(n.intValue(), n.intValue(), n.intValue());
        }
        return new GamaPoint(gamaPoint.x + (double)n.intValue(), gamaPoint.y + (double)n.intValue(), gamaPoint.z + (double)n.intValue());
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, category={"Points-related operators"}, concept={"point"})
    @GamlAnnotations.doc(value="Returns a point with coordinate resulting from the first operand minus the second operand.", usages={@GamlAnnotations.usage(value="if left-hand operand is a point and the right-hand a number, returns a new point with each coordinate as the difference of the operand coordinate with this number.", examples={@GamlAnnotations.example(value="{1, 2} - 4.5", equals="{-3.5, -2.5, -4.5}"), @GamlAnnotations.example(value="{1, 2} - 4", equals="{-3.0,-2.0,-4.0}")})})
    public static GamaPoint subtract(GamaPoint gamaPoint, Double d) {
        if (gamaPoint == null) {
            return new GamaPoint(-d.doubleValue(), -d.doubleValue(), -d.doubleValue());
        }
        return new GamaPoint(gamaPoint.x - d, gamaPoint.y - d, gamaPoint.z - d);
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, category={"Points-related operators"}, concept={"point"})
    @GamlAnnotations.doc(value="Returns a point with coordinate resulting from the negation of the operand", usages={@GamlAnnotations.usage(value="", examples={@GamlAnnotations.example(value="-{3.0,5.0}", equals="{-3.0,-5.0}"), @GamlAnnotations.example(value="-{1.0,6.0,7.0}", equals="{-1.0,-6.0,-7.0}")})})
    public static GamaPoint subtract(GamaPoint gamaPoint) {
        return new GamaPoint(-gamaPoint.x, -gamaPoint.y, -gamaPoint.z);
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, category={"Points-related operators"}, concept={})
    @GamlAnnotations.doc(value="Returns a point with coordinate resulting from the first operand minus the second operand.", usages={@GamlAnnotations.usage(value="if both operands are points, returns their difference (coordinates per coordinates).", examples={@GamlAnnotations.example(value="{1, 2} - {4, 5}", equals="{-3.0, -3.0}")})})
    public static GamaPoint subtract(GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        if (gamaPoint2 == null) {
            return gamaPoint;
        }
        if (gamaPoint == null) {
            return gamaPoint2.negated();
        }
        return new GamaPoint(gamaPoint.x - gamaPoint2.x, gamaPoint.y - gamaPoint2.y, gamaPoint.z - gamaPoint2.z);
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, category={"Points-related operators"}, concept={})
    @GamlAnnotations.doc(value="Returns a point with coordinate resulting from the first operand minus the second operand.", examples={@GamlAnnotations.example(value="{2.0,3.0,4.0} - 1", equals="{1.0,2.0,3.0}")})
    @GamlAnnotations.test(value="{2.0,3.0,4.0} - 1 = {1.0,2.0,3.0}")
    public static GamaPoint subtract(GamaPoint gamaPoint, Integer n) {
        if (gamaPoint == null) {
            return new GamaPoint(-n.intValue(), -n.intValue(), -n.intValue());
        }
        return new GamaPoint(gamaPoint.x - (double)n.intValue(), gamaPoint.y - (double)n.intValue(), gamaPoint.z - (double)n.intValue());
    }

    @GamlAnnotations.operator(value={"with_precision"}, can_be_const=true, concept={"point"})
    @GamlAnnotations.doc(value="Rounds off the ordinates of the left-hand point to the precision given by the value of right-hand operand", examples={@GamlAnnotations.example(value="{12345.78943, 12345.78943, 12345.78943} with_precision 2 ", equals="{12345.79, 12345.79, 12345.79}")}, see={"round"})
    public static GamaPoint round(GamaPoint gamaPoint, Integer n) {
        if (gamaPoint == null) {
            return null;
        }
        return new GamaPoint(Maths.round(gamaPoint.getX(), n), Maths.round(gamaPoint.getY(), n), Maths.round(gamaPoint.getZ(), n));
    }

    @GamlAnnotations.operator(value={"round"}, can_be_const=true, concept={"point"})
    @GamlAnnotations.doc(value="Returns the rounded value of the operand.", examples={@GamlAnnotations.example(value="{12345.78943,  12345.78943, 12345.78943} with_precision 2", equals="{12345.79,12345.79,12345.79}")}, see={"round"})
    @GamlAnnotations.test(value="{12345.78943,  12345.78943, 12345.78943} with_precision 2 = {12345.79,12345.79,12345.79}")
    public static GamaPoint round(GamaPoint gamaPoint) {
        if (gamaPoint == null) {
            return null;
        }
        return new GamaPoint(Maths.round(gamaPoint.getX()).intValue(), Maths.round(gamaPoint.getY()).intValue(), Maths.round(gamaPoint.getZ()).intValue());
    }

    public static class PointValidator
    implements IOperatorValidator {
        @Override
        public boolean validate(IDescription iDescription, EObject eObject, IExpression ... iExpressionArray) {
            IExpression[] iExpressionArray2 = iExpressionArray;
            int n = iExpressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExpression iExpression = iExpressionArray2[n2];
                if (!iExpression.getGamlType().isNumber()) {
                    iDescription.error("Points can only be built with int or float coordinates", "gaml.wrong.type.issue", eObject, new String[0]);
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

