/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import com.google.common.collect.FluentIterable;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.experiment.ExperimentPlan;
import gama.core.kernel.experiment.IExperimentDisplayable;
import gama.core.kernel.model.IModel;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.kernel.simulation.SimulationPopulation;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.gaml.architecture.user.UserInputStatement;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IStatement;
import java.util.ArrayList;
import java.util.List;

@GamlAnnotations.inside(kinds={0, 13, 1}, symbols={"user_panel"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="continue", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether or not the button, when clicked, should dismiss the user panel it is defined in. Has no effect in other contexts (menu, parameters, inspectors)")}), @GamlAnnotations.facet(name="color", type={6}, optional=true, doc={@GamlAnnotations.doc(value="The color of the button to display")}), @GamlAnnotations.facet(name="category", type={4}, optional=true, doc={@GamlAnnotations.doc(value="a category label, used to group parameters in the interface")}), @GamlAnnotations.facet(name="action", type={26}, optional=true, doc={@GamlAnnotations.doc(value="the identifier of the action to be executed. This action should be accessible in the context in which the user_command is defined (an experiment, the global section or a species). A special case is allowed to maintain the compatibility with older versions of GAMA, when the user_command is declared in an experiment and the action is declared in 'global'. In that case, all the simulations managed by the experiment will run the action in response to the user executing the command")}), @GamlAnnotations.facet(name="name", type={-200}, optional=false, doc={@GamlAnnotations.doc(value="the identifier of the user_command")}), @GamlAnnotations.facet(name="when", type={3}, optional=true, doc={@GamlAnnotations.doc(value="the condition that should be fulfilled (in addition to the user clicking it) in order to execute this action")}), @GamlAnnotations.facet(name="with", type={10}, optional=true, doc={@GamlAnnotations.doc(value="the map of the parameters::values required by the action")})}, omissible="name")
@GamlAnnotations.doc(value="Anywhere in the global block, in a species or in an (GUI) experiment, user_command statements allows to either call directly an existing action (with or without arguments) or to be followed by a block that describes what to do when this command is run.", usages={@GamlAnnotations.usage(value="The general syntax is for example:", examples={@GamlAnnotations.example(value="user_command kill_myself action: some_action with: [arg1::val1, arg2::val2, ...];", isExecutable=false)})}, see={"user_init", "user_panel", "user_input"})
@validator(value=UserCommandValidator.class)
public class UserCommandStatement
extends AbstractStatementSequence
implements IStatement.WithArgs,
IExperimentDisplayable {
    Arguments args;
    Arguments runtimeArgs;
    final String actionName;
    String category;
    final IExpression when;
    List<UserInputStatement> inputs = new ArrayList<UserInputStatement>();

    public UserCommandStatement(IDescription iDescription) {
        super(iDescription);
        this.setName(iDescription.getName());
        this.actionName = this.getLiteral("action");
        this.category = iDescription.getLitteral("category");
        this.when = this.getFacet("when");
    }

    public List<UserInputStatement> getInputs() {
        return this.inputs;
    }

    @Override
    public void setFormalArgs(Arguments arguments) {
        this.args = arguments;
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        for (ISymbol iSymbol2 : iterable) {
            if (!(iSymbol2 instanceof UserInputStatement)) continue;
            this.inputs.add((UserInputStatement)iSymbol2);
        }
        super.setChildren((Iterable<? extends ISymbol>)FluentIterable.from(iterable).filter(iSymbol -> !this.inputs.contains(iSymbol)));
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        if (this.isEnabled(iScope)) {
            if (this.actionName == null) {
                if (this.runtimeArgs != null) {
                    iScope.stackArguments(this.runtimeArgs);
                }
                for (UserInputStatement object2 : this.inputs) {
                    if (iScope.execute(object2).passed()) continue;
                    return null;
                }
                Object iSpecies = super.privateExecuteIn(iScope);
                this.runtimeArgs = null;
                return iSpecies;
            }
            ISpecies iSpecies = iScope.getAgent().getSpecies();
            IStatement.WithArgs withArgs = iSpecies.getAction(this.actionName);
            boolean bl = false;
            if (withArgs == null) {
                if (!(iSpecies instanceof ExperimentPlan)) {
                    throw GamaRuntimeException.error("Unknown action: " + this.actionName, iScope);
                }
                IModel iModel = ((ExperimentPlan)iSpecies).getModel();
                withArgs = iModel.getAction(this.actionName);
                bl = true;
            }
            Arguments arguments = new Arguments(this.args);
            if (this.runtimeArgs != null) {
                arguments.complementWith(this.runtimeArgs);
            }
            if (!bl) {
                Object object = iScope.execute(withArgs, arguments).getValue();
                this.runtimeArgs = null;
                return object;
            }
            SimulationPopulation simulationPopulation = iScope.getExperiment().getSimulationPopulation();
            for (SimulationAgent simulationAgent : simulationPopulation.iterable(iScope)) {
                iScope.execute(withArgs, simulationAgent, arguments);
            }
        }
        return null;
    }

    @Override
    public void setRuntimeArgs(IScope iScope, Arguments arguments) {
        this.runtimeArgs = arguments;
    }

    public boolean isEnabled(IScope iScope) {
        return this.when == null || Cast.asBool(iScope, this.when.value(iScope)) != false;
    }

    @Override
    public GamaColor getColor(IScope iScope) {
        IExpression iExpression = this.getFacet("color");
        if (iExpression == null) {
            return null;
        }
        return Cast.asColor(iScope, iExpression.value(iScope));
    }

    public boolean isContinue(IScope iScope) {
        IExpression iExpression = this.getFacet("continue");
        if (iExpression == null) {
            return false;
        }
        return Cast.asBool(iScope, iExpression.value(iScope));
    }

    @Override
    public String getCategory() {
        if (this.category == null) {
            this.category = IExperimentDisplayable.super.getCategory();
        }
        return this.category;
    }

    @Override
    public String getTitle() {
        return this.getName();
    }

    @Override
    public String getUnitLabel(IScope iScope) {
        return "";
    }

    @Override
    public void setUnitLabel(String string) {
    }

    @Override
    public boolean isDefinedInExperiment() {
        return false;
    }

    public static class UserCommandValidator
    extends IDescriptionValidator.ValidNameValidator {
        @Override
        public void validate(IDescription iDescription) {
            super.validate(iDescription);
            String string = iDescription.getLitteral("action");
            if (string != null && string.contains("__synthetic__")) {
                iDescription.warning("This use of 'action' is deprecated. Move the sequence to execute at the end of the 'user_command' statement instead.", "gaml.deprecated.code.issue", "action", null);
            }
            IDescription iDescription2 = iDescription.getEnclosingDescription();
            if (string != null && iDescription2.getAction(string) == null) {
                if (iDescription2 instanceof ExperimentDescription) {
                    ModelDescription modelDescription = iDescription2.getModelDescription();
                    if (modelDescription.hasAction(string, false)) {
                        iDescription.warning("Action " + string + " should be defined in the experiment, not in global. To maintain the compatibility with GAMA 1.6.1, the command will execute it on all the simulations managed by this experiment", "gaml.wrong.context.issue", "action", new String[0]);
                    } else {
                        iDescription.error("Action " + string + " does not exist in this experiment", "gaml.unknown.action.issue", "action", new String[0]);
                    }
                } else {
                    String string2 = iDescription2 instanceof ModelDescription ? "global" : iDescription2.getName();
                    iDescription.error("Action " + string + " does not exist in " + string2, "gaml.unknown.action.issue", "action", new String[0]);
                }
            }
        }
    }
}

