/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.GamaMatrix;
import gama.core.util.matrix.GamaObjectMatrix;
import gama.core.util.matrix.IField;
import gama.core.util.matrix.IMatrix;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.data.MapExpression;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaContainerType;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Arrays;
import java.util.stream.IntStream;

@GamlAnnotations.type(name="matrix", id=8, wraps={IMatrix.class, GamaIntMatrix.class, GamaFloatMatrix.class, GamaObjectMatrix.class}, kind=102, concept={"type", "container", "matrix"}, doc={@GamlAnnotations.doc(value="Matrices are 2-dimensional containers that can contain any type of date (not only floats or integers). They can be accessed with a point index or by rows / columns")})
public class GamaMatrixType
extends GamaContainerType<IMatrix> {
    public static IMatrix staticCast(IScope iScope, Object object, Object object2, IType iType, boolean bl) {
        GamaPoint gamaPoint;
        if (object == null && object2 == null) {
            return null;
        }
        GamaPoint gamaPoint2 = gamaPoint = object2 instanceof GamaPoint ? (GamaPoint)object2 : null;
        if (gamaPoint == null) {
            if (object instanceof IContainer) {
                return ((IContainer)object).matrixValue(iScope, iType, bl);
            }
            return GamaMatrixType.with(iScope, object, new GamaPoint(1.0, 1.0), iType);
        }
        if (gamaPoint.x <= 0.0 || gamaPoint.y < 0.0) {
            throw GamaRuntimeException.error("Dimensions of a matrix should be positive.", iScope);
        }
        if (object instanceof IContainer) {
            return ((IContainer)object).matrixValue(iScope, iType, gamaPoint, bl);
        }
        return GamaMatrixType.with(iScope, object, gamaPoint, iType);
    }

    @Override
    public IMatrix cast(IScope iScope, Object object, Object object2, IType iType, IType iType2, boolean bl) throws GamaRuntimeException {
        return GamaMatrixType.staticCast(iScope, object, object2, iType2, bl);
    }

    public static IMatrix from(IScope iScope, IList iList, IType iType, GamaPoint gamaPoint) {
        if (iList == null || iList.isEmpty()) {
            return new GamaObjectMatrix(0, 0, iType);
        }
        if (iType.id() == 1) {
            return new GamaIntMatrix(iScope, iList, gamaPoint);
        }
        if (iType.id() == 2) {
            return new GamaFloatMatrix(iScope, iList, gamaPoint);
        }
        return new GamaObjectMatrix(iScope, iList, gamaPoint, iType);
    }

    public static IMatrix from(IScope iScope, IMatrix iMatrix, IType iType, GamaPoint gamaPoint, boolean bl) {
        int n;
        int n2;
        IType<?> iType2 = iMatrix.getGamlType().getContentType();
        if (!GamaType.requiresCasting(iType, iType2)) {
            if (iMatrix instanceof IField) {
                IField iField = (IField)iMatrix;
                return GamaFloatMatrix.from(iScope, iField);
            }
            return iMatrix.copy(iScope, gamaPoint, bl);
        }
        if (gamaPoint == null) {
            n2 = iMatrix.getCols(iScope);
            n = iMatrix.getRows(iScope);
        } else {
            n2 = (int)gamaPoint.getX();
            n = (int)gamaPoint.getY();
        }
        switch (iType.id()) {
            case 1: {
                return GamaIntMatrix.from(iScope, n2, n, iMatrix);
            }
            case 2: {
                return GamaFloatMatrix.from(iScope, n2, n, iMatrix);
            }
        }
        GamaObjectMatrix gamaObjectMatrix = GamaObjectMatrix.from(n2, n, iMatrix);
        Object[] objectArray = gamaObjectMatrix.getMatrix();
        int n3 = 0;
        while (n3 < objectArray.length) {
            objectArray[n3] = iType.cast(iScope, objectArray[n3], null, false);
            ++n3;
        }
        return gamaObjectMatrix;
    }

    public static IMatrix with(IScope iScope, IExpression iExpression, GamaPoint gamaPoint, boolean bl) throws GamaRuntimeException {
        return GamaMatrixType.with(iScope, iExpression, (int)gamaPoint.x, (int)gamaPoint.y, bl);
    }

    public static IMatrix with(IScope iScope, IExpression iExpression, int n, int n2, boolean bl) {
        GamaMatrix gamaMatrix;
        if (iExpression == null) {
            return new GamaObjectMatrix(n, n2, Types.NO_TYPE);
        }
        switch (iExpression.getGamlType().id()) {
            case 2: {
                gamaMatrix = new GamaFloatMatrix(n, n2);
                double[] dArray = gamaMatrix.getMatrix();
                if (iExpression.isConst()) {
                    Arrays.fill(dArray, Cast.asFloat(iScope, iExpression.value(iScope)));
                    break;
                }
                if (!bl) {
                    int n3 = 0;
                    while (n3 < dArray.length) {
                        dArray[n3] = Cast.asFloat(iScope, iExpression.value(iScope));
                        ++n3;
                    }
                    break;
                }
                GamaExecutorService.executeThreaded(() -> IntStream.range(0, dArray.length).parallel().forEach(n -> {
                    dArray[n] = Cast.asFloat(iScope, iExpression.value(iScope));
                }));
                break;
            }
            case 1: {
                gamaMatrix = new GamaIntMatrix(n, n2);
                int[] nArray = ((GamaIntMatrix)gamaMatrix).getMatrix();
                if (iExpression.isConst()) {
                    Arrays.fill(nArray, Cast.asInt(iScope, iExpression.value(iScope)));
                    break;
                }
                if (!bl) {
                    int n4 = 0;
                    while (n4 < nArray.length) {
                        nArray[n4] = Cast.asInt(iScope, iExpression.value(iScope));
                        ++n4;
                    }
                    break;
                }
                GamaExecutorService.executeThreaded(() -> IntStream.range(0, nArray.length).parallel().forEach(n -> {
                    nArray[n] = Cast.asInt(iScope, iExpression.value(iScope));
                }));
                break;
            }
            default: {
                gamaMatrix = new GamaObjectMatrix(n, n2, iExpression.getGamlType());
                Object[] objectArray = ((GamaObjectMatrix)gamaMatrix).getMatrix();
                if (iExpression.isConst()) {
                    Arrays.fill(objectArray, iExpression.value(iScope));
                    break;
                }
                if (!bl) {
                    int n5 = 0;
                    while (n5 < objectArray.length) {
                        objectArray[n5] = iExpression.value(iScope);
                        ++n5;
                    }
                    break;
                }
                GamaExecutorService.executeThreaded(() -> IntStream.range(0, objectArray.length).parallel().forEach(n -> {
                    objectArray[n] = iExpression.value(iScope);
                }));
            }
        }
        return gamaMatrix;
    }

    public static IMatrix with(IScope iScope, Object object, GamaPoint gamaPoint, IType iType) throws GamaRuntimeException {
        return GamaMatrixType.withObject(iScope, object, (int)gamaPoint.x, (int)gamaPoint.y, iType);
    }

    public static IMatrix withObject(IScope iScope, Object object, int n, int n2, IType iType) throws GamaRuntimeException {
        if (iType == Types.INT || object instanceof Integer) {
            GamaIntMatrix gamaIntMatrix = new GamaIntMatrix(n, n2);
            gamaIntMatrix.setAllValues(iScope, Types.INT.cast(iScope, object, null, false));
            return gamaIntMatrix;
        }
        if (iType == Types.FLOAT || object instanceof Double) {
            GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(n, n2);
            gamaFloatMatrix.setAllValues(iScope, Types.FLOAT.cast(iScope, object, null, false));
            return gamaFloatMatrix;
        }
        GamaObjectMatrix gamaObjectMatrix = new GamaObjectMatrix(n, n2, iType);
        gamaObjectMatrix.setAllValues(iScope, iType.cast(iScope, object, null, false));
        return gamaObjectMatrix;
    }

    @Override
    public IType getKeyType() {
        return Types.POINT;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public IType contentsTypeIfCasting(IExpression iExpression) {
        IType<?> iType = iExpression.getGamlType();
        IType<?> iType2 = iType.getContentType();
        if (iType.id() == 5 && iType2.id() == 5) {
            if (!(iExpression instanceof MapExpression)) {
                return iType2.getContentType();
            }
            MapExpression mapExpression = (MapExpression)iExpression;
            IExpression[] iExpressionArray = mapExpression.valuesArray();
            if (iExpressionArray.length == 0) {
                return Types.NO_TYPE;
            }
            return iExpressionArray[0].getGamlType().getContentType();
        }
        if (Types.CONTAINER.isAssignableFrom(iType)) {
            return iType.getContentType();
        }
        return iType;
    }

    @Override
    public boolean canCastToConst() {
        return true;
    }

    @Override
    public IMatrix deserializeFromJson(IScope iScope, IMap<String, Object> iMap) {
        IType iType = (IType)iMap.remove("requested_type");
        IList iList = (IList)iMap.get("contents");
        Integer n = (Integer)iMap.get("cols");
        Integer n2 = (Integer)iMap.get("rows");
        GamaPoint gamaPoint = new GamaPoint(n.intValue(), n2.intValue());
        return GamaMatrixType.from(iScope, iList, iType.getContentType(), gamaPoint);
    }
}

