/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.filter;

import com.google.common.collect.Iterables;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.population.IPopulationSet;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.metamodel.topology.graph.ISpatialGraph;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class In
implements IAgentFilter {
    public static IAgentFilter list(IScope iScope, IContainer<?, ? extends IShape> iContainer) {
        if (iContainer.isEmpty(iScope)) {
            return null;
        }
        if (iContainer instanceof IPopulationSet) {
            return (IPopulationSet)iContainer;
        }
        ISpecies iSpecies = iContainer.getGamlType().getContentType().isAgentType() ? Cast.asSpecies(iScope, iContainer.getGamlType().getContentType().getSpeciesName()) : null;
        return new InList(iContainer.listValue(iScope, Types.NO_TYPE, false), iSpecies);
    }

    public static IAgentFilter edgesOf(ISpatialGraph iSpatialGraph) {
        return iSpatialGraph;
    }

    private static class InList
    extends In {
        final Set<IShape> agents;
        ISpecies species;

        InList(IList<? extends IShape> iList, ISpecies iSpecies) {
            this.agents = new LinkedHashSet<IShape>(iList);
            this.species = iSpecies;
        }

        @Override
        public boolean accept(IScope iScope, IShape iShape, IShape iShape2) {
            return (iShape == null || iShape2.getGeometry() != iShape.getGeometry()) && this.agents.contains(iShape2);
        }

        @Override
        public boolean hasAgentList() {
            return true;
        }

        @Override
        public IContainer<?, ? extends IAgent> getAgents(IScope iScope) {
            return GamaListFactory.createWithoutCasting(Types.AGENT, Iterables.filter(this.agents, IAgent.class));
        }

        @Override
        public ISpecies getSpecies() {
            return this.species;
        }

        @Override
        public IPopulation<? extends IAgent> getPopulation(IScope iScope) {
            if (this.species == null) {
                return null;
            }
            return iScope.getSimulation().getPopulationFor(this.species);
        }

        @Override
        public void filter(IScope iScope, IShape iShape, Collection<? extends IShape> collection) {
            this.agents.remove(iShape);
            collection.retainAll(this.agents);
        }
    }
}

