/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.grid;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.topology.grid.GamaSpatialMatrix;
import gama.core.metamodel.topology.grid.INeighborhood;
import gama.core.runtime.IScope;
import gama.core.util.Collector;
import java.util.Set;

public abstract class GridNeighborhood
implements INeighborhood {
    protected final GamaSpatialMatrix matrix;
    protected int[][] neighbors;
    protected int[][] neighborsIndexes;

    public GridNeighborhood(GamaSpatialMatrix gamaSpatialMatrix) {
        this.matrix = gamaSpatialMatrix;
        this.neighbors = new int[gamaSpatialMatrix.matrix.length][0];
        this.neighborsIndexes = new int[gamaSpatialMatrix.matrix.length][];
    }

    @Override
    public int[] getRawNeighborsIncluding(IScope iScope, int n, int n2) {
        int n3;
        int[] nArray = this.neighborsIndexes[n];
        if (nArray == null) {
            nArray = new int[]{};
            this.neighborsIndexes[n] = nArray;
        }
        if (n2 > (n3 = nArray.length)) {
            this.computeNeighborsFrom(n, n3 + 1, n2);
        }
        return this.neighbors[n];
    }

    protected abstract Set<Integer> getNeighborsAtRadius(int var1, int var2);

    private void computeNeighborsFrom(int n, int n2, int n3) {
        int n4 = n2;
        while (n4 <= n3) {
            int n5 = n4 == 1 ? 0 : this.neighborsIndexes[n][n4 - 2];
            Set<Integer> set = this.getNeighborsAtRadius(n, n4);
            int[] nArray = new int[set.size()];
            int n6 = 0;
            for (Integer n7 : set) {
                nArray[n6++] = n7;
            }
            int n8 = nArray.length;
            Object object = new int[this.neighbors[n].length + n8];
            if (this.neighbors[n].length != 0) {
                System.arraycopy(this.neighbors[n], 0, object, 0, this.neighbors[n].length);
            }
            System.arraycopy(nArray, 0, object, this.neighbors[n].length, n8);
            this.neighbors[n] = (int[])object;
            this.addToNeighborsIndex(n, n5 + n8);
            ++n4;
        }
    }

    private final void addToNeighborsIndex(int n, int n2) {
        int[] nArray = this.neighborsIndexes[n];
        int[] nArray2 = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[nArray.length] = n2;
        this.neighborsIndexes[n] = nArray2;
    }

    @Override
    public int neighborsIndexOf(IScope iScope, int n, int n2) {
        if (n2 == 1) {
            return 0;
        }
        int n3 = this.neighborsIndexes[n].length;
        if (n2 > n3) {
            return this.neighbors[n].length - 1;
        }
        return this.neighborsIndexes[n][n2 - 2];
    }

    @Override
    public Set<IAgent> getNeighborsIn(IScope iScope, int n, int n2) {
        int n3;
        int[] nArray = this.neighborsIndexes[n];
        if (nArray == null) {
            nArray = new int[]{};
            this.neighborsIndexes[n] = nArray;
        }
        if (n2 > (n3 = nArray.length)) {
            this.computeNeighborsFrom(n, n3 + 1, n2);
        }
        int[] nArray2 = this.neighbors[n];
        int n4 = this.neighborsIndexes[n][n2 - 1];
        Throwable throwable = null;
        Object var9_10 = null;
        try (Collector.AsOrderedSet asOrderedSet = Collector.getOrderedSet();){
            int n5 = 0;
            while (n5 < n4) {
                asOrderedSet.add(this.matrix.matrix[nArray2[n5]].getAgent());
                ++n5;
            }
            asOrderedSet.shuffleInPlaceWith(iScope.getRandom());
            return asOrderedSet.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void clear() {
        this.neighbors = null;
        this.neighborsIndexes = null;
    }
}

