/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IEventLayerDelegate;
import gama.core.metamodel.agent.IAgent;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.layers.AbstractLayerStatement;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.statements.ActionStatement;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import java.util.ArrayList;
import java.util.List;

@GamlAnnotations.inside(symbols={"display"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={4}, optional=false, doc={@GamlAnnotations.doc(value="the type of event captured: basic events include #mouse_up, #mouse_down, #mouse_move, #mouse_exit, #mouse_enter, #mouse_menu, #mouse_drag, #arrow_down, #arrow_up, #arrow_left, #arrow_right, #escape, #tab, #enter, #page_up, #page_down or a character")}), @GamlAnnotations.facet(name="type", type={4}, optional=true, doc={@GamlAnnotations.doc(value="Type of device used to generate events. Defaults to 'default', which encompasses keyboard and mouse")}), @GamlAnnotations.facet(name="action", type={26}, optional=true, doc={@GamlAnnotations.doc(value="The identifier of the action to be executed in the context of the simulation. This action needs to be defined in 'global' or in the current experiment, without any arguments. The location of the mouse in the world can be retrieved in this action with the pseudo-constant #user_location")})}, omissible="name")
@validator(value=EventLayerValidator.class)
@GamlAnnotations.doc(value="`event` allows to interact with the simulation by capturing mouse or key events and doing an action. The name of this action can be defined with the 'action:' facet, in which case the action needs to be defined in 'global' or in the current experiment, without any arguments. The location of the mouse in the world can be retrieved in this action with the pseudo-constant #user_location. The statements to execute can also be defined in the block at the end of this statement, in which case they will be executed in the context of the experiment", usages={@GamlAnnotations.usage(value="The general syntax is:", examples={@GamlAnnotations.example(value="event [event_type] action: myAction;", isExecutable=false)}), @GamlAnnotations.usage(value="For instance:", examples={@GamlAnnotations.example(value="global {", isExecutable=false), @GamlAnnotations.example(value="   // ... ", isExecutable=false), @GamlAnnotations.example(value="   action myAction () {", isExecutable=false), @GamlAnnotations.example(value="      point loc <- #user_location; // contains the location of the mouse in the world", isExecutable=false), @GamlAnnotations.example(value="      list<agent> selected_agents <- agents inside (10#m around loc); // contains agents clicked by the event", isExecutable=false), @GamlAnnotations.example(value="      ", isExecutable=false), @GamlAnnotations.example(value="      // code written by modelers", isExecutable=false), @GamlAnnotations.example(value="   }", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false), @GamlAnnotations.example(value="experiment Simple type:gui {", isExecutable=false), @GamlAnnotations.example(value="   display my_display {", isExecutable=false), @GamlAnnotations.example(value="      event #mouse_up action: myAction;", isExecutable=false), @GamlAnnotations.example(value="   }", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"display", "agents", "chart", "graphics", "display_grid", "image_layer", "overlay", "species_layer"})
public class EventLayerStatement
extends AbstractLayerStatement {
    private boolean executesInSimulation = false;
    private final IExpression type;
    public static final List<IEventLayerDelegate> delegates = new ArrayList<IEventLayerDelegate>();
    private String actionName;
    private ActionStatement action;

    public static void addDelegate(IEventLayerDelegate iEventLayerDelegate) {
        delegates.add(iEventLayerDelegate);
    }

    public EventLayerStatement(IDescription iDescription) throws GamaRuntimeException {
        super(iDescription);
        if (this.description.hasFacet("action")) {
            this.actionName = this.description.getLitteral("action");
            ActionDescription actionDescription = this.description.getSpeciesContext().getAction(this.actionName);
            this.executesInSimulation = actionDescription == null;
        }
        this.type = this.getFacet("type");
    }

    public IAgent getExecuter(IScope iScope) {
        return this.executesInSimulation ? iScope.getSimulation() : iScope.getExperiment();
    }

    public boolean executesInSimulation() {
        return this.executesInSimulation;
    }

    public IExecutable getExecutable(IScope iScope) {
        if (this.action != null) {
            return this.action;
        }
        IAgent iAgent = this.getExecuter(iScope);
        return iAgent == null ? null : iAgent.getSpecies().getAction(this.actionName);
    }

    @Override
    public boolean _init(IScope iScope) throws GamaRuntimeException {
        Object object = this.getSource(iScope);
        for (IEventLayerDelegate iEventLayerDelegate : delegates) {
            if (!iEventLayerDelegate.acceptSource(iScope, object)) continue;
            iEventLayerDelegate.createFrom(iScope, object, this);
        }
        return true;
    }

    @Override
    public ILayerStatement.LayerType getType(LayeredDisplayOutput layeredDisplayOutput) {
        return ILayerStatement.LayerType.EVENT;
    }

    public String toString() {
        return "Event layer: " + this.getFacet("name").literalValue();
    }

    @Override
    protected boolean _step(IScope iScope) {
        return true;
    }

    private Object getSource(IScope iScope) {
        return this.type == null ? "default" : this.type.value(iScope);
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        ArrayList<IStatement> arrayList = new ArrayList<IStatement>();
        for (ISymbol iDisposable : iterable) {
            if (!(iDisposable instanceof IStatement)) continue;
            arrayList.add((IStatement)iDisposable);
        }
        if (!arrayList.isEmpty()) {
            this.actionName = "inline";
            IDescription iDescription = DescriptionFactory.create("action", this.getDescription(), "name", "inline");
            this.action = new ActionStatement(iDescription);
            this.action.setChildren(arrayList);
        }
    }

    public static class EventLayerValidator
    implements IDescriptionValidator<StatementDescription> {
        @Override
        public void validate(StatementDescription statementDescription) {
            CharSequence charSequence;
            String string;
            IExpressionDescription iExpressionDescription = statementDescription.getFacet("name");
            String string2 = string = iExpressionDescription != null ? iExpressionDescription.getExpression().literalValue() : null;
            if (string == null) {
                statementDescription.error("Impossible to find this action", "gaml.unknown.action.issue", "action", new String[0]);
                return;
            }
            if (string.length() > 1) {
                charSequence = new StringBuilder();
                boolean bl = false;
                for (IEventLayerDelegate object : delegates) {
                    ((StringBuilder)charSequence).append(object.getEvents()).append(" ");
                    if (!object.getEvents().contains(string)) continue;
                    bl = true;
                }
                if (!bl) {
                    statementDescription.error("No event can be triggered for '" + string + "'. Acceptable values are " + ((StringBuilder)charSequence).append(" or a character").toString(), "gaml.unknonw.argument.issue", "name", new String[0]);
                    return;
                }
            }
            if ((charSequence = statementDescription.getLitteral("action")) != null) {
                ActionDescription actionDescription;
                if (((String)charSequence).contains("__synthetic__")) {
                    statementDescription.warning("This use of 'action' is deprecated. Move the sequence to execute at the end of the 'event' statement instead.", "gaml.deprecated.code.issue", "action", new String[0]);
                }
                if ((actionDescription = statementDescription.getModelDescription().getAction((String)charSequence)) == null) {
                    SpeciesDescription speciesDescription = statementDescription.getSpeciesContext();
                    actionDescription = speciesDescription.getAction((String)charSequence);
                }
                if (actionDescription == null) {
                    statementDescription.error("Action '" + (String)charSequence + "' is not defined in neither 'global' nor 'experiment'", "gaml.unknown.action.issue", "action", new String[0]);
                } else if (actionDescription.getPassedArgs().size() > 0) {
                    statementDescription.error("Action '" + (String)charSequence + "' cannot have arguments. Use '#user_location' inside to obtain the location of the mouse, and compute the selected agents in the action using GAML spatial operators", "gaml.different.arguments.issue", "action", new String[0]);
                }
            }
        }
    }
}

